/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.utils;

import com.knightgost.knighttowns.data.Town;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BorderUtils {
    public static void showTownBorder(JavaPlugin plugin, Player player, Town town, int seconds) {
        if (town == null || town.getClaimedChunks().isEmpty()) {
            player.sendMessage("\u00a7cThis town has no claimed chunks to show.");
            return;
        }
        Set<String> claimed = town.getClaimedChunks();
        HashSet<Location> previewBlocks = new HashSet<Location>();
        World world = null;
        HashSet<String> claimedSet = new HashSet<String>(claimed);
        for (String key : claimed) {
            Location loc;
            Location loc2;
            boolean east;
            String[] parts = key.split(",");
            if (parts.length != 3 || (world = Bukkit.getWorld((String)parts[0])) == null) continue;
            int cx = Integer.parseInt(parts[1]);
            int cz = Integer.parseInt(parts[2]);
            int startX = cx << 4;
            int startZ = cz << 4;
            int endX = startX + 15;
            int endZ = startZ + 15;
            boolean north = !claimedSet.contains(world.getName() + "," + cx + "," + (cz - 1));
            boolean south = !claimedSet.contains(world.getName() + "," + cx + "," + (cz + 1));
            boolean west = !claimedSet.contains(world.getName() + "," + (cx - 1) + "," + cz);
            boolean bl = east = !claimedSet.contains(world.getName() + "," + (cx + 1) + "," + cz);
            if (north && west) {
                loc2 = BorderUtils.getSurface(world, startX, startZ);
                player.sendBlockChange(loc2, Material.GLOWSTONE.createBlockData());
                previewBlocks.add(loc2);
            }
            if (north && east) {
                loc2 = BorderUtils.getSurface(world, endX, startZ);
                player.sendBlockChange(loc2, Material.GLOWSTONE.createBlockData());
                previewBlocks.add(loc2);
            }
            if (south && west) {
                loc2 = BorderUtils.getSurface(world, startX, endZ);
                player.sendBlockChange(loc2, Material.GLOWSTONE.createBlockData());
                previewBlocks.add(loc2);
            }
            if (south && east) {
                loc2 = BorderUtils.getSurface(world, endX, endZ);
                player.sendBlockChange(loc2, Material.GLOWSTONE.createBlockData());
                previewBlocks.add(loc2);
            }
            if (north) {
                if (west) {
                    loc2 = BorderUtils.getSurface(world, startX + 1, startZ);
                    player.sendBlockChange(loc2, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc2);
                }
                for (int x = startX + 8; x < endX; x += 8) {
                    loc = BorderUtils.getSurface(world, x, startZ);
                    player.sendBlockChange(loc, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc);
                }
                if (east) {
                    Location loc3 = BorderUtils.getSurface(world, endX - 1, startZ);
                    player.sendBlockChange(loc3, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc3);
                }
            }
            if (south) {
                if (west) {
                    Location loc4 = BorderUtils.getSurface(world, startX + 1, endZ);
                    player.sendBlockChange(loc4, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc4);
                }
                for (int x = startX + 8; x < endX; x += 8) {
                    loc = BorderUtils.getSurface(world, x, endZ);
                    player.sendBlockChange(loc, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc);
                }
                if (east) {
                    Location loc5 = BorderUtils.getSurface(world, endX - 1, endZ);
                    player.sendBlockChange(loc5, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc5);
                }
            }
            if (west) {
                if (north) {
                    Location loc6 = BorderUtils.getSurface(world, startX, startZ + 1);
                    player.sendBlockChange(loc6, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc6);
                }
                for (int z = startZ + 8; z < endZ; z += 8) {
                    loc = BorderUtils.getSurface(world, startX, z);
                    player.sendBlockChange(loc, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc);
                }
                if (south) {
                    Location loc7 = BorderUtils.getSurface(world, startX, endZ - 1);
                    player.sendBlockChange(loc7, Material.GOLD_BLOCK.createBlockData());
                    previewBlocks.add(loc7);
                }
            }
            if (!east) continue;
            if (north) {
                Location loc8 = BorderUtils.getSurface(world, endX, startZ + 1);
                player.sendBlockChange(loc8, Material.GOLD_BLOCK.createBlockData());
                previewBlocks.add(loc8);
            }
            for (int z = startZ + 8; z < endZ; z += 8) {
                loc = BorderUtils.getSurface(world, endX, z);
                player.sendBlockChange(loc, Material.GOLD_BLOCK.createBlockData());
                previewBlocks.add(loc);
            }
            if (!south) continue;
            Location loc9 = BorderUtils.getSurface(world, endX, endZ - 1);
            player.sendBlockChange(loc9, Material.GOLD_BLOCK.createBlockData());
            previewBlocks.add(loc9);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            for (Location loc : previewBlocks) {
                player.sendBlockChange(loc, loc.getBlock().getBlockData());
            }
        }, (long)seconds * 20L);
    }

    private static Location getSurface(World world, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        Block block = world.getBlockAt(x, y - 1, z);
        return block.getLocation().add(0.0, 1.0, 0.0);
    }
}

