/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.data;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerXPManager {
    private static File file;
    private static FileConfiguration config;

    public static void setup(JavaPlugin plugin) {
        file = new File(plugin.getDataFolder(), "playerdata.yml");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to create playerdata.yml");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void savePlayer(UUID uuid, int xp, int level) {
        config.set(String.valueOf(uuid) + ".xp", (Object)xp);
        config.set(String.valueOf(uuid) + ".level", (Object)level);
        PlayerXPManager.saveFile();
    }

    public static int getXP(UUID uuid) {
        return config.getInt(String.valueOf(uuid) + ".xp", 0);
    }

    public static int getLevel(UUID uuid) {
        return config.getInt(String.valueOf(uuid) + ".level", 1);
    }

    public static void addXP(UUID uuid, int amount) {
        int level;
        int requiredXP;
        int currentXP = PlayerXPManager.getXP(uuid);
        int newXP = currentXP + amount;
        if (newXP >= (requiredXP = (level = PlayerXPManager.getLevel(uuid)) * 100)) {
            newXP -= requiredXP;
            ++level;
        }
        config.set(String.valueOf(uuid) + ".xp", (Object)newXP);
        config.set(String.valueOf(uuid) + ".level", (Object)level);
        PlayerXPManager.saveFile();
    }

    public static void saveFile() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

