/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class TownBossBarManager {
    private final HashMap<UUID, BossBar> activeBars = new HashMap();
    private final HashSet<UUID> disabledPlayers = new HashSet();

    public void showOrUpdateBossBar(Player player, String townName) {
        if (this.disabledPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (this.activeBars.containsKey(player.getUniqueId())) {
            BossBar bossBar = this.activeBars.get(player.getUniqueId());
            bossBar.setTitle("\u00a76Town: \u00a7e" + townName);
        } else {
            BossBar bossBar = Bukkit.createBossBar((String)("\u00a76Town: \u00a7e" + townName), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bossBar.addPlayer(player);
            bossBar.setProgress(1.0);
            this.activeBars.put(player.getUniqueId(), bossBar);
        }
    }

    public void removeBossBar(Player player) {
        if (this.activeBars.containsKey(player.getUniqueId())) {
            BossBar bossBar = this.activeBars.get(player.getUniqueId());
            bossBar.removeAll();
            this.activeBars.remove(player.getUniqueId());
        }
    }

    public void toggleBossBar(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.disabledPlayers.contains(uuid)) {
            this.disabledPlayers.remove(uuid);
            player.sendMessage("\u00a7aTown bossbar enabled!");
        } else {
            this.disabledPlayers.add(uuid);
            this.removeBossBar(player);
            player.sendMessage("\u00a7cTown bossbar disabled!");
        }
    }

    public boolean isEnabled(Player player) {
        return !this.disabledPlayers.contains(player.getUniqueId());
    }
}

