/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.data;

import com.knightgost.knighttowns.data.Town;
import com.knightgost.knighttowns.data.TownRank;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TownManager {
    private static final Map<String, Town> towns = new HashMap<String, Town>();

    public static Town getTown(String name) {
        if (name == null) {
            return null;
        }
        return towns.get(name.toLowerCase());
    }

    public static boolean townExists(String name) {
        return towns.containsKey(name.toLowerCase());
    }

    public static void addTown(Town town) {
        if (town != null) {
            towns.put(town.getName().toLowerCase(), town);
        }
    }

    public static void removeTown(String name) {
        if (name != null) {
            towns.remove(name.toLowerCase());
        }
    }

    public static Collection<Town> getAllTowns() {
        return towns.values();
    }

    public static String getTownAt(Location loc) {
        for (Town town : towns.values()) {
            if (!town.isInsideTown(loc)) continue;
            return town.getName();
        }
        return null;
    }

    public static Town getPlayerTown(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        for (Town town : towns.values()) {
            if (!playerUUID.equals(town.getMayorUUID())) continue;
            return town;
        }
        return null;
    }

    public static Town getTownByMayor(UUID mayorUUID) {
        if (mayorUUID == null) {
            return null;
        }
        for (Town town : towns.values()) {
            if (!mayorUUID.equals(town.getMayorUUID())) continue;
            return town;
        }
        return null;
    }

    public static Town getTownByPlayer(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        for (Town town : towns.values()) {
            if (!town.getMembers().containsKey(playerUUID)) continue;
            return town;
        }
        return null;
    }

    public static void saveTownToFile(JavaPlugin plugin, Town town) {
        if (town == null || plugin == null) {
            return;
        }
        try {
            File file = new File(plugin.getDataFolder(), "towns.yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            String path = town.getName().toLowerCase();
            UUID townMasterUUID = town.getTownMasterUUID();
            if (townMasterUUID != null) {
                config.set(path + ".townmaster", (Object)townMasterUUID.toString());
            } else {
                config.set(path + ".townmaster", (Object)"none");
            }
            config.set(path + ".datecreated", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
            Set<String> claimedChunks = town.getClaimedChunks();
            ArrayList<String> chunkList = new ArrayList<String>();
            if (claimedChunks != null && !claimedChunks.isEmpty()) {
                chunkList.addAll(claimedChunks);
            }
            config.set(path + ".claimedChunks", chunkList);
            ConfigurationSection membersSection = config.createSection(path + ".members");
            for (Map.Entry<UUID, TownRank> entry : town.getMembers().entrySet()) {
                membersSection.set(entry.getKey().toString(), (Object)entry.getValue().name());
            }
            config.save(file);
        }
        catch (IOException e) {
            plugin.getLogger().severe("Failed to save town: " + town.getName());
            e.printStackTrace();
        }
    }

    public static void loadTownsFromFile(JavaPlugin plugin) {
        if (plugin == null) {
            return;
        }
        File file = new File(plugin.getDataFolder(), "towns.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String townName : config.getKeys(false)) {
            String path = townName.toLowerCase();
            String townMasterStr = config.getString(path + ".townmaster");
            UUID townMasterUUID = null;
            if (townMasterStr != null && !townMasterStr.equals("none")) {
                try {
                    townMasterUUID = UUID.fromString(townMasterStr);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Town town = new Town(townName, townMasterUUID);
            List chunkStrings = config.getStringList(path + ".claimedChunks");
            for (String c : chunkStrings) {
                World world;
                String[] parts = c.split(",");
                if (parts.length != 3 || (world = Bukkit.getWorld((String)parts[0])) == null) continue;
                try {
                    int x = Integer.parseInt(parts[1]);
                    int z = Integer.parseInt(parts[2]);
                    Chunk chunk = world.getChunkAt(x, z);
                    town.addClaimedChunk(chunk);
                }
                catch (NumberFormatException x) {}
            }
            ConfigurationSection membersSection = config.getConfigurationSection(path + ".members");
            if (membersSection != null) {
                for (String uuidStr : membersSection.getKeys(false)) {
                    try {
                        UUID uuid = UUID.fromString(uuidStr);
                        TownRank rank = TownRank.valueOf(membersSection.getString(uuidStr, "VISITOR"));
                        town.addMember(uuid, rank);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            towns.put(townName.toLowerCase(), town);
        }
        plugin.getLogger().info("Loaded " + towns.size() + " towns from file.");
    }

    public static boolean isTownMaster(Player player, Town town) {
        if (town == null || player == null) {
            return false;
        }
        UUID playerUUID = player.getUniqueId();
        UUID townMasterUUID = town.getTownMasterUUID();
        return playerUUID.equals(townMasterUUID);
    }

    public static Town getTownByChunk(Chunk chunk) {
        String key = chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
        for (Town town : towns.values()) {
            if (!town.getClaimedChunks().contains(key)) continue;
            return town;
        }
        return null;
    }

    public static Town getTownByLocation(Location loc) {
        for (Town town : towns.values()) {
            if (!town.isInsideTown(loc)) continue;
            return town;
        }
        return null;
    }
}

