/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.player;

import java.util.UUID;

public class PlayerData {
    private final UUID uuid;
    private int xp;
    private int level;

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        this.xp = 0;
        this.level = 1;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getXP() {
        return this.xp;
    }

    public int getLevel() {
        return this.level;
    }

    public void addXP(int amount) {
        this.xp += amount;
        this.checkLevelUp();
    }

    private void checkLevelUp() {
        int requiredXP = this.getXPToNextLevel();
        while (this.xp >= requiredXP) {
            this.xp -= requiredXP;
            ++this.level;
            requiredXP = this.getXPToNextLevel();
        }
    }

    private int getXPToNextLevel() {
        return 100 + this.level * 50;
    }
}

