/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.player;

import com.knightgost.knighttowns.player.PlayerData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerManager {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static File file;
    private static FileConfiguration config;

    public static void init(JavaPlugin plugin) {
        file = new File(plugin.getDataFolder(), "playerdata.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        Bukkit.getOnlinePlayers().forEach(p -> PlayerManager.loadPlayer(p.getUniqueId()));
    }

    public static PlayerData getData(UUID uuid) {
        return playerDataMap.computeIfAbsent(uuid, PlayerData::new);
    }

    public static void loadPlayer(UUID uuid) {
        int xp = config.getInt(String.valueOf(uuid) + ".xp", 0);
        int level = config.getInt(String.valueOf(uuid) + ".level", 1);
        PlayerData data = new PlayerData(uuid);
        data.addXP(xp);
        playerDataMap.put(uuid, data);
    }

    public static void savePlayer(UUID uuid) {
        PlayerData data = playerDataMap.get(uuid);
        if (data == null) {
            return;
        }
        config.set(String.valueOf(uuid) + ".xp", (Object)data.getXP());
        config.set(String.valueOf(uuid) + ".level", (Object)data.getLevel());
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveAll() {
        for (UUID uuid : playerDataMap.keySet()) {
            PlayerManager.savePlayer(uuid);
        }
    }
}

