/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.player;

import com.knightgost.knighttowns.data.PlayerXPManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerXPListener
implements Listener {
    private final JavaPlugin plugin;
    private final Set<String> placedBlocks = new HashSet<String>();

    public PlayerXPListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlockPlaced();
        this.placedBlocks.add(block.getLocation().toString());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        int xp;
        Player player = e.getPlayer();
        Block block = e.getBlock();
        if (this.placedBlocks.contains(block.getLocation().toString())) {
            this.placedBlocks.remove(block.getLocation().toString());
            return;
        }
        Material type = block.getType();
        switch (type) {
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: {
                int n = 30;
                break;
            }
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                int n = 25;
                break;
            }
            case ANCIENT_DEBRIS: {
                int n = 40;
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: {
                int n = 12;
                break;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                int n = 10;
                break;
            }
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: {
                int n = 8;
                break;
            }
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: {
                int n = 6;
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                int n = 4;
                break;
            }
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: {
                int n = 3;
                break;
            }
            case STONE: 
            case COBBLESTONE: 
            case ANDESITE: 
            case DIORITE: 
            case GRANITE: {
                int n = 1;
                break;
            }
            case OBSIDIAN: {
                int n = 15;
                break;
            }
            case TUFF: 
            case CALCITE: {
                int n = 2;
                break;
            }
            case OAK_LOG: 
            case SPRUCE_LOG: 
            case BIRCH_LOG: 
            case JUNGLE_LOG: 
            case ACACIA_LOG: 
            case DARK_OAK_LOG: 
            case CHERRY_LOG: 
            case MANGROVE_LOG: 
            case BAMBOO_BLOCK: {
                int n = 2;
                break;
            }
            case CRIMSON_STEM: 
            case WARPED_STEM: {
                int n = 3;
                break;
            }
            case WHEAT: 
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: 
            case SUGAR_CANE: {
                int n = 1;
                break;
            }
            case PUMPKIN: 
            case MELON: 
            case CACTUS: 
            case BAMBOO: 
            case MANGROVE_ROOTS: {
                int n = 2;
                break;
            }
            case HAY_BLOCK: {
                int n = 3;
                break;
            }
            case CHEST: 
            case BARREL: {
                int n = 5;
                break;
            }
            case SPAWNER: {
                int n = 50;
                break;
            }
            default: {
                int n = xp = 0;
            }
        }
        if (xp > 0) {
            UUID uuid = player.getUniqueId();
            int oldLevel = PlayerXPManager.getLevel(uuid);
            PlayerXPManager.addXP(uuid, xp);
            int newLevel = PlayerXPManager.getLevel(uuid);
            player.sendActionBar("\u00a7a+" + xp + " XP \u00a77| Level " + newLevel);
            if (newLevel > oldLevel) {
                player.sendMessage("\u00a76\u00a7lLEVEL UP! \u00a7eYou are now Level " + newLevel + "!");
            }
        }
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent e) {
        if (e.getEntity().getKiller() != null) {
            Player killer = e.getEntity().getKiller();
            UUID uuid = killer.getUniqueId();
            int oldLevel = PlayerXPManager.getLevel(uuid);
            PlayerXPManager.addXP(uuid, 50);
            int newLevel = PlayerXPManager.getLevel(uuid);
            killer.sendActionBar("\u00a7a+50 XP \u00a77(Kill) | Level " + newLevel);
            if (newLevel > oldLevel) {
                killer.sendMessage("\u00a76\u00a7lLEVEL UP! \u00a7eYou are now Level " + newLevel + "!");
            }
        }
    }
}

