/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.map_book;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.greenjab.fixedminecraft.map_book.MapTile;
import net.greenjab.fixedminecraft.network.MapBookPlayer;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookItem;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookState;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookStateManager;
import net.greenjab.fixedminecraft.registry.item.map_book.MapStateData;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class MapBookScreen
extends class_437 {
    class_1799 item;
    public float x = 0.0f;
    public float y = 0.0f;
    public float scale = 1.0f;
    private float targetScale = 0.5f;

    public MapBookScreen(class_1799 item) {
        super(item.method_7964());
        this.item = item;
    }

    public void method_25426() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.x = (float)(-this.field_22787.field_1724.method_23317());
            this.y = (float)(-this.field_22787.field_1724.method_23321());
        }
        this.setScale(this.targetScale, (float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f);
        for (byte i = 4; i >= 0; --i) {
            for (MapStateData mapStateData : MapBookItem.getMapStates(this.item, (class_1937)this.field_22787.field_1687)) {
                if (mapStateData.mapState.field_119 != i) continue;
                this.method_37060(new MapTile(this, mapStateData.id, mapStateData.mapState, this.field_22787));
            }
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431());
    }

    public boolean method_25421() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean method_25402(double mouseX, double mouseY, int button) {
        block3: {
            if (button != 0 || !class_437.method_25442() || (id = MapBookScreen.getMapBookId(this.item)) == -1) break block3;
            marker = MapBookStateManager.INSTANCE.getClientMapBookState((int)MapBookScreen.getMapBookId((class_1799)this.item)).marker;
            pos = new class_243(mouseX, mouseY, 0.0);
            pos = pos.method_1021((double)(1.0f / this.scale));
            pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
            pos = pos.method_1023((double)(this.x / this.scale), (double)(this.y / this.scale), 0.0);
            dim = this.field_22787.field_1687.method_40134().method_55840();
            if (!marker.dimension.contains(dim)) ** GOTO lbl-1000
            v0 = new class_243(marker.x, marker.z, 0.0);
            if (pos.method_1022(v0) * (double)this.scale > 5.0) lbl-1000:
            // 2 sources

            {
                class_310.method_1551().method_1562().method_45730(String.format("mapBookMarker %s \"%s\" \"%s\" \"%s\"", new Object[]{MapBookScreen.getMapBookId(this.item), pos.method_10216(), pos.method_10214(), dim}));
            } else {
                class_310.method_1551().method_1562().method_45730(String.format("mapBookMarker %s \"%s\" \"%s\" \"%s\"", new Object[]{MapBookScreen.getMapBookId(this.item), 0, 0, ""}));
            }
        }
        if (button == 2 && this.field_22787.field_1724.method_31549().field_7477) {
            pos = new class_243(mouseX, mouseY, 0.0);
            pos = pos.method_1021((double)(1.0f / this.scale));
            pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
            pos = pos.method_1023((double)(this.x / this.scale), (double)(this.y / this.scale), 0.0);
            class_310.method_1551().method_1562().method_45730(String.format("tp %.6f %.6f %.6f", new Object[]{pos.method_10216(), this.field_22787.field_1724.method_23318(), pos.method_10214()}));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button < 2 && !class_437.method_25442()) {
            this.x = (float)((double)this.x + deltaX);
            this.y = (float)((double)this.y + deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount != 0.0) {
            this.targetScale = this.zoom(this.scale, (float)(-verticalAmount));
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (context == null) {
            return;
        }
        if (this.scale != this.targetScale) {
            float newScale = class_3532.method_16439((float)delta, (float)this.scale, (float)this.targetScale);
            this.setScale(newScale, mouseX, mouseY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        class_746 thisPlayer = this.field_22787.field_1724;
        if (thisPlayer == null) {
            return;
        }
        int id = MapBookScreen.getMapBookId(this.item);
        if (id != -1) {
            ArrayList<MapBookPlayer> m;
            this.renderIcons(context);
            MapBookPlayer p = new MapBookPlayer();
            p.setPlayer((class_1657)thisPlayer);
            MapBookPlayer marker = MapBookStateManager.INSTANCE.getClientMapBookState((int)id).marker;
            if (marker.dimension.contains(p.dimension)) {
                this.renderMarker(context, marker);
            }
            if ((m = MapBookStateManager.INSTANCE.getClientMapBookState((int)id).players) != null) {
                try {
                    for (MapBookPlayer player : m) {
                        if (!player.dimension.contains(p.dimension) || player.name.contains(p.name) && p.name.contains(player.name)) continue;
                        this.renderPlayerIcon(context, player, false);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
            this.renderPlayerIcon(context, p, true);
            this.renderPosition(context, mouseX, mouseY);
        }
    }

    private void renderPosition(class_332 context, int mouseX, int mouseY) {
        class_243 pos = new class_243((double)mouseX, (double)mouseY, 0.0);
        pos = pos.method_1021((double)(1.0f / this.scale));
        pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
        pos = pos.method_1023((double)(this.x / this.scale), (double)(this.y / this.scale), 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        String text = (int)pos.method_10216() + ", " + (int)pos.method_10214();
        int o = textRenderer.method_1727(text);
        Objects.requireNonNull(textRenderer);
        Matrix3x2fStack matrix = context.method_51448();
        matrix.pushMatrix();
        matrix.translate((float)((int)((float)this.field_22789 / 2.0f - (float)o / 2.0f)), (float)((int)((float)this.field_22790 - 60.0f + 8.0f)));
        context.method_25294(-1, -1, o, 9, new Color(50, 50, 50, 150).hashCode());
        context.method_51433(textRenderer, text, 0, 0, -1, true);
        matrix.popMatrix();
    }

    private void renderPlayerIcon(class_332 context, MapBookPlayer player, boolean thisPlayer) {
        class_310 minecraftClient = class_310.method_1551();
        float x = (float)player.x;
        float z = (float)player.z;
        float rotation = player.yaw;
        Matrix3x2fStack matrix = context.method_51448();
        matrix.pushMatrix();
        matrix.translate(this.x, this.y);
        matrix.scale(this.scale, this.scale);
        matrix.translate(x + (float)this.field_22789 / 2.0f, z + (float)this.field_22790 / 2.0f);
        matrix.rotate((float)((double)rotation * Math.PI / 180.0));
        matrix.scale(8.0f, 8.0f);
        matrix.translate(0.0f, 0.0f);
        matrix.scale(1.0f / this.scale, 1.0f / this.scale);
        class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(class_21.field_91, 0, 0, 0, Optional.empty()));
        if (thisPlayer) {
            context.method_70845(sprite.method_45852(), -1, -1, 1, 1, sprite.method_4594(), sprite.method_4577(), sprite.method_4575(), sprite.method_4593());
        } else {
            int color = class_9848.method_70658((int)class_9848.method_61330((int)255, (int)player.name.hashCode()), (float)0.9f);
            for (class_640 playerListEntry : this.field_22787.field_1724.field_3944.method_2880()) {
                class_124 formatting;
                class_268 team;
                if (!Objects.equals(playerListEntry.method_2966().getName(), player.name) || (team = playerListEntry.method_2955()) == null || !(formatting = team.method_1202()).method_543()) continue;
                color = new Color(formatting.method_532()).hashCode();
            }
            context.method_25295(class_10799.field_56883, sprite.method_45852(), -1, 1, -1, 1, sprite.method_4594(), sprite.method_4577(), sprite.method_4575(), sprite.method_4593(), color);
        }
        matrix.popMatrix();
        class_327 textRenderer = minecraftClient.field_1772;
        String text = player.name;
        int o = textRenderer.method_1727(text);
        matrix.pushMatrix();
        matrix.translate(this.x, this.y);
        matrix.scale(this.scale, this.scale);
        matrix.translate(x + (float)this.field_22789 / 2.0f, z + (float)this.field_22790 / 2.0f);
        matrix.scale(1.0f / this.scale, 1.0f / this.scale);
        matrix.translate((float)(-o) / 2.0f, 8.0f);
        context.method_25294(-1, -1, o, 9, new Color(50, 50, 50, 150).hashCode());
        context.method_51433(textRenderer, text, 0, 0, -1, true);
        matrix.popMatrix();
    }

    private void renderIcons(class_332 context) {
        for (MapStateData mapStateData : this.getMapStates(this.item, (class_1937)this.field_22787.field_1687)) {
            float render = 0.0f;
            if (this.field_22787.field_1687.method_40134().method_55840().contains(mapStateData.mapState.field_118.method_29177().toString())) {
                render = 1.0f;
            }
            if (this.field_22787.field_1687.method_40134().method_55840().contains("the_nether") && mapStateData.mapState.field_118.method_29177().toString().contains("overworld")) {
                render = 0.125f;
            }
            if (!(render > 0.0f)) continue;
            Iterator var11 = mapStateData.mapState.method_32373().iterator();
            Matrix3x2fStack matrix = context.method_51448();
            while (var11.hasNext()) {
                class_20 mapIcon = (class_20)var11.next();
                if (mapIcon.comp_1842().method_55840().contains("player")) continue;
                matrix.pushMatrix();
                matrix.translate(this.x, this.y);
                matrix.scale(this.scale, this.scale);
                float mapScale = (float)Math.pow(2.0, mapStateData.mapState.field_119);
                float offset = 64.0f * mapScale;
                float x = ((float)mapStateData.mapState.field_116 - offset + (float)(mapIcon.comp_1843() + 128 + 1) * mapScale / 2.0f) * render;
                float z = ((float)mapStateData.mapState.field_115 - offset + (float)(mapIcon.comp_1844() + 128 + 1) * mapScale / 2.0f) * render;
                matrix.translate(x + (float)this.field_22789 / 2.0f, z + (float)this.field_22790 / 2.0f);
                matrix.rotate((float)Math.PI);
                matrix.scale(8.0f, 8.0f);
                matrix.translate(0.0f, 0.0f);
                matrix.scale(1.0f / this.scale, 1.0f / this.scale);
                class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(mapIcon.comp_1842(), 0, 0, 0, Optional.empty()));
                context.method_70845(sprite.method_45852(), -1, -1, 1, 1, sprite.method_4594(), sprite.method_4577(), sprite.method_4575(), sprite.method_4593());
                matrix.popMatrix();
                if (!mapIcon.comp_1846().isPresent()) continue;
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = (class_2561)mapIcon.comp_1846().get();
                int o = textRenderer.method_27525((class_5348)text);
                matrix.pushMatrix();
                matrix.translate(this.x, this.y);
                matrix.scale(this.scale, this.scale);
                float mapx = ((float)mapStateData.mapState.field_116 - offset + (float)(mapIcon.comp_1843() + 128 + 1) * mapScale / 2.0f) * render;
                float mapz = ((float)mapStateData.mapState.field_115 - offset + (float)(mapIcon.comp_1844() + 128 + 1) * mapScale / 2.0f) * render;
                matrix.translate(mapx + (float)this.field_22789 / 2.0f, mapz + (float)this.field_22790 / 2.0f);
                matrix.scale(1.0f / this.scale, 1.0f / this.scale);
                matrix.translate((float)(-o) / 2.0f, 8.0f);
                context.method_25294(-1, -1, o, 9, new Color(50, 50, 50, 150).hashCode());
                context.method_51439(textRenderer, text, 0, 0, -1, true);
                matrix.popMatrix();
            }
        }
    }

    private void renderMarker(class_332 context, MapBookPlayer player) {
        float x = (float)player.x;
        float z = (float)player.z;
        float rotation = player.yaw;
        Matrix3x2fStack matrix = context.method_51448();
        matrix.pushMatrix();
        matrix.translate(this.x, this.y);
        matrix.scale(this.scale, this.scale);
        matrix.translate(x + (float)this.field_22789 / 2.0f, z + (float)this.field_22790 / 2.0f);
        matrix.rotate((float)((double)rotation * Math.PI / 180.0));
        matrix.scale(8.0f, 8.0f);
        matrix.translate(0.0f, 0.0f);
        matrix.scale(1.0f / this.scale, 1.0f / this.scale);
        class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(class_21.field_84, 0, 0, 0, Optional.empty()));
        context.method_70845(sprite.method_45852(), -1, -1, 1, 1, sprite.method_4594(), sprite.method_4577(), sprite.method_4575(), sprite.method_4593());
        matrix.popMatrix();
    }

    private ArrayList<MapStateData> getMapStates(class_1799 stack, class_1937 world) {
        ArrayList<MapStateData> list = new ArrayList<MapStateData>();
        MapBookState mapBookState = this.getMapBookState(stack, world);
        if (mapBookState != null) {
            for (int i : mapBookState.mapIDs) {
                class_22 mapState = world.method_17891(new class_9209(i));
                if (mapState == null) continue;
                list.add(new MapStateData(new class_9209(i), mapState));
            }
        }
        return list;
    }

    private MapBookState getMapBookState(class_1799 stack, class_1937 world) {
        int id = MapBookScreen.getMapBookId(stack);
        if (id == -1) {
            return null;
        }
        return MapBookStateManager.INSTANCE.getClientMapBookState(id);
    }

    private static int getMapBookId(class_1799 stack) {
        class_9209 mapIdComponent = (class_9209)stack.method_58695(class_9334.field_49646, null);
        if (mapIdComponent != null) {
            return mapIdComponent.comp_2315();
        }
        return -1;
    }

    private void setScale(float newScale, float mouseX, float mouseY) {
        float offsetX = this.x - mouseX;
        float offsetY = this.y - mouseY;
        float scaleChange = newScale / this.scale;
        this.x = scaleChange * offsetX + mouseX;
        this.y = scaleChange * offsetY + mouseY;
        this.scale = newScale;
    }

    private float zoom(float start, float scroll) {
        float absScroll = Math.abs(scroll);
        float speed = 5.0f;
        float newZoom = scroll > 0.0f ? start - start / (scroll * speed) : start * absScroll * speed / (absScroll * speed - 1.0f);
        newZoom = Math.min(Math.max(newZoom, 0.005f), 10.0f);
        return newZoom;
    }
}

