/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.mixin.util;

import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;

@InjectionPoint.AtCode(namespace="fixedminecraft", value="FIXED_MINECRAFT_IINC")
public class BeforeInc
extends InjectionPoint {
    private final int ordinal;
    private final Integer intValue;

    public BeforeInc(InjectionPointData data) {
        super(data);
        this.ordinal = data.getOrdinal();
        this.intValue = Ints.tryParse((String)data.get("intValue", ""));
    }

    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        ListIterator iter = insns.iterator();
        int ordinal = 0;
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            boolean matchesInsn = this.matchesIncInsn(insn);
            if (!matchesInsn) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }

    private boolean matchesIncInsn(AbstractInsnNode insn) {
        if (insn.getOpcode() != 132) {
            return false;
        }
        int incr = ((IincInsnNode)insn).incr;
        return this.intValue.equals(incr);
    }
}

