/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.enchanting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.greenjab.fixedminecraft.FixedMinecraft;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public class FixedMinecraftEnchantmentHelper {
    public static final int POWER_WHEN_MAX_LEVEL = 12;

    public static int getEnchantmentPower(class_6880<class_1887> enchantment, int level) {
        return (int)Math.ceil(enchantment.method_40220(class_9636.field_51551) ? Math.min(-1.0, FixedMinecraftEnchantmentHelper.curseEnchantmentPowerFunction((class_1887)enchantment.comp_349(), level)) : Math.max(1.0, FixedMinecraftEnchantmentHelper.enchantmentPowerFunction(enchantment, level)));
    }

    private static double enchantmentPowerFunction(class_6880<class_1887> enchantment, int level) {
        return (enchantment.method_40220(class_9636.field_51557) ? 1.5 : 1.0) * (double)(12 + ((class_1887)enchantment.comp_349()).method_8183() - 5) * Math.pow((double)level / (double)((class_1887)enchantment.comp_349()).method_8183(), 2.0);
    }

    private static double curseEnchantmentPowerFunction(class_1887 enchantment, int level) {
        return -5.0 * Math.pow((double)level / (double)enchantment.method_8183(), 1.6);
    }

    public static int getEnchantmentCapacity(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (!FixedMinecraft.ItemCapacities.containsKey(item) && FixedMinecraft.SERVER != null) {
            HashMap<class_1792, Integer> map = new HashMap<class_1792, Integer>(Map.of());
            map.putAll(FixedMinecraft.ItemCapacities);
            map.put(item, FixedMinecraftEnchantmentHelper.getNewEnchantmentCapacity(itemStack));
            FixedMinecraft.ItemCapacities = map;
        }
        return FixedMinecraft.ItemCapacities.getOrDefault(item, 0);
    }

    public static int getNewEnchantmentCapacity(class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8598) || itemStack.method_31574(class_1802.field_8529)) {
            return 50;
        }
        List<class_1889> list = FixedMinecraftEnchantmentHelper.getPossibleEntries(itemStack);
        int power = 0;
        for (class_1889 enchantmentLevelEntry : list) {
            power += FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)enchantmentLevelEntry.field_9093, enchantmentLevelEntry.field_9094);
        }
        boolean isGold = itemStack.method_31573(class_3489.field_24481);
        return Math.min((int)Math.ceil((float)power * (isGold ? 0.75f : 0.54f)), 50);
    }

    public static List<class_1889> getPossibleEntries(class_1799 stack) {
        ArrayList list = Lists.newArrayList();
        class_3218 world = Objects.requireNonNull(FixedMinecraft.SERVER).method_30002();
        class_2378 optional = world.method_30349().method_30530(class_7924.field_41265);
        Iterator e = optional.method_10220().iterator();
        while (e.hasNext()) {
            class_1887 enchantment = (class_1887)e.next();
            class_6880 ench = optional.method_47983((Object)enchantment);
            if (ench.method_40220(class_9636.field_51551) || !enchantment.method_8192(stack)) continue;
            list.add(new class_1889(optional.method_47983((Object)enchantment), enchantment.method_8183()));
        }
        return list;
    }

    public static int getOccupiedEnchantmentCapacity(class_1799 itemStack, boolean atLeast1) {
        int power = 0;
        class_9304 enchantmentLevelsMap = class_1890.method_57532((class_1799)itemStack);
        for (class_6880 enchantment : enchantmentLevelsMap.method_57534()) {
            int add = FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)enchantment, enchantmentLevelsMap.method_57536(enchantment));
            power += add;
        }
        boolean isGold = itemStack.method_31573(class_3489.field_24481);
        return Math.max((int)Math.ceil((double)power * (isGold ? 0.5 : 1.0)), atLeast1 ? 1 : 0);
    }

    public static int countAccessibleBookshelves(class_1937 world, class_2338 enchantingTablePosition) {
        int bookShelfCount = 0;
        for (class_2338 p : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)world, (class_2338)enchantingTablePosition, (class_2338)p)) continue;
            ++bookShelfCount;
        }
        bookShelfCount = Math.min(bookShelfCount, 15);
        return bookShelfCount;
    }

    public static boolean canAccessBlock(class_1937 world, class_2338 enchantingTablePosition, class_2338 providerOffset, class_2248 block) {
        return world.method_8320(enchantingTablePosition.method_10081((class_2382)providerOffset)).method_27852(block) && world.method_8320(enchantingTablePosition.method_10069(providerOffset.method_10263() / 2, providerOffset.method_10264(), providerOffset.method_10260() / 2)).method_26164(class_3481.field_44473);
    }

    public static class_1799 applySuperEnchants(class_1799 IS, class_5819 random) {
        return FixedMinecraftEnchantmentHelper.applySuperEnchants(IS, random, false);
    }

    public static class_1799 applySuperEnchants(class_1799 IS, class_5819 random, boolean pale) {
        if (!IS.method_31574(class_1802.field_8598)) {
            class_1799 IS2 = IS.method_7909().method_7854();
            class_9304 map = class_1890.method_57532((class_1799)IS);
            boolean isSuper = false;
            class_9304.class_9305 builder = new class_9304.class_9305(class_1890.method_57532((class_1799)IS));
            for (Object2IntMap.Entry entry : map.method_57539()) {
                class_6880 registryEntry = (class_6880)entry.getKey();
                class_1887 e = (class_1887)registryEntry.comp_349();
                int i = entry.getIntValue();
                if (e.method_8183() != 1) {
                    float f = random.method_43057();
                    float f2 = pale ? 0.15f : 0.05f;
                    if (f < f2) {
                        i = e.method_8183() + 1;
                        isSuper = true;
                    }
                }
                builder.method_57547(registryEntry, i);
            }
            if (isSuper) {
                IS2.method_57379(class_9334.field_49639, (Object)1);
                class_9304 outputEnchants = class_1890.method_57532((class_1799)IS2);
                for (Object2IntMap.Entry entry : outputEnchants.method_57539()) {
                    class_6880 registryEntry = (class_6880)entry.getKey();
                    if (!registryEntry.equals((Object)class_1893.field_9101)) continue;
                    builder.method_57547(registryEntry, 0);
                }
            }
            class_1890.method_57530((class_1799)IS2, (class_9304)builder.method_57549());
            return IS2;
        }
        return IS;
    }

    public static int enchantLevel(class_1799 stack, String name) {
        int level = 0;
        class_9304 itemEnchantmentsComponent = (class_9304)stack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 e : stack.method_58657().method_57534()) {
            if (!e.method_55840().toLowerCase().contains(name.toLowerCase())) continue;
            level += itemEnchantmentsComponent.method_57536(e);
        }
        return level;
    }
}

