/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.hud;

import java.util.Random;
import java.util.Vector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.greenjab.fixedminecraft.hud.HUDOverlayEvent;
import net.greenjab.fixedminecraft.util.IntPoint;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class HUDOverlayHandler {
    private static final int FOOD_BAR_HEIGHT = 39;
    private static final Vector<IntPoint> foodBarOffsets = new Vector();
    private static final Random random = new Random();

    public static void onRender(class_332 context) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_1702 stats = player.method_7344();
        int top = mc.method_22683().method_4502() - 39;
        int left = mc.method_22683().method_4486() / 2 - 91;
        int right = mc.method_22683().method_4486() / 2 + 91;
        HUDOverlayHandler.generateBarOffsets(top, left, right, mc.field_1705.method_1738(), (class_1657)player);
        HUDOverlayEvent.Saturation saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.method_7589(), right, top, context);
        if (!saturationRenderEvent.isCanceled) {
            HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc);
        }
    }

    private static void drawSaturationOverlay(class_332 context, Float saturationLevel, class_310 mc, int right, int top) {
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel.floatValue(), 20.0f));
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        int iconSize = 9;
        for (int i = 0; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            float v = 0.0f;
            float u = 0.0f;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if ((double)effectiveSaturationOfBar > 0.75) {
                u = 3.0f * (float)iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2.0f * (float)iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1.0f * (float)iconSize;
            }
            context.method_25291(class_1921::method_62277, class_2960.method_60655((String)"fixedminecraft", (String)"textures/icons.png"), x, y, u, v, iconSize, iconSize, 256, 256, class_9848.method_61317((float)1.0f));
        }
    }

    private static void drawSaturationOverlay(HUDOverlayEvent.Saturation event, class_310 mc) {
        HUDOverlayHandler.drawSaturationOverlay(event.context, Float.valueOf(event.saturationLevel), mc, event.x, event.y);
    }

    private static void generateBarOffsets(int top, int left, int right, int ticks, class_1657 player) {
        int preferFoodBars = 10;
        boolean shouldAnimatedFood = false;
        class_1702 hungerManager = player.method_7344();
        float saturationLevel = hungerManager.method_7589();
        int foodLevel = hungerManager.method_7586();
        shouldAnimatedFood = saturationLevel <= 0.0f && ticks % (foodLevel * 3 + 1) == 0;
        random.setSeed((long)ticks * 312871L);
        if (foodBarOffsets.size() != preferFoodBars) {
            foodBarOffsets.setSize(preferFoodBars);
        }
        for (int i = 0; i < preferFoodBars; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }
}

