/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.render;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.greenjab.fixedminecraft.mixin.enchanting.ChiseledBookshelfBlockInvoker;
import net.greenjab.fixedminecraft.registry.registries.ItemRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7716;
import net.minecraft.class_9209;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public abstract class PlayerLookHelper {
    public static class_1799 getLookingAtBook(class_7716 blockEntity) {
        class_1799 book = class_1799.field_8037;
        class_310 client = class_310.method_1551();
        class_239 class_2393 = client.field_1765;
        if (!(class_2393 instanceof class_3965)) {
            return book;
        }
        class_3965 hit = (class_3965)class_2393;
        assert (client.field_1687 != null);
        if (blockEntity == null) {
            Optional blockEntityOptional = client.field_1687.method_35230(hit.method_17777(), class_2591.field_40329);
            if (blockEntityOptional.isEmpty()) {
                return book;
            }
            blockEntity = (class_7716)blockEntityOptional.get();
        } else if (!hit.method_17777().equals((Object)blockEntity.method_11016())) {
            return book;
        }
        Optional<class_241> hitPos = ChiseledBookshelfBlockInvoker.getHitPos(hit, (class_2350)blockEntity.method_11010().method_11654((class_2769)class_2383.field_11177));
        if (hitPos.isEmpty()) {
            return book;
        }
        OptionalInt slot = PlayerLookHelper.getSlotForHitPos(hit, client.field_1687.method_8320(hit.method_17777()));
        return blockEntity.method_5438(slot.getAsInt());
    }

    private static OptionalInt getSlotForHitPos(class_3965 hit, class_2680 state) {
        return PlayerLookHelper.getHitPos(hit, (class_2350)state.method_11654((class_2769)class_2383.field_11177)).map(hitPos -> {
            int i = hitPos.field_1342 >= 0.5f ? 0 : 1;
            int j = PlayerLookHelper.getColumn(hitPos.field_1343);
            return OptionalInt.of(j + i * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<class_241> getHitPos(class_3965 hit, class_2350 facing) {
        class_2350 direction = hit.method_17780();
        if (facing != direction) {
            return Optional.empty();
        }
        class_2338 blockPos = hit.method_17777().method_10093(direction);
        class_243 vec3d = hit.method_17784().method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        double d = vec3d.method_10216();
        double e = vec3d.method_10214();
        double f = vec3d.method_10215();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> Optional.of(new class_241((float)(1.0 - d), (float)e));
            case class_2350.field_11035 -> Optional.of(new class_241((float)d, (float)e));
            case class_2350.field_11039 -> Optional.of(new class_241((float)f, (float)e));
            case class_2350.field_11034 -> Optional.of(new class_241((float)(1.0 - f), (float)e));
            case class_2350.field_11033, class_2350.field_11036 -> Optional.empty();
        };
    }

    private static int getColumn(float x) {
        if (x < 0.375f) {
            return 0;
        }
        return x < 0.6875f ? 1 : 2;
    }

    static int getMapBookId(class_1799 stack) {
        class_9209 mapIdComponent = (class_9209)stack.method_57825(class_9334.field_49646, null);
        if (mapIdComponent == null) {
            return -1;
        }
        return mapIdComponent.comp_2315();
    }

    public static List<class_2561> getBookText(class_1799 book) {
        int id;
        ArrayList<class_2561> displayText = new ArrayList<class_2561>();
        displayText.add(book.method_7909().method_63680());
        if (book.method_57826(class_9334.field_49631) || book.method_31574(class_1802.field_8360)) {
            class_2583 s = book.method_7964().method_10866().method_10978(Boolean.valueOf(true));
            displayText.add((class_2561)book.method_7964().method_36136(s).get(0));
        }
        if (book.method_31574(ItemRegistry.MAP_BOOK) && (id = PlayerLookHelper.getMapBookId(book)) != -1) {
            class_2561 t = class_2561.method_30163((String)("ID: " + (id + 1)));
            displayText.add(t);
        }
        if (book.method_7909() == class_1802.field_8598 && class_1890.method_58117((class_1799)book)) {
            class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)book);
            for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                class_6880 registryEntry = (class_6880)entry.getKey();
                displayText.add(class_1887.method_8179((class_6880)registryEntry, (int)entry.getIntValue()));
            }
        }
        return displayText;
    }
}

