/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.greenjab.fixedminecraft.network.MapBookOpenPayload;
import net.greenjab.fixedminecraft.network.MapBookSyncPayload;
import net.greenjab.fixedminecraft.network.MapPositionPayload;
import net.greenjab.fixedminecraft.network.MapPositionRequestPayload;
import net.greenjab.fixedminecraft.network.SaturationSyncPayload;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class SyncHandler {
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();

    public static void init() {
        PayloadTypeRegistry.playS2C().register(SaturationSyncPayload.ID, SaturationSyncPayload.CODEC);
        MapBookOpenPayload.register();
        MapBookSyncPayload.register();
        MapPositionPayload.register();
        MapPositionRequestPayload.register();
    }

    public static void onPlayerUpdate(class_3222 player) {
        Float lastSaturationLevel = lastSaturationLevels.get(player.method_5667());
        float saturation = player.method_7344().method_7589();
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != saturation) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SaturationSyncPayload(saturation));
            lastSaturationLevels.put(player.method_5667(), Float.valueOf(saturation));
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        lastSaturationLevels.remove(player.method_5667());
    }
}

