/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.mixin.enchanting;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import net.greenjab.fixedminecraft.enchanting.FixedMinecraftEnchantmentHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2382;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7716;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class})
public abstract class EnchantmentScreenHandlerMixin
extends class_1703 {
    @Shadow
    @Final
    public int[] field_7812;
    @Shadow
    @Final
    private class_5819 field_7811;
    @Shadow
    @Final
    public int[] field_7810;
    @Shadow
    @Final
    public int[] field_7808;
    @Shadow
    @Final
    private class_3914 field_7813;
    @Shadow
    @Final
    private class_1263 field_7809;
    @Shadow
    @Final
    private class_3915 field_7814;
    @Unique
    private final List<class_1889>[] fixed_minecraft__enchantments = new List[3];

    protected EnchantmentScreenHandlerMixin(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
    }

    @Shadow
    protected abstract List<class_1889> method_7637(class_5455 var1, class_1799 var2, int var3, int var4);

    @Shadow
    public abstract boolean method_7604(class_1657 var1, int var2);

    @Inject(method={"generateEnchantments"}, at={@At(value="RETURN")}, cancellable=true)
    private void generateEnchantmentsWithChiseledBookshelves(class_5455 registryManager, class_1799 stack, int slot, int xpLevel, CallbackInfoReturnable<List<class_1889>> cir) {
        List originalReturnValue = (List)cir.getReturnValue();
        if (originalReturnValue == null || originalReturnValue.isEmpty()) {
            return;
        }
        ArrayList chosenItemStacks = new ArrayList();
        this.field_7813.method_17393((world, tablePos) -> {
            int bookShelfCount = FixedMinecraftEnchantmentHelper.countAccessibleBookshelves(world, tablePos);
            for (int i = 0; i < bookShelfCount; ++i) {
                int nextRoll;
                class_1799 itemStackAtRandomSlot;
                class_7716 chiseledBookShelfEntity;
                int randomIndex = this.field_7811.method_43048(class_2331.field_36535.size());
                if (!FixedMinecraftEnchantmentHelper.canAccessBlock(world, tablePos, (class_2338)class_2331.field_36535.get(randomIndex), class_2246.field_40276) || (chiseledBookShelfEntity = (class_7716)world.method_8321(tablePos.method_10081((class_2382)class_2331.field_36535.get(randomIndex)))) == null || chiseledBookShelfEntity.method_5442() || (itemStackAtRandomSlot = chiseledBookShelfEntity.method_5438(nextRoll = this.field_7811.method_43048(chiseledBookShelfEntity.method_5439()))) == null || itemStackAtRandomSlot.method_7960() || !itemStackAtRandomSlot.method_31574(class_1802.field_8598) || itemStackAtRandomSlot.method_57353().method_57832(class_9334.field_49639) && (Integer)itemStackAtRandomSlot.method_57353().method_58694(class_9334.field_49639) == 2) continue;
                chosenItemStacks.add(itemStackAtRandomSlot);
            }
        });
        HashMap<class_6880, Integer> enchantments = new HashMap<class_6880, Integer>();
        class_1889 randomEntry = (class_1889)originalReturnValue.get(this.field_7811.method_43048(originalReturnValue.size()));
        enchantments.put(randomEntry.comp_3486(), randomEntry.comp_3487());
        AtomicInteger enchPower = new AtomicInteger();
        enchPower.addAndGet(FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)randomEntry.comp_3486(), randomEntry.comp_3487()));
        for (class_1799 chosenStack : chosenItemStacks) {
            class_9304 bookEnchantments = class_1890.method_57532((class_1799)chosenStack);
            HashMap<class_6880, Integer> enchantments2 = new HashMap<class_6880, Integer>();
            for (Object2IntMap.Entry entry : bookEnchantments.method_57539()) {
                class_6880 registryEntry = (class_6880)entry.getKey();
                class_1887 enchantment2 = (class_1887)registryEntry.comp_349();
                int level2 = entry.getIntValue();
                if (!((class_1887)registryEntry.comp_349()).method_8192(stack)) continue;
                if (enchantments.containsKey(registryEntry)) {
                    if ((Integer)enchantments.get(registryEntry) > level2 || (Integer)enchantments.get(registryEntry) != level2) continue;
                    enchantments2.put(registryEntry, Math.min(level2 + 1, enchantment2.method_8183()));
                    continue;
                }
                if (enchPower.get() + FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)registryEntry, level2) <= 0) continue;
                enchantments2.put(registryEntry, level2);
            }
            if (enchantments2.isEmpty()) continue;
            int rand = this.field_7811.method_43048(enchantments2.size());
            int[] i = new int[]{0};
            enchantments2.forEach((enchantment, level) -> {
                if (i[0] == rand) {
                    boolean can = true;
                    for (class_6880 enchantment3 : enchantments.keySet()) {
                        if (class_1887.method_60033((class_6880)enchantment, (class_6880)enchantment3)) continue;
                        can = false;
                        break;
                    }
                    if (can) {
                        enchPower.addAndGet(FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)enchantment, level));
                        enchantments.put((class_6880)enchantment, (Integer)level);
                    }
                    i[0] = i[0] + 1;
                }
            });
        }
        boolean isGold = stack.method_31573(class_3489.field_24481);
        ArrayList enchantmentsResult = new ArrayList();
        enchantments.forEach((enchantment, level) -> enchantmentsResult.add(new class_1889(enchantment, isGold && ((class_1887)enchantment.comp_349()).method_8183() != 1 ? level + 1 : level)));
        cir.setReturnValue(enchantmentsResult);
    }

    @Redirect(method={"onContentChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEnchantable()Z"))
    private boolean noEnchantBook(class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8529)) {
            return false;
        }
        return itemStack.method_7923();
    }

    @ModifyArg(method={"onContentChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandlerContext;run(Ljava/util/function/BiConsumer;)V"))
    private BiConsumer<class_1937, class_2338> generateEntries(BiConsumer<class_1937, class_2338> original, @Local class_1799 itemStack) {
        return (world, blockPos) -> {
            int bookShelfCount = FixedMinecraftEnchantmentHelper.countAccessibleBookshelves(world, blockPos);
            int power = (int)((float)(11 * bookShelfCount) / 15.0f + 1.0f);
            class_2359 indexedIterable = world.method_30349().method_30530(class_7924.field_41265).method_40295();
            for (int slot = 0; slot < 3; ++slot) {
                List<class_1889> enchantments = this.method_7637(world.method_30349(), itemStack, slot, power);
                if (!enchantments.isEmpty()) {
                    int img;
                    class_1889 displayedEnchantment = enchantments.get(0);
                    this.field_7812[slot] = indexedIterable.method_10206((Object)displayedEnchantment.comp_3486());
                    int enchantmentPower = 0;
                    for (class_1889 entry : enchantments) {
                        enchantmentPower += FixedMinecraftEnchantmentHelper.getEnchantmentPower((class_6880<class_1887>)entry.comp_3486(), entry.comp_3487());
                    }
                    int cap = FixedMinecraftEnchantmentHelper.getEnchantmentCapacity(itemStack);
                    this.field_7810[slot] = img = enchantmentPower > cap ? 2 : (enchantmentPower > cap / 2 ? 1 : 0);
                    boolean isGold = itemStack.method_31573(class_3489.field_24481);
                    if (isGold) {
                        enchantmentPower /= 2;
                    }
                    this.field_7808[slot] = enchantmentPower;
                    this.fixed_minecraft__enchantments[slot] = enchantments;
                    continue;
                }
                for (int i = 0; i < 3; ++i) {
                    this.field_7808[i] = 0;
                    this.field_7812[i] = -1;
                    this.field_7810[i] = -1;
                }
            }
            this.method_7623();
        };
    }

    @ModifyArg(method={"onButtonClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandlerContext;run(Ljava/util/function/BiConsumer;)V"))
    private BiConsumer<class_1937, class_2338> overwriteApplyEnchantmentsLogic(BiConsumer<class_1937, class_2338> original, @Local(argsOnly=true) class_1657 player, @Local(argsOnly=true) int slotId, @Local(ordinal=1) int lapisCountToDecrement) {
        return (world, blockPos) -> {
            class_1799 targetItemStack = this.field_7809.method_5438(0);
            class_1799 lapislazuliStack = this.field_7809.method_5438(1);
            BiConsumer<class_1799, class_1889> applyEnchantmentsStrategy = (itemStack, enchantmentLevelEntry) -> itemStack.method_7978(enchantmentLevelEntry.comp_3486(), enchantmentLevelEntry.comp_3487());
            for (class_1889 entry : this.fixed_minecraft__enchantments[slotId]) {
                applyEnchantmentsStrategy.accept(targetItemStack, entry);
            }
            boolean isSuper = false;
            List<class_1889> enchantments = this.method_7637(world.method_30349(), targetItemStack, slotId, this.field_7808[slotId]);
            for (class_1889 enchantment : enchantments) {
                int i = enchantment.comp_3487();
                if (i <= ((class_1887)enchantment.comp_3486().comp_349()).method_8183()) continue;
                isSuper = true;
            }
            if (isSuper) {
                targetItemStack.method_58695(class_9334.field_49639, (Object)1);
            }
            if (player instanceof class_3222) {
                class_3222 SPE = (class_3222)player;
                if (enchantments.size() > 1) {
                    class_174.field_1198.method_8821(SPE, class_1802.field_40215.method_7854());
                }
            }
            int enchantingCosts = FixedMinecraftEnchantmentHelper.getOccupiedEnchantmentCapacity(targetItemStack, true);
            int newLapisCost = (int)Math.ceil((double)enchantingCosts / 10.0);
            player.method_7286(targetItemStack, newLapisCost);
            if (!player.method_31549().field_7477) {
                lapislazuliStack.method_7934(newLapisCost);
                if (lapislazuliStack.method_7960()) {
                    this.field_7809.method_5447(1, class_1799.field_8037);
                }
            }
            player.method_7281(class_3468.field_15420);
            if (player instanceof class_3222) {
                class_174.field_1181.method_8870((class_3222)player, targetItemStack, newLapisCost);
            }
            this.field_7809.method_5431();
            this.field_7814.method_17404(player.method_7278());
            this.method_7609(this.field_7809);
            world.method_8396(null, blockPos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
            for (class_2338 offset : class_2331.field_36535) {
                class_7716 chiseledBookShelfEntity = (class_7716)world.method_8321(blockPos.method_10081((class_2382)offset));
                if (chiseledBookShelfEntity == null || chiseledBookShelfEntity.method_5442()) continue;
                for (int slot = 0; slot < 6; ++slot) {
                    class_1799 book = chiseledBookShelfEntity.method_5438(slot);
                    if (!book.method_31574(class_1802.field_8598)) continue;
                    book.method_57381(class_9334.field_49639);
                }
            }
        };
    }

    @ModifyExpressionValue(method={"onButtonClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getCount()I")})
    private int newLapisCost(int value, @Local(ordinal=1) int i) {
        int newLapisCost = (int)Math.ceil((double)this.field_7808[i - 1] / 10.0);
        return value + i - newLapisCost;
    }
}

