/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.map_book;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.greenjab.fixedminecraft.map_book.MapTile;
import net.greenjab.fixedminecraft.mixin.client.map.DrawContextAccessor;
import net.greenjab.fixedminecraft.network.MapBookPlayer;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookItem;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookState;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookStateManager;
import net.greenjab.fixedminecraft.registry.item.map_book.MapStateData;
import net.minecraft.class_1058;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class MapBookScreen
extends class_437 {
    class_1799 item;
    public double x = 0.0;
    public double y = 0.0;
    public float scale = 1.0f;
    private float targetScale = 0.5f;

    public MapBookScreen(class_1799 item) {
        super(item.method_7964());
        this.item = item;
    }

    public void method_25426() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.x = -this.field_22787.field_1724.method_23317();
            this.y = -this.field_22787.field_1724.method_23321();
        }
        this.setScale(this.targetScale, (double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0);
        for (MapStateData mapStateData : MapBookItem.getMapStates(this.item, (class_1937)this.field_22787.field_1687)) {
            this.method_37060(new MapTile(this, mapStateData.id, mapStateData.mapState, this.field_22787));
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431());
    }

    public boolean method_25421() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean method_25402(double mouseX, double mouseY, int button) {
        block3: {
            if (button != 0 || !class_437.method_25442() || (id = MapBookScreen.getMapBookId(this.item)) == -1) break block3;
            marker = MapBookStateManager.INSTANCE.getClientMapBookState((int)MapBookScreen.getMapBookId((class_1799)this.item)).marker;
            pos = new class_243(mouseX, mouseY, 0.0);
            pos = pos.method_1021((double)(1.0f / this.scale));
            pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
            pos = pos.method_1023(this.x / (double)this.scale, this.y / (double)this.scale, 0.0);
            dim = this.field_22787.field_1687.method_40134().method_55840();
            if (!marker.dimension.contains(dim)) ** GOTO lbl-1000
            v0 = new class_243(marker.x, marker.z, 0.0);
            if (pos.method_1022(v0) * (double)this.scale > 5.0) lbl-1000:
            // 2 sources

            {
                class_310.method_1551().method_1562().method_45731(String.format("mapBookMarker %s \"%s\" \"%s\" \"%s\"", new Object[]{MapBookScreen.getMapBookId(this.item), pos.method_10216(), pos.method_10214(), dim}));
            } else {
                class_310.method_1551().method_1562().method_45731(String.format("mapBookMarker %s \"%s\" \"%s\" \"%s\"", new Object[]{MapBookScreen.getMapBookId(this.item), 0, 0, ""}));
            }
        }
        if (button == 2 && this.field_22787.field_1724.method_31549().field_7477) {
            pos = new class_243(mouseX, mouseY, 0.0);
            pos = pos.method_1021((double)(1.0f / this.scale));
            pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
            pos = pos.method_1023(this.x / (double)this.scale, this.y / (double)this.scale, 0.0);
            class_310.method_1551().method_1562().method_45731(String.format("tp %.6f %.6f %.6f", new Object[]{pos.method_10216(), this.field_22787.field_1724.method_23318(), pos.method_10214()}));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button < 2 && !class_437.method_25442()) {
            this.x += deltaX;
            this.y += deltaY;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount != 0.0) {
            this.targetScale = this.zoom(this.scale, (float)(-verticalAmount));
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (context == null) {
            return;
        }
        if (this.scale != this.targetScale) {
            float newScale = class_3532.method_16439((float)delta, (float)this.scale, (float)this.targetScale);
            this.setScale(newScale, mouseX, mouseY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        class_746 thisPlayer = this.field_22787.field_1724;
        if (thisPlayer == null) {
            return;
        }
        int id = MapBookScreen.getMapBookId(this.item);
        if (id != -1) {
            MapBookPlayer p = new MapBookPlayer();
            p.setPlayer((class_1657)thisPlayer);
            ArrayList<MapBookPlayer> m = MapBookStateManager.INSTANCE.getClientMapBookState((int)id).players;
            if (m != null) {
                try {
                    for (MapBookPlayer player : m) {
                        if (!player.dimension.contains(p.dimension) || player.name.contains(p.name)) continue;
                        this.renderPlayerIcon(context, player, false);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
            this.renderPlayerIcon(context, p, true);
            this.renderIcons(context);
            MapBookPlayer marker = MapBookStateManager.INSTANCE.getClientMapBookState((int)id).marker;
            if (marker.dimension.contains(p.dimension)) {
                this.renderMarker(context, marker);
            }
            this.renderPosition(context, mouseX, mouseY);
        }
    }

    private void renderPosition(class_332 context, int mouseX, int mouseY) {
        class_243 pos = new class_243((double)mouseX, (double)mouseY, 0.0);
        pos = pos.method_1021((double)(1.0f / this.scale));
        pos = pos.method_1023((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
        pos = pos.method_1023(this.x / (double)this.scale, this.y / (double)this.scale, 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        String text = (int)pos.method_10216() + ", " + (int)pos.method_10214();
        float o = textRenderer.method_1727(text);
        Objects.requireNonNull(textRenderer);
        class_4587 matrix = context.method_51448();
        matrix.method_22903();
        matrix.method_22904((double)this.field_22789 / 2.0, (double)this.field_22790 - 60.0, 20.0);
        matrix.method_46416(-o / 2.0f, 8.0f, 0.1f);
        textRenderer.method_27521(text, 0.0f, 0.0f, -1, false, matrix.method_23760().method_23761(), (class_4597)((DrawContextAccessor)context).getVertexConsumers(), class_327.class_6415.field_33993, Integer.MIN_VALUE, 0xF000F0);
        matrix.method_22909();
    }

    private void renderPlayerIcon(class_332 context, MapBookPlayer player, boolean thisPlayer) {
        float x = (float)player.x;
        float z = (float)player.z;
        float rotation = player.yaw;
        class_4587 matrix = context.method_51448();
        matrix.method_22903();
        matrix.method_22904(this.x, this.y, 0.0);
        matrix.method_22905(this.scale, this.scale, 1.0f);
        matrix.method_22904((double)x + (double)this.field_22789 / 2.0, (double)z + (double)this.field_22790 / 2.0, 0.0);
        matrix.method_22907(class_7833.field_40718.rotationDegrees(rotation));
        matrix.method_22905(8.0f, 8.0f, -3.0f);
        matrix.method_46416(0.0f, 0.0f, thisPlayer ? -12.0f : -11.0f);
        matrix.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
        class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(class_21.field_91, 0, 0, 0, Optional.empty()));
        float g = sprite.method_4594();
        float h = sprite.method_4593();
        float l = sprite.method_4577();
        float m = sprite.method_4575();
        Matrix4f matrix4f2 = matrix.method_23760().method_23761();
        class_4588 vertexConsumer2 = ((DrawContextAccessor)context).getVertexConsumers().getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
        vertexConsumer2.method_22918(matrix4f2, -1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, h).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, 1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, h).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, 1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, m).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, -1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, m).method_60803(0xF000F0);
        matrix.method_22909();
        class_327 textRenderer = class_310.method_1551().field_1772;
        String text = player.name;
        float o = textRenderer.method_1727(text);
        Objects.requireNonNull(textRenderer);
        matrix.method_22903();
        matrix.method_22904(this.x, this.y, 15.0);
        matrix.method_22905(this.scale, this.scale, 1.0f);
        matrix.method_22904((double)x + (double)this.field_22789 / 2.0, (double)z + (double)this.field_22790 / 2.0, 0.0);
        matrix.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
        matrix.method_46416(-o / 2.0f, 8.0f, thisPlayer ? 12.0f : 11.0f);
        textRenderer.method_27521(text, 0.0f, 0.0f, -1, false, matrix.method_23760().method_23761(), (class_4597)((DrawContextAccessor)context).getVertexConsumers(), class_327.class_6415.field_33993, Integer.MIN_VALUE, 0xF000F0);
        matrix.method_22909();
    }

    private void renderIcons(class_332 context) {
        int light = 0xF000F0;
        for (MapStateData mapStateData : this.getMapStates(this.item, (class_1937)this.field_22787.field_1687)) {
            double render = 0.0;
            if (this.field_22787.field_1687.method_40134().method_55840().contains(mapStateData.mapState.field_118.method_29177().toString())) {
                render = 1.0;
            }
            if (this.field_22787.field_1687.method_40134().method_55840().contains("the_nether") && mapStateData.mapState.field_118.method_29177().toString().contains("overworld")) {
                render = 0.125;
            }
            if (!(render > 0.0)) continue;
            Iterator var11 = mapStateData.mapState.method_32373().iterator();
            class_4587 matrix = context.method_51448();
            while (var11.hasNext()) {
                class_20 mapIcon = (class_20)var11.next();
                if (mapIcon.comp_1842().method_55840().contains("player")) continue;
                matrix.method_22903();
                matrix.method_22904(this.x, this.y, 0.0);
                matrix.method_22905(this.scale, this.scale, 1.0f);
                float mapScale = (float)Math.pow(2.0, mapStateData.mapState.field_119);
                float offset = 64.0f * mapScale;
                double x = (double)((float)mapStateData.mapState.field_116 - offset + (float)(mapIcon.comp_1843() + 128 + 1) * mapScale / 2.0f) * render;
                double z = (double)((float)mapStateData.mapState.field_115 - offset + (float)(mapIcon.comp_1844() + 128 + 1) * mapScale / 2.0f) * render;
                matrix.method_22904(x + (double)this.field_22789 / 2.0, z + (double)this.field_22790 / 2.0, 0.0);
                matrix.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                matrix.method_22905(8.0f, 8.0f, -3.0f);
                matrix.method_46416(0.0f, 0.0f, -10.0f);
                matrix.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
                class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(mapIcon.comp_1842(), 0, 0, 0, Optional.empty()));
                float g = sprite.method_4594();
                float h = sprite.method_4593();
                float l = sprite.method_4577();
                float m = sprite.method_4575();
                Matrix4f matrix4f2 = matrix.method_23760().method_23761();
                class_4588 vertexConsumer2 = ((DrawContextAccessor)context).getVertexConsumers().getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
                vertexConsumer2.method_22918(matrix4f2, -1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, h).method_60803(0xF000F0);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, h).method_60803(0xF000F0);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, m).method_60803(0xF000F0);
                vertexConsumer2.method_22918(matrix4f2, -1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, m).method_60803(0xF000F0);
                matrix.method_22909();
                if (!mapIcon.comp_1846().isPresent()) continue;
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = (class_2561)mapIcon.comp_1846().get();
                float o = textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                matrix.method_22903();
                matrix.method_22904(this.x, this.y, 11.0);
                matrix.method_22905(this.scale, this.scale, 1.0f);
                double mapx = (double)((float)mapStateData.mapState.field_116 - offset + (float)(mapIcon.comp_1843() + 128 + 1) * mapScale / 2.0f) * render;
                double mapz = (double)((float)mapStateData.mapState.field_115 - offset + (float)(mapIcon.comp_1844() + 128 + 1) * mapScale / 2.0f) * render;
                matrix.method_22904(mapx + (double)this.field_22789 / 2.0, mapz + (double)this.field_22790 / 2.0, 0.0);
                matrix.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
                matrix.method_46416(-o / 2.0f, 8.0f, 0.1f);
                textRenderer.method_30882(text, 0.0f, 0.0f, -1, false, matrix.method_23760().method_23761(), (class_4597)((DrawContextAccessor)context).getVertexConsumers(), class_327.class_6415.field_33993, Integer.MIN_VALUE, light);
                matrix.method_22909();
            }
        }
    }

    private void renderMarker(class_332 context, MapBookPlayer player) {
        float x = (float)player.x;
        float z = (float)player.z;
        float rotation = player.yaw;
        class_4587 matrix = context.method_51448();
        matrix.method_22903();
        matrix.method_22904(this.x, this.y, 0.0);
        matrix.method_22905(this.scale, this.scale, 1.0f);
        matrix.method_22904((double)x + (double)this.field_22789 / 2.0, (double)z + (double)this.field_22790 / 2.0, 0.0);
        matrix.method_22907(class_7833.field_40718.rotationDegrees(rotation));
        matrix.method_22905(8.0f, 8.0f, -3.0f);
        matrix.method_46416(0.0f, 0.0f, -10.5f);
        matrix.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
        class_1058 sprite = this.field_22787.method_58476().method_58516(new class_20(class_21.field_84, 0, 0, 0, Optional.empty()));
        float g = sprite.method_4594();
        float h = sprite.method_4593();
        float l = sprite.method_4577();
        float m = sprite.method_4575();
        Matrix4f matrix4f2 = matrix.method_23760().method_23761();
        class_4588 vertexConsumer2 = ((DrawContextAccessor)context).getVertexConsumers().getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
        vertexConsumer2.method_22918(matrix4f2, -1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, h).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, 1.0f, 1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, h).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, 1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(l, m).method_60803(0xF000F0);
        vertexConsumer2.method_22918(matrix4f2, -1.0f, -1.0f, -0.1f).method_1336(255, 255, 255, 255).method_22913(g, m).method_60803(0xF000F0);
        matrix.method_22909();
        matrix.method_22909();
    }

    private ArrayList<MapStateData> getMapStates(class_1799 stack, class_1937 world) {
        ArrayList<MapStateData> list = new ArrayList<MapStateData>();
        MapBookState mapBookState = this.getMapBookState(stack, world);
        if (mapBookState != null) {
            for (int i : mapBookState.mapIDs) {
                class_22 mapState = world.method_17891(new class_9209(i));
                if (mapState == null) continue;
                list.add(new MapStateData(new class_9209(i), mapState));
            }
        }
        return list;
    }

    private MapBookState getMapBookState(class_1799 stack, class_1937 world) {
        int id = MapBookScreen.getMapBookId(stack);
        if (id == -1) {
            return null;
        }
        return MapBookStateManager.INSTANCE.getClientMapBookState(id);
    }

    private static int getMapBookId(class_1799 stack) {
        class_9209 mapIdComponent = (class_9209)stack.method_57825(class_9334.field_49646, null);
        if (mapIdComponent != null) {
            return mapIdComponent.comp_2315();
        }
        return -1;
    }

    private void setScale(float newScale, double mouseX, double mouseY) {
        double offsetX = this.x - mouseX;
        double offsetY = this.y - mouseY;
        double scaleChange = newScale / this.scale;
        this.x = scaleChange * offsetX + mouseX;
        this.y = scaleChange * offsetY + mouseY;
        this.scale = newScale;
    }

    private float zoom(float start, float scroll) {
        float absScroll = Math.abs(scroll);
        float speed = 5.0f;
        float newZoom = scroll > 0.0f ? start - start / (scroll * speed) : start * absScroll * speed / (absScroll * speed - 1.0f);
        newZoom = Math.min(Math.max(newZoom, 0.005f), 10.0f);
        return newZoom;
    }
}

