/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.registry.item.map_book;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.greenjab.fixedminecraft.network.MapBookOpenPayload;
import net.greenjab.fixedminecraft.network.MapBookSyncPayload;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookAdditionsComponent;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookIdCountsState;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookState;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookStateManager;
import net.greenjab.fixedminecraft.registry.item.map_book.MapStateData;
import net.greenjab.fixedminecraft.registry.registries.ItemRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_8710;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class MapBookItem
extends class_1792 {
    public MapBookItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (blockState.method_26164(class_3481.field_15501)) {
            if (!context.method_8045().field_9236) {
                MapStateData mapStateData = this.getNearestMap(context.method_8041(), context.method_8045(), context.method_8037().method_46558());
                class_22 mapState = mapStateData.mapState;
                if (mapState != null && !mapState.method_108((class_1936)context.method_8045(), context.method_8037())) {
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world != null && !world.method_8608()) {
            class_3222 player = (class_3222)user;
            class_1799 item = user.method_5998(hand);
            class_1799 otherHand = hand == class_1268.field_5808 ? player.method_6079() : player.method_6047();
            boolean openMap = true;
            if (this.getNearestMap(item, world, player.method_19538()) == null) {
                if (this.addNewMapAtPos(item, (class_3218)world, player.method_19538(), 0)) {
                    player.method_37908().method_43129(null, (class_1297)player, class_3417.field_17484, player.method_5634(), 1.0f, 1.0f);
                    openMap = false;
                }
            } else if (otherHand.method_31574(class_1802.field_8868)) {
                if (this.removeMapAtPos(item, (class_3218)world, player.method_19538(), player)) {
                    otherHand.method_7970(1, (class_1309)player, class_1304.field_6171);
                    player.method_37908().method_43129(null, (class_1297)player, class_3417.field_14975, player.method_5634(), 1.0f, 1.0f);
                    openMap = false;
                }
            } else if (otherHand.method_31574(class_1802.field_8204)) {
                if (this.addNewMapID(item, otherHand, (class_3218)world)) {
                    if (!player.method_31549().field_7477) {
                        otherHand.method_7934(1);
                    }
                    player.method_37908().method_43129(null, (class_1297)player, class_3417.field_17484, player.method_5634(), 1.0f, 1.0f);
                    openMap = false;
                }
            } else if (otherHand.method_31574(class_1802.field_8895)) {
                if (this.addNewMapAtPos(item, (class_3218)world, player.method_19538(), 0)) {
                    if (!player.method_31549().field_7477) {
                        otherHand.method_7934(1);
                    }
                    player.method_37908().method_43129(null, (class_1297)player, class_3417.field_17484, player.method_5634(), 1.0f, 1.0f);
                    openMap = false;
                }
            } else {
                class_1799 hasEmtpyMap = this.getEmptyMap(user);
                if (hasEmtpyMap.method_31574(class_1802.field_8895)) {
                    boolean hotbar = this.isHotbar(user, hasEmtpyMap);
                    if (this.addNewMapAtPos(item, (class_3218)world, player.method_19538(), hotbar ? 2 : 4)) {
                        if (!player.method_31549().field_7477) {
                            hasEmtpyMap.method_7934(1);
                        }
                        player.method_37908().method_43129(null, (class_1297)player, class_3417.field_17484, player.method_5634(), 1.0f, 1.0f);
                        openMap = false;
                    }
                }
            }
            this.sendMapUpdates(player, item);
            this.mapBookSync(player, item);
            if (openMap && this.hasMapBookId(item)) {
                MapBookItem.getMapBookState(item, world).update();
                this.mapBookOpen(player, item);
                player.method_37908().method_43129(null, (class_1297)player, class_3417.field_17481, player.method_5634(), 1.0f, 1.0f);
            }
        }
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    private class_1799 getEmptyMap(class_1657 playerEntity) {
        for (int i = 0; i < playerEntity.method_31548().method_5439(); ++i) {
            class_1799 item = playerEntity.method_31548().method_5438(i);
            if (!item.method_31574(class_1802.field_8895)) continue;
            return item;
        }
        return class_1799.field_8037;
    }

    private boolean isHotbar(class_1657 playerEntity, class_1799 stack) {
        for (int i = 0; i < 9; ++i) {
            class_1799 item = playerEntity.method_31548().method_5438(i);
            if (item != stack) continue;
            return true;
        }
        return false;
    }

    private void sendMapUpdates(class_3222 player, class_1799 item) {
        for (MapStateData mapStateData : MapBookItem.getMapStates(item, player.method_37908())) {
            mapStateData.mapState.method_101((class_1657)player);
            class_2596 packet = mapStateData.mapState.method_100(mapStateData.id, (class_1657)player);
            if (packet == null) continue;
            player.field_13987.method_14364(packet);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world != null && !world.method_8608() && stack != null && entity instanceof class_3222) {
            MapBookState mapBookState;
            class_3222 player = (class_3222)entity;
            int id = MapBookItem.getMapBookId(stack);
            if (id != -1 && (mapBookState = MapBookStateManager.INSTANCE.getMapBookState(world.method_8503(), id)) != null) {
                mapBookState.addPlayer((class_1657)player);
            }
            if (!MapBookStateManager.INSTANCE.currentBooks.contains(id)) {
                MapBookStateManager.INSTANCE.currentBooks.add(id);
            }
            if (selected || ((class_1657)entity).method_6079() == stack) {
                for (MapStateData mapStateData : MapBookItem.getMapStates(stack, entity.method_37908())) {
                    mapStateData.mapState.method_102((class_1657)player, stack);
                    if (mapStateData.mapState.field_17403 || !(this.getDistanceToEdgeOfMap(mapStateData.mapState, entity.method_19538()) < 128.0)) continue;
                    ((class_1806)class_1802.field_8204).method_7998(world, entity, mapStateData.mapState);
                }
                this.sendMapUpdates(player, stack);
            }
        }
    }

    public static ArrayList<MapStateData> getMapStates(class_1799 stack, class_1937 world) {
        ArrayList<MapStateData> list = new ArrayList<MapStateData>();
        MapBookState mapBookState = MapBookItem.getMapBookState(stack, world);
        if (mapBookState != null) {
            for (int i : mapBookState.mapIDs) {
                class_22 mapState = world.method_17891(new class_9209(i));
                if (mapState == null || !world.method_40134().method_55840().contains(mapState.field_118.method_29177().toString())) continue;
                list.add(new MapStateData(new class_9209(i), mapState));
            }
        }
        return list;
    }

    private static MapBookState getMapBookState(class_1799 stack, class_1937 world) {
        int id = MapBookItem.getMapBookId(stack);
        if (id == -1) {
            return null;
        }
        if (world.field_9236) {
            return MapBookStateManager.INSTANCE.getClientMapBookState(id);
        }
        if (world.method_8503() != null) {
            return MapBookStateManager.INSTANCE.getMapBookState(world.method_8503(), id);
        }
        return null;
    }

    public MapStateData getNearestMap(class_1799 stack, class_1937 world, class_243 pos) {
        double nearestDistance = Double.MAX_VALUE;
        byte nearestScale = 127;
        MapStateData nearestMap = null;
        Iterator<MapStateData> mapStates = MapBookItem.getMapStates(stack, world).iterator();
        while (mapStates.hasNext()) {
            boolean roughlyEqual;
            MapStateData mapStateData = mapStates.next();
            double distance = this.getDistanceToEdgeOfMap(mapStateData.mapState, pos);
            if (distance < 0.0) {
                distance = -1.0;
            }
            boolean bl = roughlyEqual = Math.abs(nearestDistance - distance) < 1.0;
            if (!(distance < nearestDistance) && !roughlyEqual || !(!roughlyEqual || distance < 0.0 && mapStateData.mapState.field_119 < nearestScale) && (!(distance > 0.0) || mapStateData.mapState.field_119 <= nearestScale)) continue;
            nearestDistance = distance;
            nearestScale = mapStateData.mapState.field_119;
            nearestMap = mapStateData;
        }
        return nearestMap;
    }

    private double getDistanceToEdgeOfMap(class_22 mapState, class_243 pos) {
        return Math.max(Math.abs(pos.field_1352 - (double)mapState.field_116), Math.abs(pos.field_1350 - (double)mapState.field_115)) - 64.0 * Math.pow(2.0, mapState.field_119);
    }

    private boolean hasMapBookId(class_1799 stack) {
        return stack.method_57826(class_9334.field_49646);
    }

    public static int getMapBookId(class_1799 stack) {
        class_9209 mapIdComponent = (class_9209)stack.method_57825(class_9334.field_49646, null);
        if (mapIdComponent != null) {
            return mapIdComponent.comp_2315();
        }
        return -1;
    }

    private int allocateMapBookId(MinecraftServer server) {
        MapBookIdCountsState counts = (MapBookIdCountsState)server.method_30002().method_17983().method_17924(MapBookIdCountsState.persistentStateType, MapBookIdCountsState.IDCOUNTS_KEY);
        int i = counts.get();
        MapBookStateManager.INSTANCE.putMapBookState(server, i, new MapBookState());
        return i;
    }

    private void setMapBookId(class_1799 stack, int id) {
        stack.method_57379(class_9334.field_49646, (Object)new class_9209(id));
    }

    private int createMapBookState(class_1799 stack, MinecraftServer server) {
        int i = this.allocateMapBookId(server);
        this.setMapBookId(stack, i);
        return i;
    }

    private MapBookState getOrCreateMapBookState(class_1799 stack, MinecraftServer server) {
        MapBookState state;
        int id = MapBookItem.getMapBookId(stack);
        MapBookState mapBookState = state = id == -1 ? null : MapBookStateManager.INSTANCE.getMapBookState(server, id);
        if (state != null) {
            return state;
        }
        int i = this.createMapBookState(stack, server);
        return MapBookStateManager.INSTANCE.getMapBookState(server, i);
    }

    private boolean addNewMapAtPos(class_1799 item, class_3218 world, class_243 pos, int scale) {
        MapBookState state = this.getOrCreateMapBookState(item, world.method_8503());
        MapStateData nearestState = this.getNearestMap(item, (class_1937)world, pos);
        if (nearestState != null && nearestState.mapState.field_119 <= scale && !(this.getDistanceToEdgeOfMap(nearestState.mapState, pos) > 0.0)) {
            return false;
        }
        class_1799 newMap = class_1806.method_8005((class_1937)world, (int)((int)Math.floor(pos.field_1352)), (int)((int)Math.floor(pos.field_1350)), (byte)((byte)scale), (boolean)true, (boolean)false);
        state.addMapID(((class_9209)newMap.method_57824(class_9334.field_49646)).comp_2315());
        return true;
    }

    private boolean removeMapAtPos(class_1799 item, class_3218 world, class_243 pos, class_3222 player) {
        MapBookState state = this.getOrCreateMapBookState(item, world.method_8503());
        if (state.mapIDs.isEmpty()) {
            return false;
        }
        if (MapBookItem.getMapStates(item, (class_1937)world).size() < 2) {
            return false;
        }
        MapStateData nearestState = this.getNearestMap(item, (class_1937)world, pos);
        if (nearestState == null) {
            return false;
        }
        if (this.getDistanceToEdgeOfMap(nearestState.mapState, pos) > 0.0) {
            return false;
        }
        if (state.removeMapID(nearestState.id.comp_2315())) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8204);
            itemStack.method_57379(class_9334.field_49646, (Object)nearestState.id);
            if (!player.method_31548().method_7394(itemStack)) {
                player.method_7328(itemStack, true);
            }
        }
        return true;
    }

    private boolean addNewMapID(class_1799 item, class_1799 filledmap, class_3218 world) {
        class_9209 mapId = (class_9209)filledmap.method_57824(class_9334.field_49646);
        class_22 mapState = world.method_17891(mapId);
        MapBookState state = this.getOrCreateMapBookState(item, world.method_8503());
        if (state != null && !mapState.field_17403 && !state.mapIDs.contains(mapId.comp_2315())) {
            state.addMapID(mapId.comp_2315());
            return true;
        }
        return false;
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack != null && !this.hasMapBookId(stack)) {
            if (stack.method_57826(ItemRegistry.MAP_BOOK_ADDITIONS)) {
                return class_2561.method_43471((String)"item.fixedminecraft.map_book_new");
            }
            return class_2561.method_43471((String)"item.fixedminecraft.map_book_empty");
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        int mapsCount = ((MapBookAdditionsComponent)stack.method_57825(ItemRegistry.MAP_BOOK_ADDITIONS, (Object)MapBookAdditionsComponent.DEFAULT)).additions().size();
        int id = MapBookItem.getMapBookId(stack);
        if (id != -1) {
            MapBookState mapBookState = MapBookStateManager.INSTANCE.getClientMapBookState(id);
            if (mapBookState != null) {
                mapsCount += mapBookState.mapIDs.size();
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"item.fixedminecraft.map_book_id", (Object[])new Object[]{id + 1}).method_27692(class_124.field_1080));
        }
        if (mapsCount > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.fixedminecraft.map_book_maps", (Object[])new Object[]{mapsCount}).method_27692(class_124.field_1080));
        }
    }

    static void setAdditions(class_1799 stack, List<Integer> additions) {
        stack.method_57379(ItemRegistry.MAP_BOOK_ADDITIONS, (Object)new MapBookAdditionsComponent(additions));
    }

    private void applyAdditions(class_1799 stack, class_3218 world) {
        MapBookAdditionsComponent additionsComponent = (MapBookAdditionsComponent)stack.method_57825(ItemRegistry.MAP_BOOK_ADDITIONS, null);
        if (additionsComponent == null) {
            return;
        }
        stack.method_57381(ItemRegistry.MAP_BOOK_ADDITIONS);
        List<Integer> additions = additionsComponent.additions();
        if (!additions.isEmpty()) {
            MapBookState state = this.getOrCreateMapBookState(stack, world.method_8503());
            for (int id : additions) {
                if (id == -1) continue;
                class_22 newState = world.method_17891(new class_9209(id));
                state.mapIDs.removeIf(existingID -> {
                    class_22 existingState = world.method_17891(new class_9209(existingID.intValue()));
                    if (existingState == null) {
                        return true;
                    }
                    assert (newState != null);
                    return MapBookItem.mapsAreSameLocation(newState, existingState);
                });
                state.addMapID(id);
            }
        }
    }

    public static boolean hasInvalidAdditions(class_1799 stack, class_1937 world, List<Integer> additions) {
        MapBookState mapBookState = MapBookItem.getMapBookState(stack, world);
        for (int i = 0; i < additions.size(); ++i) {
            int additionA = additions.get(i);
            if (mapBookState != null && mapBookState.mapIDs.contains(additionA)) {
                return true;
            }
            class_22 mapA = world.method_17891(new class_9209(additionA));
            for (int j = i + 1; j < additions.size(); ++j) {
                int additionB = additions.get(j);
                if (additionA == additionB) {
                    return true;
                }
                class_22 mapB = world.method_17891(new class_9209(additionB));
                if (mapB != null && !MapBookItem.mapsAreSameLocation(mapA, mapB)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean mapsAreSameLocation(class_22 mapA, class_22 mapB) {
        return mapA.field_119 == mapB.field_119 && mapA.field_116 == mapB.field_116 && mapA.field_115 == mapB.field_115;
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_54465(stack, world, player);
        if (!world.field_9236) {
            this.mapBookSync((class_3222)player, stack);
        }
    }

    public void method_7843(class_1799 stack, class_1937 world) {
        if (!world.field_9236) {
            this.applyAdditions(stack, (class_3218)world);
        }
    }

    private void mapBookOpen(class_3222 player, class_1799 itemStack) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new MapBookOpenPayload(itemStack));
    }

    private void mapBookSync(class_3222 player, class_1799 itemStack) {
        MapBookSyncPayload payload = MapBookSyncPayload.of(player, itemStack);
        if (payload != null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }
}

