/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.render;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5684;
import net.minecraft.class_9288;

@Environment(value=EnvType.CLIENT)
public class ContainerTooltipComponent
implements class_5684 {
    private static final class_2960 BUNDLE_SLOT_BACKGROUND_TEXTURE = class_2960.method_60656((String)"container/bundle/slot");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656((String)"container/bundle/background");
    private final class_9288 contents;
    private int numberOfSlots;

    public ContainerTooltipComponent(class_9288 contents) {
        this.contents = contents;
        this.numberOfSlots = (int)Math.min(27L, contents.method_59712().count());
    }

    public int method_32661() {
        return this.getHeightOfNonEmpty() + 4;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getColumnsWidth();
    }

    private int getHeightOfNonEmpty() {
        return this.getRowsHeight();
    }

    private int getRowsHeight() {
        return this.getRows() * 20 + 2;
    }

    private int getRows() {
        if (this.numberOfSlots == 0) {
            return 0;
        }
        return Math.min(ContainerTooltipComponent.ceilDiv(this.numberOfSlots, this.getColumns()), 3);
    }

    private int getColumns() {
        if (this.numberOfSlots == 0) {
            return 0;
        }
        return class_3532.method_15384((double)Math.max(Math.sqrt(this.numberOfSlots), (double)this.numberOfSlots / 3.0));
    }

    private int getColumnsWidth() {
        return this.getColumns() * 18 + 2;
    }

    public static int ceilDiv(int x, int y) {
        int q = x / y;
        if ((x ^ y) >= 0 && q * y != x) {
            return q + 1;
        }
        return q;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        context.method_52706(BACKGROUND_TEXTURE, x, y, this.getColumnsWidth(), this.getRowsHeight());
        this.drawNonEmptyTooltip(textRenderer, x + 1, y + 1, context);
    }

    private void drawNonEmptyTooltip(class_327 textRenderer, int x, int y, class_332 context) {
        List<class_1799> list = this.firstStacksInContents();
        this.numberOfSlots = list.size();
        if (!list.isEmpty()) {
            int i = x;
            int j = y;
            int k = 0;
            block0: for (int l = 0; l < this.getRows(); ++l) {
                for (int m = 0; m < this.getColumns(); ++m) {
                    int n = i + m * 18;
                    int o = j + l * 20;
                    if (k >= this.numberOfSlots) continue block0;
                    this.drawItem(k, n, o, list, k, textRenderer, context);
                    ++k;
                }
            }
        }
    }

    private List<class_1799> firstStacksInContents() {
        int i = (int)Math.min(this.contents.method_59712().count(), 27L);
        return this.contents.method_59712().toList().subList(0, i);
    }

    private void drawItem(int index, int x, int y, List<class_1799> stacks, int seed, class_327 textRenderer, class_332 drawContext) {
        class_1799 itemStack = stacks.get(index);
        drawContext.method_52706(BUNDLE_SLOT_BACKGROUND_TEXTURE, x, y, 18, 20);
        drawContext.method_51428(itemStack, x + 1, y + 1, seed);
        drawContext.method_51431(textRenderer, itemStack, x + 1, y + 1);
    }
}

