/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.mixin.mobs;

import java.util.List;
import java.util.Objects;
import net.greenjab.fixedminecraft.enchanting.FixedMinecraftEnchantmentHelper;
import net.greenjab.fixedminecraft.mobs.ArmorTrimmer;
import net.minecraft.class_10179;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9282;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobEntityMixin<T extends class_1308>
extends class_1309 {
    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initEquipment"}, at={@At(value="HEAD")}, cancellable=true)
    private void Armor(class_5819 random, class_1266 localDifficulty, CallbackInfo ci) {
        class_1304[] var6;
        float f;
        int y = this.method_24515().method_10264();
        boolean pale = this.method_37908().method_23753(this.method_24515()).method_40225(class_1972.field_55052);
        float f2 = f = this.method_37908().method_8407() == class_1267.field_5807 ? 0.25f : 0.15f;
        if (pale) {
            f *= 2.5f;
            this.method_5780("pale");
        }
        if (y < this.method_37908().method_8615()) {
            f += (float)(this.method_37908().method_8615() - y) / 1280.0f;
        }
        for (class_1304 equipmentSlot : var6 = class_1304.values()) {
            class_1799 itemStack;
            if (!(random.method_43057() < f * localDifficulty.method_5458())) continue;
            int i = 0;
            if (random.method_43057() < f) {
                ++i;
            }
            if (random.method_43057() < f) {
                ++i;
            }
            if (random.method_43057() < f) {
                ++i;
            }
            if (random.method_43057() < f) {
                ++i;
            }
            if (equipmentSlot.method_5925() != class_1304.class_1305.field_6178 || !(itemStack = this.method_6118(equipmentSlot)).method_7960()) continue;
            class_1799 item = new class_1799((class_1935)Objects.requireNonNull(class_1308.method_5948((class_1304)equipmentSlot, (int)i)));
            if (i == 0) {
                class_1769 dye = class_1769.method_7803((class_1767)class_1767.method_7791((int)this.method_37908().field_9229.method_43048(16)));
                List<class_1769> colour = List.of(dye);
                item = class_9282.method_57471((class_1799)item, colour);
            }
            this.method_5673(equipmentSlot, ArmorTrimmer.trimAtChanceIfTrimable(item, this.field_5974, this.method_37908().method_30349(), pale));
        }
        ci.cancel();
    }

    @ModifyVariable(method={"enchantEquipment(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/entity/EquipmentSlot;Lnet/minecraft/util/math/random/Random;FLnet/minecraft/world/LocalDifficulty;)V"}, at=@At(value="HEAD", ordinal=0), argsOnly=true)
    private float applySuperEnchantArmor(float power) {
        return power * (this.method_37908().method_23753(this.method_24515()).method_40225(class_1972.field_55052) ? 1.5f : 1.0f);
    }

    @ModifyArg(method={"enchantEquipment(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/entity/EquipmentSlot;Lnet/minecraft/util/math/random/Random;FLnet/minecraft/world/LocalDifficulty;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/mob/MobEntity;equipStack(Lnet/minecraft/entity/EquipmentSlot;Lnet/minecraft/item/ItemStack;)V"), index=1)
    private class_1799 applySuperEnchantArmor(class_1799 stack) {
        return FixedMinecraftEnchantmentHelper.applySuperEnchants(stack, this.field_5974, this.method_37908().method_23753(this.method_24515()).method_40225(class_1972.field_55052));
    }

    @Inject(method={"initialize"}, at={@At(value="HEAD")})
    private void addStuff(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        class_1308 LE = (class_1308)this;
        class_5819 random = LE.method_37908().method_8409();
        int y = LE.method_24515().method_10264();
        if (LE instanceof class_1588 && world.method_8597().comp_642()) {
            this.addEffect(world, difficulty, LE, y);
            this.addModifiers(world, random, LE);
        }
    }

    @Unique
    private void addModifiers(class_5425 world, class_5819 random, class_1308 LE) {
        int i = 0;
        if (world.method_8407() == class_1267.field_5802) {
            i = 1;
        }
        if (world.method_8407() == class_1267.field_5807) {
            i = 2;
        }
        if (this.method_37908().method_23753(this.method_24515()).method_40225(class_1972.field_55052)) {
            i = 3;
        }
        float h = (float)(i * 3) * MobEntityMixin.gaussian();
        MobEntityMixin.increaseHealth(LE, h);
        MobEntityMixin.increaseSpeed(random, LE, i);
    }

    @Unique
    private static void increaseSpeed(class_5819 random, class_1308 LE, int i) {
        if (LE.method_5996(class_5134.field_23719) != null && !LE.method_6109()) {
            LE.method_5996(class_5134.field_23719).method_6192(LE.method_45326(class_5134.field_23719) * (double)(1.0f + (float)i * 0.15f * MobEntityMixin.gaussian()));
        }
    }

    @Unique
    private static void increaseHealth(class_1308 LE, float h) {
        if (LE.method_5996(class_5134.field_23716) != null) {
            LE.method_5996(class_5134.field_23716).method_6192(LE.method_45326(class_5134.field_23716) + (double)h);
            LE.method_6033(LE.method_6032() + h);
        }
    }

    @Unique
    private void addEffect(class_5425 world, class_1266 localDifficulty, class_1308 LE, int y) {
        if (this.field_5974.method_43057() < 0.2f * localDifficulty.method_5458()) {
            boolean pale = this.method_37908().method_23753(this.method_24515()).method_40225(class_1972.field_55052);
            if ((world.method_8314(class_1944.field_9284, LE.method_24515()) < 7 || pale) && !(LE instanceof class_1628) && (this.field_5974.method_43057() < (float)(LE.method_37908().method_8615() - y) / 128.0f || pale)) {
                class_1293 effect = this.getEffect(this.field_5974, (class_1309)LE);
                LE.method_6092(effect);
            }
        }
    }

    @Unique
    private static float gaussian() {
        return (float)(Math.tan(2.7468015225111904 * (Math.random() - 0.5)) / 10.0) + 0.5f;
    }

    @Unique
    public class_1293 getEffect(class_5819 random, class_1309 LE) {
        int i;
        int l = 6;
        if (LE instanceof class_1548) {
            l += 5;
        }
        if (LE instanceof class_1613) {
            l += 3;
        }
        if ((i = random.method_43048(l)) == 0) {
            return new class_1293(class_1294.field_5904, -1, 0);
        }
        if (i == 1) {
            return new class_1293(class_1294.field_5910, -1, 0);
        }
        if (i == 2) {
            return new class_1293(class_1294.field_5913, -1, 1);
        }
        if (i == 3) {
            return new class_1293(class_1294.field_5906, -1, 0);
        }
        if (i == 4) {
            return new class_1293(class_1294.field_5918, -1, 0);
        }
        if (i == 5) {
            return new class_1293(class_1294.field_5898, -1, 0);
        }
        if (i == 6) {
            return new class_1293(class_1294.field_5916, -1, 0);
        }
        if (i == 7) {
            return new class_1293(class_1294.field_5901, -1, 0);
        }
        if (i == 8) {
            return new class_1293(class_1294.field_5911, -1, 0);
        }
        if (i == 9) {
            return new class_1293(class_1294.field_5924, -1, 0);
        }
        if (i == 10) {
            return new class_1293(class_1294.field_5926, -1, 0);
        }
        return new class_1293(class_1294.field_5898, -1, 0);
    }

    @Inject(method={"convertTo(Lnet/minecraft/entity/EntityType;Lnet/minecraft/entity/conversion/EntityConversionContext;Lnet/minecraft/entity/SpawnReason;Lnet/minecraft/entity/conversion/EntityConversionContext$Finalizer;)Lnet/minecraft/entity/mob/MobEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/conversion/EntityConversionType;setUpNewEntity(Lnet/minecraft/entity/mob/MobEntity;Lnet/minecraft/entity/mob/MobEntity;Lnet/minecraft/entity/conversion/EntityConversionContext;)V")})
    private void removeIronGolemTagOnConversion(class_1299<T> entityType, class_10179 context, class_3730 reason, class_10179.class_10180<T> finalizer, CallbackInfoReturnable<T> cir) {
        class_1308 ME = (class_1308)this;
        ME.method_5738("iron_golem");
    }
}

