/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.mixin.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.greenjab.fixedminecraft.FixedMinecraft;
import net.greenjab.fixedminecraft.mobs.EnchantedBookFactory;
import net.greenjab.fixedminecraft.registry.ModTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_3988;
import net.minecraft.class_4140;
import net.minecraft.class_4151;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1646.class})
public abstract class VillagerEntityMixin
extends class_3988 {
    @Unique
    Object2ObjectMap<String, class_6862<class_1887>> biomeEnchants = new Object2ObjectOpenHashMap((Map)ImmutableMap.builder().put((Object)class_3854.field_17071.method_29177().toString(), ModTags.DESERT_TRADES).put((Object)class_3854.field_17072.method_29177().toString(), ModTags.JUNGLE_TRADES).put((Object)class_3854.field_17073.method_29177().toString(), ModTags.PLAINS_TRADES).put((Object)class_3854.field_17074.method_29177().toString(), ModTags.SAVANNA_TRADES).put((Object)class_3854.field_17075.method_29177().toString(), ModTags.SNOW_TRADES).put((Object)class_3854.field_17076.method_29177().toString(), ModTags.SWAMP_TRADES).put((Object)class_3854.field_17077.method_29177().toString(), ModTags.TAIGA_TRADES).build());
    @Unique
    class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    @Shadow
    public abstract void method_18403(class_2338 var1);

    public VillagerEntityMixin(class_1299<? extends VillagerEntityMixin> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList;")})
    private static ImmutableList<class_4140<?>> addModules(ImmutableList<class_4140<?>> original) {
        return ImmutableList.of((Object)class_4140.field_18438, (Object)class_4140.field_18439, (Object)class_4140.field_25160, (Object)class_4140.field_18440, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19006, (Object)class_4140.field_18443, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22332, (Object)class_4140.field_38397, (Object[])new class_4140[]{class_4140.field_18445, class_4140.field_18446, class_4140.field_18447, class_4140.field_18448, class_4140.field_18449, class_4140.field_26389, class_4140.field_19007, class_4140.field_18451, class_4140.field_18452, class_4140.field_18453, class_4140.field_18873, class_4140.field_19008, class_4140.field_19009, class_4140.field_19293, class_4140.field_19385, class_4140.field_20616, class_4140.field_19386, class_4140.field_25754, class_4140.field_22333, class_4140.field_22348, class_4140.field_22347});
    }

    @ModifyExpressionValue(method={"canSummonGolem"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;hasRecentlySlept(J)Z")})
    private boolean dontNeedSleep(boolean original) {
        return true;
    }

    @Redirect(method={"summonGolem"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"))
    private int summon1GolemPerHostileMob(List<class_1646> instance, @Local(argsOnly=true) int requiredCount) {
        class_1646 villagerEntity;
        if (instance.size() >= requiredCount && (villagerEntity = (class_1646)this).method_18868().method_18896(class_4140.field_18453)) {
            class_1309 enemy = (class_1309)villagerEntity.method_18868().method_46873(class_4140.field_18453).get();
            if (enemy.method_5752().contains("iron_golem")) {
                return 0;
            }
            if (this.eat(villagerEntity)) {
                enemy.method_5780("iron_golem");
            } else {
                return 0;
            }
        }
        return instance.size();
    }

    @Unique
    private boolean eat(class_1646 villagerEntity) {
        for (int i = 0; i < villagerEntity.method_35199().method_5439(); ++i) {
            Integer integer;
            class_1799 itemStack = villagerEntity.method_35199().method_5438(i);
            if (itemStack.method_7960() || (integer = (Integer)class_1646.field_18526.get(itemStack.method_7909())) == null) continue;
            villagerEntity.method_35199().method_5434(i, 1);
            return true;
        }
        return false;
    }

    @Inject(method={"onInteractionWith"}, at={@At(value="INVOKE", target="Lnet/minecraft/village/VillagerGossips;startGossip(Ljava/util/UUID;Lnet/minecraft/village/VillagerGossipType;I)V", ordinal=2)})
    private void rideCamel(class_4151 interaction, class_1297 entity, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        if (villagerEntity.method_5765()) {
            class_1297 vehicle = villagerEntity.method_5854();
            assert (vehicle != null);
            if (vehicle.method_5864() == class_1299.field_40116) {
                villagerEntity.method_5848();
            }
        } else if (entity.method_5765()) {
            List passengers;
            class_1297 vehicle = entity.method_5854();
            assert (vehicle != null);
            if (vehicle.method_5864() == class_1299.field_40116 && (passengers = vehicle.method_5685()).size() == 1) {
                villagerEntity.method_5804(vehicle);
            }
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void saveCustomData(class_2487 nbt, CallbackInfo ci) {
        Optional sleepTime;
        Optional gossipTime;
        class_1646 villagerEntity = (class_1646)this;
        Optional lastVillager = villagerEntity.method_18868().method_46873(class_4140.field_22333);
        if (lastVillager != null && lastVillager.isPresent()) {
            nbt.method_10582("lastVillager", ((UUID)lastVillager.get()).toString());
        }
        if ((gossipTime = villagerEntity.method_18868().method_46873(class_4140.field_22348)) != null && gossipTime.isPresent()) {
            nbt.method_10569("gossipTime", ((Integer)gossipTime.get()).intValue());
        }
        if ((sleepTime = villagerEntity.method_18868().method_46873(class_4140.field_22347)) != null && sleepTime.isPresent()) {
            nbt.method_10569("sleepTime", ((Integer)sleepTime.get()).intValue());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void loadCustomData(class_2487 nbt, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        String s = nbt.method_68564("lastVillager", "");
        if (!s.isEmpty()) {
            villagerEntity.method_18868().method_18878(class_4140.field_22333, (Object)UUID.fromString(s));
        }
        villagerEntity.method_18868().method_18879(class_4140.field_22348, nbt.method_10550("gossipTime"));
        villagerEntity.method_18868().method_18879(class_4140.field_22347, nbt.method_10550("sleepTime"));
    }

    @Inject(method={"sleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void requirePrivacy(class_2338 pos, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        List list = villagerEntity.method_37908().method_8390(class_1646.class, villagerEntity.method_5829().method_1009(15.0, 5.0, 15.0), class_1301.field_6157);
        int canSee = 0;
        for (class_1646 villager : list) {
            if (villager == villagerEntity || villager.method_6109() || villagerEntity.method_6109() || !villagerEntity.method_6057((class_1297)villager)) continue;
            ++canSee;
        }
        if (canSee > 1) {
            ci.cancel();
        }
        villagerEntity.method_18868().method_18878(class_4140.field_22347, (Object)0);
    }

    @Inject(method={"talkWithVillager"}, at={@At(value="HEAD")})
    private void talktime(class_3218 world, class_1646 villager, long time, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        Optional lastVillager = villagerEntity.method_18868().method_46873(class_4140.field_22333);
        if (lastVillager != null && lastVillager.isPresent()) {
            if (lastVillager.get() != villager.method_5667()) {
                villagerEntity.method_18868().method_18878(class_4140.field_22348, (Object)0);
                villagerEntity.method_18868().method_18878(class_4140.field_22333, (Object)villager.method_5667());
            }
        } else {
            villagerEntity.method_18868().method_18878(class_4140.field_22333, (Object)villager.method_5667());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void increaseStats(CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        Optional sleepTime = villagerEntity.method_18868().method_46873(class_4140.field_22347);
        if (sleepTime != null && sleepTime.isPresent()) {
            villagerEntity.method_18868().method_18878(class_4140.field_22347, (Object)((Integer)sleepTime.get() + 1));
        } else {
            villagerEntity.method_18868().method_18878(class_4140.field_22347, (Object)0);
        }
        Optional gossipTime = villagerEntity.method_18868().method_46873(class_4140.field_22348);
        if (gossipTime != null && gossipTime.isPresent()) {
            villagerEntity.method_18868().method_18878(class_4140.field_22348, (Object)((Integer)gossipTime.get() + 1));
        } else {
            villagerEntity.method_18868().method_18878(class_4140.field_22348, (Object)0);
        }
    }

    @Inject(method={"prepareOffersFor"}, at={@At(value="TAIL")})
    private void happiness(class_1657 player, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        Optional sleepTime = villagerEntity.method_18868().method_46873(class_4140.field_22347);
        int timeSinceSleep = 0;
        if (sleepTime != null && sleepTime.isPresent()) {
            timeSinceSleep = (Integer)sleepTime.get();
        } else {
            villagerEntity.method_18868().method_18878(class_4140.field_22347, (Object)0);
        }
        Optional gossipTime = villagerEntity.method_18868().method_46873(class_4140.field_22348);
        int timeSinceGossip = 0;
        if (gossipTime != null && gossipTime.isPresent()) {
            timeSinceGossip = (Integer)gossipTime.get();
        } else {
            villagerEntity.method_18868().method_18878(class_4140.field_22348, (Object)0);
        }
        if (timeSinceSleep > 48000) {
            for (class_1914 tradeOffer : this.method_8264()) {
                tradeOffer.method_8245((int)Math.min((double)(5 * (timeSinceSleep - 48000)) / 24000.0, 32.0));
            }
        }
        if (timeSinceGossip > 48000) {
            for (class_1914 tradeOffer : this.method_8264()) {
                tradeOffer.method_8245((int)Math.min((double)(5 * (timeSinceGossip - 48000)) / 24000.0, 32.0));
            }
        }
    }

    @ModifyVariable(method={"fillRecipes"}, at=@At(value="STORE"), ordinal=0)
    private Int2ObjectMap<class_3853.class_1652[]> newTrades(Int2ObjectMap<class_3853.class_1652[]> iter, @Local class_3850 villagerData) {
        if (villagerData.comp_3521().method_55840().contains(class_3852.field_17060.method_29177().toString())) {
            return new Int2ObjectOpenHashMap((Map)ImmutableMap.builder().put((Object)1, (Object)new class_3853.class_1652[]{new class_3853.class_4161((class_1935)class_1802.field_8407, 24, 16, 2), new class_3853.class_4161((class_1935)class_1802.field_8529, 4, 12, 2), new class_3853.class_4165(class_2246.field_10504, 9, 1, 12, 1)}).put((Object)2, (Object)new class_3853.class_1652[]{this.firstBook(villagerData), new class_3853.class_4165(class_2246.field_40276, 1, 1, 12, 5)}).put((Object)3, (Object)new class_3853.class_1652[]{new class_3853.class_4161((class_1935)class_1802.field_8794, 5, 12, 20), new class_3853.class_4165(class_1802.field_8280, 1, 4, 10), new class_3853.class_4165(class_1802.field_8557, 5, 1, 15), new class_3853.class_4165(class_1802.field_8251, 4, 1, 15), new class_3853.class_4165(class_1802.field_16539, 4, 1, 10)}).put((Object)4, (Object)new class_3853.class_1652[]{this.anyBook(), new class_3853.class_4161((class_1935)class_1802.field_8674, 2, 12, 30)}).put((Object)5, (Object)new class_3853.class_1652[]{this.masterBook(villagerData), new class_3853.class_4165(class_1802.field_8448, 20, 1, 30)}).build());
        }
        return iter;
    }

    @Unique
    private EnchantedBookFactory firstBook(class_3850 villagerData) {
        int l;
        class_1799 itemStack;
        class_5819 rn = this.method_37908().field_9229;
        class_1646 villagerEntity = (class_1646)this;
        Optional optional = villagerEntity.method_37908().method_30349().method_30530(class_7924.field_41265).method_56159((class_6862)this.biomeEnchants.get((Object)villagerData.comp_3520().method_55840()), this.field_5974);
        int i = 0;
        while (i < 10) {
            ++i;
            if (!optional.isPresent()) continue;
            class_6880 registryEntry = (class_6880)optional.get();
            class_1887 enchantment = (class_1887)registryEntry.comp_349();
            if (enchantment.method_8183() != 1 || registryEntry.method_40220(class_9636.field_51551)) {
                i = 10;
                continue;
            }
            optional = villagerEntity.method_37908().method_30349().method_30530(class_7924.field_41265).method_56159((class_6862)this.biomeEnchants.get((Object)villagerData.comp_3520().method_55840()), this.field_5974);
        }
        if (optional.isPresent()) {
            class_6880 registryEntry = (class_6880)optional.get();
            class_1887 enchantment = (class_1887)registryEntry.comp_349();
            int maxLevel = enchantment.method_8183();
            int midLevel = (int)Math.ceil((double)maxLevel / 2.0);
            int level = maxLevel == 1 ? 1 : rn.method_43048(midLevel) + 1;
            itemStack = class_1890.method_61711((class_1889)new class_1889(registryEntry, level));
            l = 2 + this.field_5974.method_43048(5 + level * 10) + 3 * level;
            if (registryEntry.method_40220(class_9636.field_51546)) {
                l *= 2;
            }
            if (l > 64) {
                l = 64;
            }
        } else {
            l = 1;
            itemStack = new class_1799((class_1935)class_1802.field_8529);
        }
        return new EnchantedBookFactory(itemStack, l, 10);
    }

    @Unique
    private EnchantedBookFactory masterBook(class_3850 villagerData) {
        int l;
        class_1799 itemStack;
        Object villager22;
        class_5819 rn = this.method_37908().field_9229;
        class_1646 villagerEntity = (class_1646)this;
        Optional<class_6880> optional = villagerEntity.method_37908().method_30349().method_30530(class_7924.field_41265).method_56159((class_6862)this.biomeEnchants.get((Object)villagerData.comp_3520().method_55840()), this.field_5974);
        Iterable optional2 = villagerEntity.method_37908().method_30349().method_30530(class_7924.field_41265).method_40286((class_6862)this.biomeEnchants.get((Object)villagerData.comp_3520().method_55840()));
        HashMap<class_6880, Float> possibleEnchantCount = new HashMap<class_6880, Float>();
        optional2.forEach(enchant -> possibleEnchantCount.put((class_6880)enchant, Float.valueOf(0.1f)));
        List list = villagerEntity.method_5770().method_8390(class_1646.class, villagerEntity.method_5829().method_1014(32.0), class_1301.field_6157);
        for (Object villager22 : list) {
            if (villager22 == villagerEntity || villager22.method_7231().comp_3521() != class_3852.field_17060) continue;
            class_1799 eBook = class_1799.field_8037;
            if (villager22.method_8264().size() >= 10) {
                if (((class_1914)villager22.method_8264().get(8)).method_8250().method_31574(class_1802.field_8598)) {
                    eBook = ((class_1914)villager22.method_8264().get(8)).method_8250();
                } else if (((class_1914)villager22.method_8264().get(9)).method_8250().method_31574(class_1802.field_8598)) {
                    eBook = ((class_1914)villager22.method_8264().get(9)).method_8250();
                }
            }
            if (!eBook.method_31574(class_1802.field_8598)) continue;
            for (class_6880 e2 : class_1890.method_57532((class_1799)eBook).method_57534()) {
                if (!possibleEnchantCount.containsKey(e2)) continue;
                possibleEnchantCount.put(e2, Float.valueOf(((Float)possibleEnchantCount.get(e2)).floatValue() + 1.0f));
            }
        }
        possibleEnchantCount.replaceAll((e, v) -> Float.valueOf(e.method_40220(class_9636.field_51551) ? 0.0f : 1.0f / v.floatValue()));
        float max = 0.0f;
        villager22 = possibleEnchantCount.values().iterator();
        while (villager22.hasNext()) {
            float f = ((Float)villager22.next()).floatValue();
            max += f;
        }
        float rand = villagerEntity.method_37908().field_9229.method_43057() * max;
        if (max != 0.0f) {
            for (class_6880 ee : possibleEnchantCount.keySet()) {
                if (!((rand -= ((Float)possibleEnchantCount.get(ee)).floatValue()) <= 0.0f)) continue;
                optional = Optional.ofNullable(ee);
                break;
            }
        }
        if (optional.isPresent()) {
            class_6880 registryEntry = (class_6880)optional.get();
            class_1887 enchantment = (class_1887)registryEntry.comp_349();
            int maxLevel = enchantment.method_8183();
            int midLevel = (int)Math.ceil((double)maxLevel / 2.0);
            int level = maxLevel == 1 ? 1 : midLevel + rn.method_43048(maxLevel - midLevel) + 1;
            itemStack = class_1890.method_61711((class_1889)new class_1889(registryEntry, level));
            l = 2 + this.field_5974.method_43048(5 + level * 10) + 3 * level;
            if (registryEntry.method_40220(class_9636.field_51546)) {
                l *= 2;
            }
            if (l > 64) {
                l = 64;
            }
        } else {
            l = 1;
            itemStack = new class_1799((class_1935)class_1802.field_8529);
        }
        return new EnchantedBookFactory(itemStack, l, 30);
    }

    @Unique
    private EnchantedBookFactory anyBook() {
        int l;
        class_1799 itemStack;
        class_5819 rn = this.method_37908().field_9229;
        class_1646 villagerEntity = (class_1646)this;
        Optional optional = villagerEntity.method_37908().method_30349().method_30530(class_7924.field_41265).method_56159(ModTags.ANY_TRADES, this.field_5974);
        if (optional.isPresent()) {
            class_6880 registryEntry = (class_6880)optional.get();
            class_1887 enchantment = (class_1887)registryEntry.comp_349();
            int maxLevel = enchantment.method_8183();
            int level = maxLevel == 1 ? 1 : rn.method_43048(maxLevel) + 1;
            itemStack = class_1890.method_61711((class_1889)new class_1889(registryEntry, level));
            l = 2 + this.field_5974.method_43048(5 + level * 10) + 3 * level;
            if (registryEntry.method_40220(class_9636.field_51546)) {
                l *= 2;
            }
            if (l > 64) {
                l = 64;
            }
        } else {
            l = 1;
            itemStack = new class_1799((class_1935)class_1802.field_8529);
        }
        return new EnchantedBookFactory(itemStack, l, 10);
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/MerchantEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void dropArmor(class_1282 damageSource, CallbackInfo ci) {
        class_1646 villagerEntity = (class_1646)this;
        class_1937 class_19372 = villagerEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_1799 itemStack : FixedMinecraft.getArmor((class_1309)villagerEntity)) {
                villagerEntity.method_5775(serverWorld, itemStack);
            }
            for (int i = 0; i < 4; ++i) {
                villagerEntity.method_5673(this.EQUIPMENT_SLOT_ORDER[i], class_1799.field_8037);
                ++i;
            }
        }
    }
}

