/*
 * Decompiled with CFR 0.152.
 */
package net.greenjab.fixedminecraft.registry.item.map_book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.greenjab.fixedminecraft.network.MapBookPlayer;
import net.greenjab.fixedminecraft.network.MapBookSyncPayload;
import net.greenjab.fixedminecraft.registry.item.map_book.MapBookStateManager;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class MapBookState
extends class_18 {
    public ArrayList<MapBookPlayer> players = new ArrayList();
    public ArrayList<Integer> mapIDs = new ArrayList();
    public MapBookPlayer marker = new MapBookPlayer();
    public static final Codec<MapBookState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().optionalFieldOf("mapIDs", List.of()).forGetter(mapState -> List.copyOf(mapState.mapIDs)), (App)MapBookPlayer.CODEC.listOf().optionalFieldOf("players", List.of()).forGetter(mapState -> List.copyOf(mapState.players)), (App)MapBookPlayer.CODEC.optionalFieldOf("marker").forGetter(mapState -> Optional.ofNullable(mapState.marker))).apply((Applicative)instance, MapBookState::new));

    public static class_10741<MapBookState> createStateType(String mapId) {
        return new class_10741(mapId, () -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, CODEC, class_4284.field_45079);
    }

    public MapBookState(List<Integer> maps, List<MapBookPlayer> mapBookPlayers, Optional<MapBookPlayer> marker) {
        this(new ArrayList<Integer>(maps), new ArrayList<MapBookPlayer>(mapBookPlayers), marker.orElse(new MapBookPlayer()));
    }

    void addPlayer(class_1657 player) {
        MapBookPlayer p = new MapBookPlayer();
        p.setPlayer(player);
        this.players.add(p);
    }

    public MapBookState() {
    }

    public MapBookState(ArrayList<Integer> ids, ArrayList<MapBookPlayer> players, MapBookPlayer marker) {
        this.mapIDs.clear();
        this.mapIDs.addAll(ids);
        this.players.clear();
        this.players.addAll(players);
        this.marker = marker;
        this.method_80();
    }

    public void sendData(MinecraftServer server, int id) {
        for (MapBookPlayer player : this.players) {
            class_3222 SPE = server.method_3760().method_14566(player.name);
            if (SPE == null) continue;
            MapBookSyncPayload payload = new MapBookSyncPayload(id, this.mapIDs.stream().mapToInt(i -> i).toArray(), (ArrayList)this.players.clone(), this.marker);
            ServerPlayNetworking.send((class_3222)SPE, (class_8710)payload);
        }
        MapBookStateManager.INSTANCE.getMapBookState((MinecraftServer)server, (int)id).players.clear();
    }

    public void addMapID(int id) {
        this.mapIDs.add(id);
        this.method_80();
    }

    boolean removeMapID(int id) {
        boolean hasRemoved = false;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        for (int i : this.mapIDs) {
            if (i == id) {
                hasRemoved = true;
                continue;
            }
            temp.add(i);
        }
        this.mapIDs.clear();
        this.mapIDs.addAll(temp);
        this.method_80();
        return hasRemoved;
    }

    void update() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        for (int i : this.mapIDs) {
            if (temp.contains(i)) continue;
            temp.add(i);
        }
        this.mapIDs.clear();
        this.mapIDs.addAll(temp);
        this.method_80();
    }

    public void setMarker(double x, double z, String dimension) {
        this.marker = new MapBookPlayer();
        this.marker.name = "MBPmarker";
        this.marker.x = x;
        this.marker.z = z;
        this.marker.dimension = dimension;
    }
}

