/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.block;

import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.inventories.slots.ShadowSlot;
import de.dafuqs.spectrum.networking.c2s_payloads.SetShadowSlotPayload;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_5536;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilterConfigurable {
    public List<ItemVariant> getItemFilters();

    public void setFilterItem(int var1, ItemVariant var2);

    default public int getFilterRows() {
        return 1;
    }

    default public int getSlotsPerRow() {
        return 5;
    }

    default public int getDrawnSlots() {
        return this.getItemFilters().size();
    }

    public static void writeFilterNbt(class_2487 tag, List<ItemVariant> filterItems) {
        for (int i = 0; i < filterItems.size(); ++i) {
            if (filterItems.get(i).isBlank()) continue;
            CodecHelper.writeNbt(tag, "FilterStack" + i, ItemVariant.CODEC, filterItems.get(i));
        }
    }

    public static void readFilterNbt(class_2487 tag, List<ItemVariant> filterItems) {
        for (int i = 0; i < filterItems.size(); ++i) {
            if (!tag.method_10545("FilterStack" + i)) continue;
            filterItems.set(i, CodecHelper.fromNbt(ItemVariant.CODEC, tag.method_10580("FilterStack" + i), null));
        }
    }

    public static class_1263 getFilterInventoryFromDataClicker(ExtendedData data, ShadowSlotClicker clicker) {
        int size = data.filterItems().size();
        FilterInventory inventory = new FilterInventory(clicker, size);
        for (int i = 0; i < size; ++i) {
            inventory.method_5447(i, data.filterItems().get(i).toStack());
        }
        return inventory;
    }

    public static class_1263 getFilterInventoryFromExtendedData(int syncId, @NotNull class_1661 playerInventory, ExtendedData data, @NotNull class_1703 handler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(handler, playerInventory.field_7546, syncId);
        return FilterConfigurable.getFilterInventoryFromDataClicker(data, clicker);
    }

    public static class_1263 getFilterInventoryFromItemsClicker(List<ItemVariant> items, ShadowSlotClicker clicker) {
        FilterInventory inventory = new FilterInventory(clicker, items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.method_5447(i, items.get(i).toStack());
        }
        return inventory;
    }

    public static class_1263 getFilterInventoryFromItemsHandler(int syncId, @NotNull class_1661 playerInventory, List<ItemVariant> items, @NotNull class_1703 thisHandler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(thisHandler, playerInventory.field_7546, syncId);
        return FilterConfigurable.getFilterInventoryFromItemsClicker(items, clicker);
    }

    public static void writeScreenOpeningData(class_9129 buf, FilterConfigurable configurable) {
        FilterConfigurable.writeScreenOpeningData(buf, configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots());
    }

    public static void writeScreenOpeningData(class_9129 buf, List<ItemVariant> filterItems, int rows, int slotsPerRow, int drawnSlots) {
        buf.method_53002(filterItems.size());
        for (ItemVariant filterItem : filterItems) {
            class_1799.field_48349.encode((Object)buf, (Object)filterItem.toStack());
        }
        buf.method_53002(rows);
        buf.method_53002(slotsPerRow);
        buf.method_53002(drawnSlots);
    }

    default public boolean hasEmptyFilter() {
        return this.getItemFilters().stream().allMatch(TransferVariant::isBlank);
    }

    public record ExtendedData(List<ItemVariant> filterItems, int rows, int slotsPerRow, int drawnSlots) {
        public static final class_9139<class_9129, ExtendedData> PACKET_CODEC = class_9139.method_56905((class_9139)ItemVariant.PACKET_CODEC.method_56433(class_9135.method_56363()), ExtendedData::filterItems, (class_9139)class_9135.field_48550, ExtendedData::rows, (class_9139)class_9135.field_48550, ExtendedData::slotsPerRow, (class_9139)class_9135.field_48550, ExtendedData::drawnSlots, ExtendedData::new);

        public ExtendedData(FilterConfigurable configurable) {
            this(configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots());
        }
    }

    public static class FilterInventory
    extends class_1277 {
        @NotNull
        private final ShadowSlotClicker clicker;

        public FilterInventory(@NotNull ShadowSlotClicker slotClicker, int size) {
            super(size);
            this.clicker = slotClicker;
        }

        @NotNull
        public ShadowSlotClicker getClicker() {
            return this.clicker;
        }
    }

    public static interface ShadowSlotClicker {
        default public void clickShadowSlot(int syncId, class_1735 slot, class_1799 shadowStack) {
            this.clickShadowSlot(syncId, slot.field_7874, shadowStack);
        }

        public void clickShadowSlot(int var1, int var2, class_1799 var3);

        public static class FromHandler
        implements ShadowSlotClicker {
            @NotNull
            public final class_1703 handler;
            @NotNull
            public final class_1657 player;
            public final int syncId;

            public FromHandler(@NotNull class_1703 screenHandler, @NotNull class_1657 player, int syncId) {
                this.handler = screenHandler;
                this.player = player;
                this.syncId = syncId;
            }

            @Override
            public void clickShadowSlot(int syncId, @Nullable class_1735 slot, class_1799 shadowStack) {
                if (this.syncId != syncId || !(slot instanceof ShadowSlot)) {
                    return;
                }
                ShadowSlot shadowSlot = (ShadowSlot)slot;
                if (!shadowSlot.onClicked(shadowStack, class_5536.field_27013, this.player)) {
                    return;
                }
                if (this.player.method_37908().method_8608()) {
                    ClientPlayNetworking.send((class_8710)new SetShadowSlotPayload(syncId, slot.field_7874, shadowStack));
                }
            }

            @Override
            public void clickShadowSlot(int syncId, int id, class_1799 shadowStack) {
                this.clickShadowSlot(syncId, this.handler.method_7611(id), shadowStack);
            }
        }
    }

    public record ExtendedDataWithPos(class_2338 pos, ExtendedData data) {
        public static final class_9139<class_9129, ExtendedDataWithPos> PACKET_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, c -> c.pos, ExtendedData.PACKET_CODEC, c -> c.data, ExtendedDataWithPos::new);

        public ExtendedDataWithPos(class_2338 pos, FilterConfigurable configurable) {
            this(pos, new ExtendedData(configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots()));
        }
    }
}

