/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.storage;

import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class IndividualCappedInkStorage
implements InkStorage {
    protected final long maxEnergyPerColor;
    protected Map<InkColor, Long> storedEnergy = new Object2LongArrayMap();
    protected long currentTotal;

    public IndividualCappedInkStorage(long maxEnergyPerColor) {
        this(maxEnergyPerColor, (Iterable<InkColor>)((Object)SpectrumRegistries.INK_COLOR));
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Iterable<InkColor> supportedColors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.currentTotal = 0L;
        for (InkColor color : supportedColors) {
            this.storedEnergy.put(color, 0L);
        }
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Map<InkColor, Long> colors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.storedEnergy.putAll(colors);
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            this.storedEnergy.put(color.getKey(), color.getValue());
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedEnergy.containsKey(color);
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long resultingAmount = this.storedEnergy.get(color) + amount;
        if (resultingAmount > this.maxEnergyPerColor) {
            long overflow = resultingAmount - this.maxEnergyPerColor;
            this.currentTotal = this.maxEnergyPerColor;
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            return overflow;
        }
        this.currentTotal += amount;
        this.storedEnergy.put(color, resultingAmount);
        return 0L;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.getOrDefault(color, 0L);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyPerColor * (long)this.storedEnergy.size();
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyPerColor;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.getMaxTotal();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ink_storage.stores_ink_per_type", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyPerColor)}));
        Iterator iterator = SpectrumRegistries.INK_COLOR.iterator();
        while (iterator.hasNext()) {
            InkColor color = (InkColor)iterator.next();
            long amount = this.storedEnergy.getOrDefault(color, 0L);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyPerColor - this.storedEnergy.get(color);
    }

    @Override
    public void fillCompletely() {
        this.currentTotal = 0L;
        for (InkColor color : this.storedEnergy.keySet()) {
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            this.currentTotal += this.maxEnergyPerColor;
        }
    }

    @Override
    public void method_5448() {
        Set<InkColor> supportedColors = this.storedEnergy.keySet();
        HashMap<InkColor, Long> newContent = new HashMap<InkColor, Long>();
        for (InkColor color : supportedColors) {
            newContent.put(color, 0L);
        }
        this.storedEnergy = newContent;
        this.currentTotal = 0L;
    }

    public Set<InkColor> getSupportedColors() {
        return this.storedEnergy.keySet();
    }
}

