/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.storage;

import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class TotalCappedInkStorage
implements InkStorage {
    protected final long maxEnergyTotal;
    protected Map<InkColor, Long> storedEnergy = new Object2LongArrayMap();
    protected long currentTotal;

    public TotalCappedInkStorage(long maxEnergyTotal, Map<InkColor, Long> energy) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.currentTotal = 0L;
        this.storedEnergy.putAll(energy);
        for (Map.Entry<InkColor, Long> color : energy.entrySet()) {
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Override
    public boolean accepts(InkColor color) {
        return true;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long overflow = Math.max(0L, amount + this.currentTotal - this.maxEnergyTotal);
        long amountToAdd = amount - overflow;
        this.currentTotal += amountToAdd;
        this.storedEnergy.put(color, this.storedEnergy.getOrDefault(color, 0L) + amountToAdd);
        return overflow;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.getOrDefault(color, 0L);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.maxEnergyTotal;
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyTotal - this.currentTotal;
    }

    @Override
    public void fillCompletely() {
        this.storedEnergy.clear();
        int inkColorCount = SpectrumRegistries.INK_COLOR.method_10204();
        long energyPerColor = this.maxEnergyTotal / (long)inkColorCount;
        for (InkColor color : InkColors.all()) {
            this.storedEnergy.put(color, energyPerColor);
        }
        this.currentTotal = energyPerColor * (long)inkColorCount;
    }

    @Override
    public void method_5448() {
        Set<InkColor> supportedColors = this.storedEnergy.keySet();
        HashMap<InkColor, Long> newContent = new HashMap<InkColor, Long>();
        for (InkColor color : supportedColors) {
            newContent.put(color, 0L);
        }
        this.storedEnergy = newContent;
        this.currentTotal = 0L;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.total_capped_simple_pigment_energy_storage.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyTotal)}));
        this.addInkContentTooltip(tooltip);
    }

    protected void addInkContentTooltip(List<class_2561> tooltip) {
        Iterator iterator = SpectrumRegistries.INK_COLOR.iterator();
        while (iterator.hasNext()) {
            InkColor color = (InkColor)iterator.next();
            long amount = this.storedEnergy.getOrDefault(color, 0L);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
    }
}

