/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.interaction;

import de.dafuqs.spectrum.entity.entity.ItemProjectileEntity;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public interface OmniAcceleratorProjectile {
    public static final List<class_3545<class_2073, OmniAcceleratorProjectile>> PROJECTILES = new ArrayList<class_3545<class_2073, OmniAcceleratorProjectile>>();
    public static final OmniAcceleratorProjectile DEFAULT = (stack, shooter, world, shotFrom) -> {
        ItemProjectileEntity itemProjectileEntity = new ItemProjectileEntity(world, shooter);
        itemProjectileEntity.method_16940(stack);
        itemProjectileEntity.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, 2.5f, 0.5f);
        world.method_8649((class_1297)itemProjectileEntity);
        return itemProjectileEntity;
    };

    public static void register(OmniAcceleratorProjectile behavior, class_2073 predicate) {
        PROJECTILES.add((class_3545<class_2073, OmniAcceleratorProjectile>)new class_3545((Object)predicate, (Object)behavior));
    }

    public static void register(OmniAcceleratorProjectile behavior, class_1935 ... items) {
        PROJECTILES.add((class_3545<class_2073, OmniAcceleratorProjectile>)new class_3545((Object)class_2073.class_2074.method_8973().method_8977(items).method_8976(), (Object)behavior));
    }

    public static void register(OmniAcceleratorProjectile behavior, class_6862<class_1792> tag) {
        PROJECTILES.add((class_3545<class_2073, OmniAcceleratorProjectile>)new class_3545((Object)class_2073.class_2074.method_8973().method_8975(tag).method_8976(), (Object)behavior));
    }

    public static OmniAcceleratorProjectile get(class_1799 stack) {
        for (class_3545<class_2073, OmniAcceleratorProjectile> entry : PROJECTILES) {
            if (!((class_2073)entry.method_15442()).method_8970(stack)) continue;
            return (OmniAcceleratorProjectile)entry.method_15441();
        }
        return DEFAULT;
    }

    @Nullable
    public class_1297 createProjectile(class_1799 var1, class_1309 var2, class_1937 var3, class_1799 var4);

    default public class_3414 getSoundEffect() {
        return SpectrumSoundEvents.OMNI_ACCELERATOR_SHOOT;
    }

    public static void setVelocity(class_1297 projectile, double x, double y, double z, float speed, float divergence) {
        class_243 vec3d = new class_243(x, y, z).method_1029().method_1031(projectile.method_37908().method_8409().method_43385(0.0, 0.0172275 * (double)divergence), projectile.method_37908().method_8409().method_43385(0.0, 0.0172275 * (double)divergence), projectile.method_37908().method_8409().method_43385(0.0, 0.0172275 * (double)divergence)).method_1021((double)speed);
        projectile.method_18799(vec3d);
        double d = vec3d.method_37267();
        projectile.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
        projectile.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 57.2957763671875));
        projectile.field_5982 = projectile.method_36454();
        projectile.field_6004 = projectile.method_36455();
    }

    public static void setVelocity(class_1297 projectile, class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        OmniAcceleratorProjectile.setVelocity(projectile, f, g, h, speed, divergence);
        class_243 vec3d = shooter.method_18798();
        projectile.method_18799(projectile.method_18798().method_1031(vec3d.field_1352, shooter.method_24828() ? 0.0 : vec3d.field_1351, vec3d.field_1350));
    }
}

