/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public interface FusionShrineRecipeWorldEffect {
    public static final Codec<FusionShrineRecipeWorldEffect> CODEC = Codec.STRING.xmap(FusionShrineRecipeWorldEffect::fromString, effect -> {
        String string;
        if (effect instanceof CommandRecipeWorldEffect) {
            CommandRecipeWorldEffect command = (CommandRecipeWorldEffect)effect;
            string = command.command;
        } else {
            string = String.valueOf(SpectrumRegistries.WORLD_EFFECT.method_10221(effect));
        }
        return string;
    });
    public static final class_9139<ByteBuf, FusionShrineRecipeWorldEffect> PACKET_CODEC = class_9135.field_48554.method_56432(FusionShrineRecipeWorldEffect::fromString, effect -> {
        String string;
        if (effect instanceof CommandRecipeWorldEffect) {
            CommandRecipeWorldEffect command = (CommandRecipeWorldEffect)effect;
            string = command.command;
        } else {
            string = String.valueOf(SpectrumRegistries.WORLD_EFFECT.method_10221(effect));
        }
        return string;
    });
    public static final FusionShrineRecipeWorldEffect NOTHING = FusionShrineRecipeWorldEffect.register("nothing", new SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(class_3218 world, class_2338 pos) {
        }
    });

    public static FusionShrineRecipeWorldEffect register(String id, FusionShrineRecipeWorldEffect effect) {
        class_2378.method_10230(SpectrumRegistries.WORLD_EFFECT, (class_2960)SpectrumCommon.locate(id), (Object)effect);
        return effect;
    }

    public static FusionShrineRecipeWorldEffect fromString(String string) {
        if (string == null || string.isBlank()) {
            return NOTHING;
        }
        if (string.startsWith("/")) {
            return new CommandRecipeWorldEffect(string);
        }
        FusionShrineRecipeWorldEffect effect = (FusionShrineRecipeWorldEffect)SpectrumRegistries.WORLD_EFFECT.method_10223(SpectrumCommon.ofSpectrumDefaulted(string));
        if (effect == null) {
            SpectrumCommon.logError("Unknown fusion shrine world effect '" + string + "'. Will be ignored.");
            return NOTHING;
        }
        return effect;
    }

    public boolean isOneTimeEffect();

    public void trigger(class_3218 var1, class_2338 var2);

    public static class CommandRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect,
    class_2165 {
        protected final String command;

        public CommandRecipeWorldEffect(String command) {
            this.command = command;
        }

        public static CommandRecipeWorldEffect fromJson(JsonObject json) {
            return new CommandRecipeWorldEffect(json.getAsString());
        }

        @Override
        public boolean isOneTimeEffect() {
            return false;
        }

        @Override
        public void trigger(class_3218 world, class_2338 pos) {
            MinecraftServer minecraftServer = world.method_8503();
            class_2168 serverCommandSource = new class_2168((class_2165)this, class_243.method_24953((class_2382)pos), class_241.field_1340, world, 2, "FusionShrine", (class_2561)world.method_8320(pos).method_26204().method_9518(), minecraftServer, null);
            minecraftServer.method_3734().method_44252(serverCommandSource, this.command);
        }

        public void method_43496(class_2561 message) {
        }

        public boolean method_9200() {
            return false;
        }

        public boolean method_9202() {
            return false;
        }

        public boolean method_9201() {
            return false;
        }
    }

    public static abstract class SingleTimeRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect {
        @Override
        public boolean isOneTimeEffect() {
            return true;
        }
    }

    public static abstract class EveryTickRecipeWorldEffect
    implements FusionShrineRecipeWorldEffect {
        @Override
        public boolean isOneTimeEffect() {
            return false;
        }
    }
}

