/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_9062;

public class DeeperDownPortalBlock
extends class_2248 {
    public static final MapCodec<DeeperDownPortalBlock> CODEC = DeeperDownPortalBlock.method_54094(DeeperDownPortalBlock::new);
    private static final class_2960 CREATE_PORTAL_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("midgame/open_deeper_down_portal");
    private static final String CREATE_PORTAL_ADVANCEMENT_CRITERION = "opened_deeper_down_portal";
    public static final class_2746 FACING_UP = class_2741.field_12519;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final class_265 SHAPE_UP = class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DeeperDownPortalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING_UP, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends DeeperDownPortalBlock> method_53969() {
        return CODEC;
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, class_243.method_24953((class_2382)pos), (class_2394)SpectrumParticleTypes.VOID_FOG, 30, new class_243(0.5, 0.0, 0.5), class_243.field_1353);
            if (!this.hasNeighboringPortals(world, pos)) {
                world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.DEEPER_DOWN_PORTAL_OPEN, class_3419.field_15245, 0.75f, 0.75f);
                for (class_1657 nearbyPlayer : world.method_18023((class_5575)class_1299.field_6097, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)16.0, (double)16.0, (double)16.0), class_1309::method_5805)) {
                    Support.grantAdvancementCriterion((class_3222)nearbyPlayer, CREATE_PORTAL_ADVANCEMENT_IDENTIFIER, CREATE_PORTAL_ADVANCEMENT_CRITERION);
                }
            }
        }
    }

    public class_9062 method_55765(class_1799 handStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (handStack.method_31574(SpectrumItems.BEDROCK_DUST)) {
            if (world.field_9236) {
                return class_9062.field_47728;
            }
            class_2680 placedState = class_2246.field_9987.method_9564();
            world.method_8501(pos, placedState);
            world.method_8396(null, pos, placedState.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
            return class_9062.field_47729;
        }
        return class_9062.field_47731;
    }

    private boolean hasNeighboringPortals(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!world.method_8320(pos.method_10093(direction)).method_27852((class_2248)this)) continue;
            return true;
        }
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)FACING_UP) != false ? SHAPE_UP : SHAPE;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING_UP});
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (entity.method_5822(false) && !entity.method_30230()) {
                class_3218 targetWorld;
                entity.method_30229();
                class_5321 currentWorldKey = world.method_27983();
                if (currentWorldKey == class_1937.field_25180) {
                    boolean facingUp = (Boolean)state.method_11654((class_2769)FACING_UP);
                    if (facingUp) {
                        class_2338 portalPos = new class_2338(pos.method_10263(), world.method_31607(), pos.method_10260());
                        if (!world.method_8320(portalPos).method_27852(SpectrumBlocks.DEEPER_DOWN_PORTAL)) {
                            world.method_8501(portalPos, (class_2680)SpectrumBlocks.DEEPER_DOWN_PORTAL.method_9564().method_11657((class_2769)FACING_UP, (Comparable)Boolean.valueOf(false)));
                        }
                        if (entity instanceof class_1657) {
                            this.makeRoomAround(world, portalPos, 4, 2, true, (class_6862<class_2248>)class_3481.field_25807);
                        }
                        class_2338 targetPos = portalPos.method_10086(2);
                        entity.method_5731(new class_5454(serverWorld, class_243.method_24953((class_2382)targetPos), class_243.field_1353, entity.method_36454(), entity.method_36455(), class_5454.field_52245));
                        this.teleportToSafePosition((class_1937)serverWorld, entity, targetPos, 3);
                    } else {
                        class_2338 portalPos = new class_2338(pos.method_10263(), world.method_31607() + world.method_8597().comp_653() - 1, pos.method_10260());
                        if (!world.method_8320(portalPos).method_27852(SpectrumBlocks.DEEPER_DOWN_PORTAL)) {
                            world.method_8501(portalPos, (class_2680)SpectrumBlocks.DEEPER_DOWN_PORTAL.method_9564().method_11657((class_2769)FACING_UP, (Comparable)Boolean.valueOf(true)));
                        }
                        if (entity instanceof class_1657) {
                            this.makeRoomAround(world, portalPos, 4, 2, false, (class_6862<class_2248>)class_3481.field_25807);
                        }
                        class_2338 targetPos = portalPos.method_10087(3);
                        entity.method_5731(new class_5454(serverWorld, class_243.method_24953((class_2382)targetPos), class_243.field_1353, entity.method_36454(), entity.method_36455(), class_5454.field_52245));
                        this.teleportToSafePosition((class_1937)serverWorld, entity, targetPos.method_10074(), 5);
                    }
                    return;
                }
                if (currentWorldKey == class_1937.field_25179 && (targetWorld = serverWorld.method_8503().method_3847(SpectrumDimensions.DIMENSION_KEY)) != null) {
                    class_2338 portalPos = new class_2338(pos.method_10263(), targetWorld.method_31600() - 1, pos.method_10260());
                    if (!targetWorld.method_8320(portalPos).method_27852(SpectrumBlocks.DEEPER_DOWN_PORTAL)) {
                        targetWorld.method_8501(portalPos, (class_2680)SpectrumBlocks.DEEPER_DOWN_PORTAL.method_9564().method_11657((class_2769)FACING_UP, (Comparable)Boolean.valueOf(true)));
                    }
                    if (entity instanceof class_1657) {
                        this.makeRoomAround((class_1937)targetWorld, portalPos, 4, 2, false, SpectrumBlockTags.BASE_STONE_DEEPER_DOWN);
                    }
                    class_2338 targetPos = portalPos.method_10087(3);
                    entity.method_5731(new class_5454(targetWorld, class_243.method_24953((class_2382)targetPos), class_243.field_1353, entity.method_36454(), entity.method_36455(), class_5454.field_52246.then(class_5454.field_52247)));
                    this.teleportToSafePosition((class_1937)targetWorld, entity, targetPos.method_10074(), 5);
                    return;
                }
                targetWorld = serverWorld.method_8503().method_3847(class_1937.field_25179);
                if (targetWorld != null) {
                    class_2338 portalPos = new class_2338(pos.method_10263(), targetWorld.method_31607(), pos.method_10260());
                    if (!targetWorld.method_8320(portalPos).method_27852(SpectrumBlocks.DEEPER_DOWN_PORTAL)) {
                        targetWorld.method_8501(portalPos, (class_2680)SpectrumBlocks.DEEPER_DOWN_PORTAL.method_9564().method_11657((class_2769)FACING_UP, (Comparable)Boolean.valueOf(false)));
                    }
                    this.makeRoomAround((class_1937)targetWorld, portalPos, 4, 2, true, (class_6862<class_2248>)class_3481.field_25806);
                    class_2338 targetPos = portalPos.method_10086(2);
                    entity.method_5731(new class_5454(targetWorld, class_243.method_24953((class_2382)targetPos), class_243.field_1353, entity.method_36454(), entity.method_36455(), class_5454.field_52246.then(class_5454.field_52247)));
                    this.teleportToSafePosition((class_1937)targetWorld, entity, targetPos, 3);
                }
            }
        }
    }

    public void makeRoomAround(class_1937 world, class_2338 blockPos, int height, int maxWidth, boolean pointingUp, class_6862<class_2248> tagToClear) {
        class_2680 state = world.method_8320(blockPos);
        if (state.method_26220((class_1922)world, blockPos).method_1110() && state.method_26220((class_1922)world, blockPos.method_10084()).method_1110()) {
            return;
        }
        for (class_2338 pos : DeeperDownPortalBlock.iterateVerticalCone(blockPos, height, maxWidth, pointingUp)) {
            if (world.method_8321(pos) != null || !(state = world.method_8320(pos)).method_27852(class_2246.field_9987) && !state.method_26164(tagToClear)) continue;
            world.method_8651(pos, true, null);
        }
    }

    public static Iterable<class_2338> iterateVerticalCone(class_2338 center, final int height, final int maxWidth, final boolean pointingUp) {
        final int x = center.method_10263();
        final int y = center.method_10264();
        final int z = center.method_10260();
        return () -> new AbstractIterator<class_2338>(){
            int xOffset = 0;
            int yOffset = 0;
            int zOffset = 0;
            int currentMaxWidth = 0;
            private final class_2338.class_2339 pos = new class_2338.class_2339();

            protected class_2338 computeNext() {
                if (this.yOffset > height) {
                    return (class_2338)this.endOfData();
                }
                this.pos.method_10103(x + this.xOffset, pointingUp ? y + this.yOffset : y - this.yOffset, z + this.zOffset);
                ++this.zOffset;
                if (this.zOffset > this.currentMaxWidth) {
                    this.zOffset = -this.currentMaxWidth;
                    ++this.xOffset;
                    if (this.xOffset > this.currentMaxWidth) {
                        this.xOffset = -this.currentMaxWidth;
                        ++this.yOffset;
                        this.currentMaxWidth = Math.min(this.yOffset, maxWidth);
                    }
                }
                return this.pos;
            }
        };
    }

    public void teleportToSafePosition(class_1937 world, class_1297 entity, class_2338 targetPos, int maxRadius) {
        for (class_2338 bp : class_2338.method_25996((class_2338)targetPos, (int)maxRadius, (int)maxRadius, (int)maxRadius)) {
            entity.method_33574(class_243.method_24955((class_2382)bp));
            if (world.method_8320(bp.method_10074()).method_26220((class_1922)world, bp.method_10074()) != class_259.method_1077() || !world.method_17892(entity) || !(entity.method_23318() < (double)world.method_31600()) || !(entity.method_23318() > (double)world.method_31607())) continue;
            entity.method_5859((double)bp.method_10263() + 0.5, (double)bp.method_10264() + 0.5, (double)bp.method_10260() + 0.5);
            return;
        }
        world.method_8650(targetPos.method_10086(1), false);
        world.method_8650(targetPos, false);
        world.method_8501(targetPos.method_10087(1), class_2246.field_29031.method_9564());
        entity.method_5859((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)FACING_UP)).booleanValue() || random.method_43048(8) == 0) {
            DeeperDownPortalBlock.spawnVoidFogParticle(world, pos, random);
        }
    }

    private static void spawnVoidFogParticle(class_1937 world, class_2338 pos, class_5819 random) {
        double d = (double)pos.method_10263() + random.method_43058();
        double e = (double)pos.method_10264() + 0.3;
        double f = (double)pos.method_10260() + random.method_43058();
        world.method_8406((class_2394)SpectrumParticleTypes.VOID_FOG, d, e, f, 0.0, 0.1, 0.0);
    }
}

