/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.boom;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.FluidLogging;
import de.dafuqs.spectrum.blocks.PlacedItemBlock;
import de.dafuqs.spectrum.blocks.PlacedItemBlockEntity;
import de.dafuqs.spectrum.explosion.ModularExplosionDefinition;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreatConfluxBlock
extends PlacedItemBlock
implements FluidLogging.SpectrumFluidLoggable {
    public static final MapCodec<ThreatConfluxBlock> CODEC = ThreatConfluxBlock.method_54094(ThreatConfluxBlock::new);
    private static final int TICKS_TO_ARM = 50;
    private static final int TICKS_TO_DETONATE = 20;
    public static final class_265 UNARMED_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final class_265 ARMED_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.125, (double)16.0);
    public static final class_2754<ArmedState> ARMED = class_2754.method_11850((String)"armed", ArmedState.class);
    public static final class_2754<FluidLogging.State> LOGGED = FluidLogging.ANY_INCLUDING_NONE;

    public ThreatConfluxBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(ARMED, (Comparable)((Object)ArmedState.NOT_ARMED))).method_11657(LOGGED, (Comparable)((Object)FluidLogging.State.NOT_LOGGED)));
    }

    public MapCodec<? extends ThreatConfluxBlock> method_53969() {
        return CODEC;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && ((ArmedState)((Object)state.method_11654(ARMED))).explodesWhenBroken()) {
            this.explode((class_3218)world, pos);
        }
        return super.method_9576(world, pos, state, player);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (((ArmedState)((Object)state.method_11654(ARMED))).explodesWhenBroken() && stack.method_31574(SpectrumItems.MIDNIGHT_CHIP)) {
            world.method_8501(pos, (class_2680)state.method_11657(ARMED, (Comparable)((Object)ArmedState.NOT_ARMED)));
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, SpectrumSoundEvents.BLOCK_THREAT_CONFLUX_DISARM, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.method_8608()) {
                class_3218 serverWorld = (class_3218)world;
                for (int i = 0; i < 5; ++i) {
                    serverWorld.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + serverWorld.field_9229.method_43058(), (double)pos.method_10264() + serverWorld.field_9229.method_43058(), (double)pos.method_10260() + serverWorld.field_9229.method_43058(), 5, 0.0, 0.0, 0.0, 0.05);
                }
            }
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            return class_9062.method_55644((boolean)world.method_8608());
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public void method_9567(@NotNull class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.method_8608()) {
            world.method_39279(pos, (class_2248)this, 50);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (state.method_11654(ARMED) == ArmedState.ARMED) {
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, SpectrumSoundEvents.BLOCK_THREAT_CONFLUX_PRIME, class_3419.field_15245, 1.0f, 2.0f);
            world.method_8501(pos, (class_2680)state.method_11657(ARMED, (Comparable)((Object)ArmedState.FUSED)));
            world.method_39279(pos, (class_2248)this, 20);
        }
        ((FluidLogging.State)((Object)state.method_11654(LOGGED))).onEntityCollision(state, world, pos, entity);
        super.method_9548(state, world, pos, entity);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return ((ArmedState)((Object)state.method_11654(ARMED))).explodesWhenBroken() ? ARMED_SHAPE : UNARMED_SHAPE;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        ArmedState s = (ArmedState)((Object)state.method_11654(ARMED));
        if (s == ArmedState.NOT_ARMED) {
            world.method_8501(pos, (class_2680)state.method_11657(ARMED, (Comparable)((Object)ArmedState.ARMED)));
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, SpectrumSoundEvents.BLOCK_THREAT_CONFLUX_ARM, class_3419.field_15245, 2.0f, 0.1f + world.method_8409().method_43057() * 0.3f);
        } else if (s == ArmedState.FUSED) {
            this.explode(world, pos);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ARMED, LOGGED});
    }

    public void explode(@NotNull class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof PlacedItemBlockEntity)) {
            return;
        }
        PlacedItemBlockEntity blockEntity = (PlacedItemBlockEntity)class_25862;
        class_1799 stack = blockEntity.getStack();
        class_1657 owner = blockEntity.getOwnerIfOnline();
        world.method_8650(pos, false);
        ModularExplosionDefinition.explode(world, pos, owner, stack);
    }

    public static enum ArmedState implements class_3542
    {
        NOT_ARMED("not_armed", false),
        ARMED("armed", true),
        FUSED("fused", true);

        private final String name;
        private final boolean explodesWhenBroken;

        private ArmedState(String name, boolean explodesWhenBroken) {
            this.name = name;
            this.explodesWhenBroken = explodesWhenBroken;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean explodesWhenBroken() {
            return this.explodesWhenBroken;
        }
    }
}

