/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.bottomless_bundle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.InventoryInsertionAcceptor;
import de.dafuqs.spectrum.api.render.DynamicItemRenderer;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.tooltip.BottomlessBundleTooltipData;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1273;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_2969;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_918;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class BottomlessBundleItem
extends class_1747
implements InventoryInsertionAcceptor {
    private static final long MAX_STORED_AMOUNT_BASE = 20000L;

    public BottomlessBundleItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings.method_57349(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)BottomlessStack.DEFAULT));
    }

    public static long getMaxStoredAmount(int powerLevel) {
        return 20000L * (long)((int)Math.pow(10.0, Math.min(5, powerLevel)));
    }

    private static boolean dropOneBundledStack(class_1799 stack, class_1657 player) {
        BottomlessStack.Builder builder = BottomlessStack.Builder.of(player.method_37908(), stack);
        class_1799 dropped = builder.removeFirstStack();
        if (dropped.method_7960()) {
            return false;
        }
        player.method_7328(dropped, true);
        builder.buildAndSet(stack);
        return true;
    }

    public static boolean isLocked(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_49625);
    }

    public static ItemVariant getTemplateVariant(class_1799 stack) {
        return ((BottomlessStack)stack.method_57825(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)BottomlessStack.DEFAULT)).variant();
    }

    public static long getStoredAmount(class_1799 voidBundleStack) {
        return ((BottomlessStack)voidBundleStack.method_57825(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)BottomlessStack.DEFAULT)).count();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (user.method_5715()) {
            class_1799 handStack = user.method_5998(hand);
            if (handStack.method_57826(class_9334.field_49625)) {
                handStack.method_57381(class_9334.field_49625);
                if (world.field_9236) {
                    this.playZipSound((class_1297)user, 0.8f);
                }
            } else {
                handStack.method_57379(class_9334.field_49625, (Object)class_1273.field_5817);
                if (world.field_9236) {
                    this.playZipSound((class_1297)user, 1.0f);
                }
            }
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        if (BottomlessBundleItem.dropOneBundledStack(itemStack, user)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        return class_1269.field_5811;
    }

    public boolean method_31568() {
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 bundleStack) {
        ItemVariant variant = BottomlessBundleItem.getTemplateVariant(bundleStack);
        long storedAmount = BottomlessBundleItem.getStoredAmount(bundleStack);
        return Optional.of(new BottomlessBundleTooltipData(variant, storedAmount));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        boolean locked = BottomlessBundleItem.isLocked(stack);
        long storedAmount = BottomlessBundleItem.getStoredAmount(stack);
        if (storedAmount == 0L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.bottomless_bundle.tooltip.empty").method_27692(class_124.field_1080));
            if (locked) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.bottomless_bundle.tooltip.locked").method_27692(class_124.field_1080));
            }
        } else {
            ItemVariant variant = BottomlessBundleItem.getTemplateVariant(stack);
            Integer powerLevel = context.method_59527().method_46759(class_7924.field_41265).flatMap(impl -> impl.method_46746(class_1893.field_9103)).map(ench -> class_1890.method_8225((class_6880)ench, (class_1799)stack)).orElse(0);
            String totalStacks = Support.getShortenedNumberString((float)storedAmount / (float)variant.getItem().method_7882());
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.bottomless_bundle.tooltip.count", (Object[])new Object[]{storedAmount, BottomlessBundleItem.getMaxStoredAmount(powerLevel), totalStacks}).method_27692(class_124.field_1080));
            if (locked) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.bottomless_bundle.tooltip.locked").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.bottomless_bundle.tooltip.enter_inventory", (Object[])new Object[]{variant.getItem().method_7848().getString()}).method_27692(class_124.field_1080));
            }
        }
        if (class_1890.method_60138((class_1799)stack, SpectrumEnchantmentTags.DELETES_OVERFLOW)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.bottomless_bundle.tooltip.voiding"));
        }
    }

    public void method_33261(class_1542 entity) {
        BottomlessStack bottomlessStack = (BottomlessStack)entity.method_6983().method_57824(SpectrumDataComponentTypes.BOTTOMLESS_STACK);
        if (bottomlessStack != null) {
            entity.method_6983().method_57379(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)BottomlessStack.DEFAULT);
            class_5328.method_33263((class_1542)entity, bottomlessStack.iterateCopy());
        }
    }

    public boolean method_31565(class_1799 bundleStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        long added;
        if (bundleStack.method_7947() != 1 || clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 slotStack = slot.method_7677();
        BottomlessStack.Builder builder = BottomlessStack.Builder.of(player.method_37908(), bundleStack);
        if (slotStack.method_7960()) {
            class_1799 removed = builder.removeFirstStack();
            if (!removed.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                class_1799 remainder = slot.method_32756(removed);
                builder.add(remainder);
            }
        } else if (slotStack.method_7909().method_31568() && (added = builder.add(slot, player)) > 0L) {
            this.playInsertSound((class_1297)player);
        }
        builder.buildAndSet(bundleStack);
        return true;
    }

    public boolean method_31566(class_1799 bundleStack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (bundleStack.method_7947() != 1 || clickType != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        BottomlessStack.Builder builder = BottomlessStack.Builder.of(player.method_37908(), bundleStack);
        if (otherStack.method_7960()) {
            class_1799 removed = builder.removeFirstStack();
            if (!removed.method_7960()) {
                this.playRemoveOneSound((class_1297)player);
                cursorStackReference.method_32332(removed);
            }
        } else {
            int added = builder.add(otherStack);
            if (added > 0) {
                otherStack.method_7934(added);
                this.playInsertSound((class_1297)player);
            }
        }
        builder.buildAndSet(bundleStack);
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        BottomlessStack.Builder builder = BottomlessStack.Builder.of(world, stack);
        ItemVariant bundledVariant = builder.getVariant();
        class_1799 bundledStack = builder.getVariant().toStack((int)Math.min(Integer.MAX_VALUE, builder.count));
        long count = bundledStack.method_7947();
        bundledStack.method_7917(world, entity, slot, selected);
        if (!bundledVariant.matches(bundledStack) || (long)bundledStack.method_7947() != count) {
            builder.set(bundledStack, Math.min((long)builder.getMaxAllowed(bundledStack), builder.count + (long)bundledStack.method_7947() - count));
            builder.buildAndSet(stack);
        }
    }

    @Override
    public boolean acceptsItemStack(class_1799 inventoryInsertionAcceptorStack, class_1799 itemStackToAccept) {
        ItemVariant variant = BottomlessBundleItem.getTemplateVariant(inventoryInsertionAcceptorStack);
        return !variant.isBlank() && variant.matches(itemStackToAccept);
    }

    @Override
    public int acceptItemStack(class_1799 inventoryInsertionAcceptorStack, class_1799 itemStackToAccept, class_1657 playerEntity) {
        if (BottomlessBundleItem.isLocked(inventoryInsertionAcceptorStack)) {
            return itemStackToAccept.method_7947();
        }
        BottomlessStack.Builder builder = BottomlessStack.Builder.of(playerEntity.method_37908(), inventoryInsertionAcceptorStack);
        int added = builder.add(itemStackToAccept);
        builder.buildAndSet(inventoryInsertionAcceptorStack);
        return itemStackToAccept.method_7947() - added;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playZipSound(class_1297 entity, float basePitch) {
        entity.method_5783(SpectrumSoundEvents.BOTTOMLESS_BUNDLE_ZIP, 0.8f, basePitch + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 5;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9103);
    }

    public record BottomlessStack(ItemVariant variant, long count, boolean locked) {
        public static BottomlessStack DEFAULT = new BottomlessStack(class_1799.field_8037, 0L, false);
        public static Codec<BottomlessStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemVariant.CODEC.fieldOf("variant").forGetter(BottomlessStack::variant), (App)Codec.LONG.fieldOf("count").forGetter(BottomlessStack::count), (App)Codec.BOOL.fieldOf("locked").forGetter(BottomlessStack::locked)).apply((Applicative)instance, BottomlessStack::new));
        public static class_9139<class_9129, BottomlessStack> PACKET_CODEC = class_9139.method_56436((class_9139)ItemVariant.PACKET_CODEC, BottomlessStack::variant, (class_9139)class_9135.field_48551, BottomlessStack::count, (class_9139)class_9135.field_48547, BottomlessStack::locked, BottomlessStack::new);

        public BottomlessStack(class_1799 stack, long count, boolean locked) {
            this(ItemVariant.of((class_1799)stack), count, locked);
        }

        public Iterable<class_1799> iterateCopy() {
            return new Iterable<class_1799>(){

                @Override
                @NotNull
                public Iterator<class_1799> iterator() {
                    return new Iterator<class_1799>(){
                        private final Builder builder;
                        {
                            this.builder = new Builder(this, Integer.MAX_VALUE, false, false);
                        }

                        @Override
                        public boolean hasNext() {
                            return !this.builder.isEmpty();
                        }

                        @Override
                        public class_1799 next() {
                            return this.builder.removeFirstStack();
                        }
                    };
                }
            };
        }

        public static class Builder {
            private final boolean voiding;
            private final boolean locked;
            private final long max;
            private long count;
            private ItemVariant variant;

            public static Builder of(class_1937 world, class_1799 stack) {
                BottomlessStack prev = (BottomlessStack)stack.method_57825(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)DEFAULT);
                long max = BottomlessBundleItem.getMaxStoredAmount(SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)world.method_30349(), (class_5321<class_1887>)class_1893.field_9103, stack));
                boolean voiding = class_1890.method_60138((class_1799)stack, SpectrumEnchantmentTags.DELETES_OVERFLOW_IN_INVENTORY);
                boolean locked = stack.method_57826(class_9334.field_49625);
                return new Builder(prev, max, voiding, locked);
            }

            public Builder(BottomlessStack prev, long max, boolean voiding, boolean locked) {
                this.variant = prev.variant();
                this.max = max;
                this.count = prev.count();
                this.voiding = voiding;
                this.locked = locked;
            }

            public Builder clear() {
                this.variant = ItemVariant.blank();
                this.count = 0L;
                return this;
            }

            public int getMaxAllowed(class_1799 stack) {
                if (this.count > 0L && !this.variant.matches(stack)) {
                    return 0;
                }
                ItemVariant stackVariant = ItemVariant.of((class_1799)stack);
                long result = this.isEmpty() ? this.max : (stackVariant.isBlank() || (long)stack.method_7947() <= 0L || !stackVariant.getItem().method_31568() ? 0L : (this.voiding ? Long.MAX_VALUE : this.max - this.count));
                return (int)Math.min(result, Integer.MAX_VALUE);
            }

            public int add(class_1799 stack) {
                int toAdd = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
                if (toAdd == 0) {
                    return 0;
                }
                if (this.count == 0L) {
                    this.variant = ItemVariant.of((class_1799)stack);
                }
                this.count += Math.min(this.max - this.count, (long)toAdd);
                return toAdd;
            }

            public void setStack(class_1799 stack) {
                this.variant = ItemVariant.of((class_1799)stack);
            }

            public void set(SingleVariantStorage<ItemVariant> storage) {
                this.variant = (ItemVariant)storage.variant;
                this.count = storage.amount;
            }

            public void set(class_1799 stack, long count) {
                if (stack.method_7960() || count == 0L) {
                    this.variant = ItemVariant.blank();
                    this.count = 0L;
                } else {
                    this.variant = ItemVariant.of((class_1799)stack);
                    this.count = count;
                }
            }

            public long add(class_1735 slot, class_1657 player) {
                int maxAllowed = this.getMaxAllowed(slot.method_7677());
                return this.add(slot.method_32753(slot.method_7677().method_7947(), maxAllowed, player));
            }

            public class_1799 remove(int amount) {
                if (this.isEmpty()) {
                    return class_1799.field_8037;
                }
                int toRemove = Math.min((int)this.count, amount);
                class_1799 removed = this.variant.toStack(toRemove);
                this.count -= (long)toRemove;
                if (this.count == 0L) {
                    this.variant = ItemVariant.blank();
                }
                return removed;
            }

            public class_1799 removeFirstStack() {
                return this.remove(this.variant.getItem().method_7882());
            }

            public long getCount() {
                return this.count;
            }

            public ItemVariant getVariant() {
                return this.variant;
            }

            public boolean isEmpty() {
                return this.count == 0L || this.variant.isBlank();
            }

            public void buildAndSet(class_1799 bottomlessBundleStack) {
                if (this.isEmpty()) {
                    bottomlessBundleStack.method_57381(SpectrumDataComponentTypes.BOTTOMLESS_STACK);
                } else {
                    bottomlessBundleStack.method_57379(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)new BottomlessStack(this.variant, this.count, this.locked));
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements DynamicItemRenderer {
        @Override
        public void render(class_918 renderer, class_1799 stack, class_811 mode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model) {
            renderer.method_23179(stack, mode, leftHanded, matrices, vertexConsumers, light, overlay, model);
            if (mode != class_811.field_4317 || BottomlessBundleItem.getStoredAmount(stack) <= 0L) {
                return;
            }
            class_1799 bundledStack = BottomlessBundleItem.getTemplateVariant(stack).toStack();
            class_310 client = class_310.method_1551();
            class_1087 bundledModel = renderer.method_4019(bundledStack, (class_1937)client.field_1687, (class_1309)client.field_1724, 0);
            matrices.method_22903();
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            renderer.method_23179(bundledStack, mode, leftHanded, matrices, vertexConsumers, light, overlay, bundledModel);
            matrices.method_22909();
        }
    }

    public static class BottomlessBundlePlacementDispenserBehavior
    extends class_2969 {
        protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
            this.method_27955(false);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof BottomlessBundleItem) {
                BottomlessBundleItem bottomlessBundleItem = (BottomlessBundleItem)class_17922;
                class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockPos = pointer.comp_1968().method_10093(direction);
                class_2350 direction2 = pointer.comp_1967().method_22347(blockPos.method_10074()) ? direction : class_2350.field_11036;
                try {
                    this.method_27955(bottomlessBundleItem.method_7712((class_1750)new class_2968((class_1937)pointer.comp_1967(), blockPos, direction, stack, direction2)).method_23665());
                }
                catch (Exception e) {
                    SpectrumCommon.logError("Error trying to place bottomless bundle at " + String.valueOf(blockPos) + " : " + String.valueOf(e));
                }
            }
            return stack;
        }
    }
}

