/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.api.block.PlayerOwnedWithName;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.inventories.GenericSpectrumContainerScreenHandler;
import de.dafuqs.spectrum.inventories.ScreenBackgroundVariant;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class HeartboundChestBlockEntity
extends SpectrumChestBlockEntity
implements class_1278,
PlayerOwnedWithName {
    private UUID ownerUUID;
    private String ownerName;
    private long lastNonOwnerOpenedTick = -1L;

    public HeartboundChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.HEARTBOUND_CHEST, blockPos, blockState);
    }

    public static int getPlayersLookingInChestCount(class_1922 world, class_2338 pos) {
        class_2586 blockEntity;
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_31709() && (blockEntity = world.method_8321(pos)) instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            return heartboundChestBlockEntity.stateManager.method_31678();
        }
        return 0;
    }

    @Override
    protected void onInvOpenOrClose(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        super.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        if (oldViewerCount != newViewerCount) {
            this.updateRedstone(pos, state);
        }
    }

    public void updateRedstone(class_2338 pos, class_2680 state) {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8452(pos, state.method_26204());
        this.field_11863.method_8452(pos.method_10074(), state.method_26204());
        if (this.wasRecentlyTriedToOpenByNonOwner()) {
            this.field_11863.method_39279(pos, state.method_26204(), 10);
        }
    }

    protected class_2561 method_17823() {
        if (this.hasOwner()) {
            return class_2561.method_43469((String)"block.spectrum.heartbound_chest.owner", (Object[])new Object[]{this.ownerName});
        }
        return class_2561.method_43471((String)"block.spectrum.heartbound_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return GenericSpectrumContainerScreenHandler.createGeneric9x6(syncId, playerInventory, (class_1263)this, ScreenBackgroundVariant.EARLYGAME);
    }

    public int method_5439() {
        return 54;
    }

    @Override
    public void onScheduledTick() {
        super.onScheduledTick();
        if (this.field_11863 != null) {
            this.updateRedstone(this.method_11016(), this.field_11863.method_8320(this.field_11867));
        }
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11014(tag, registryLookup);
        this.ownerUUID = tag.method_10545("OwnerUUID") ? tag.method_25926("OwnerUUID") : null;
        this.ownerName = tag.method_10545("OwnerName") ? tag.method_10558("OwnerName") : "???";
        this.lastNonOwnerOpenedTick = tag.method_10545("LastNonOwnerOpenedTick") ? tag.method_10537("LastNonOwnerOpenedTick") : -1L;
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11007(tag, registryLookup);
        if (this.ownerUUID != null) {
            tag.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            tag.method_10582("OwnerName", this.ownerName);
        }
        tag.method_10544("LastNonOwnerOpenedTick", this.lastNonOwnerOpenedTick);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.ownerName = playerEntity.method_5477().getString();
        this.method_5431();
    }

    public boolean method_17489(class_1657 player) {
        boolean isOwner = this.getOwnerUUID().equals(player.method_5667());
        if (!isOwner && this.method_10997() != null) {
            this.lastNonOwnerOpenedTick = this.method_10997().method_8510();
            this.updateRedstone(this.field_11867, this.method_10997().method_8320(this.field_11867));
            player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.heartbound_chest.owner", (Object[])new Object[]{this.ownerName}), true);
        }
        return isOwner;
    }

    public boolean wasRecentlyTriedToOpenByNonOwner() {
        if (this.method_10997() != null) {
            return this.lastNonOwnerOpenedTick > 0L && this.lastNonOwnerOpenedTick + 20L > this.method_10997().method_8510();
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public boolean canBreak(UUID uuid) {
        if (this.ownerUUID == null) {
            return true;
        }
        return this.ownerUUID.equals(uuid);
    }
}

