/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.deeper_down;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.Splinterspawn;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1614;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9636;

public class SplinterspawnInfestedBlock
extends class_2248 {
    public static final MapCodec<SplinterspawnInfestedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("host").forGetter(SplinterspawnInfestedBlock::getHostBlock), (App)SplinterspawnInfestedBlock.method_54096()).apply((Applicative)instance, SplinterspawnInfestedBlock::new));
    private final class_2248 hostBlock;
    private static final Map<class_2248, class_2248> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<class_2680, class_2680> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<class_2680, class_2680> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public MapCodec<? extends SplinterspawnInfestedBlock> method_53969() {
        return CODEC;
    }

    public SplinterspawnInfestedBlock(class_2248 hostBlock, class_4970.class_2251 properties) {
        super(properties.method_36557(hostBlock.method_36555() / 2.0f).method_36558(0.75f));
        this.hostBlock = hostBlock;
        BLOCK_BY_HOST_BLOCK.put(hostBlock, this);
    }

    public class_2248 getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(class_2680 state) {
        return state.method_27852(SpectrumBlocks.SHALE_CLAY) || state.method_27852(SpectrumBlocks.PYRITE);
    }

    private void spawnInfestation(class_3218 level, class_2338 pos) {
        Splinterspawn splinterspawn = (Splinterspawn)SpectrumEntityTypes.SPLINTERSPAWN.method_5883((class_1937)level);
        if (splinterspawn != null) {
            splinterspawn.method_5808((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            level.method_8649((class_1297)splinterspawn);
            splinterspawn.method_5990();
        }
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(level, pos, state, player);
        class_2680 newState = state;
        List<class_2350> directions = Arrays.asList(class_2350.values());
        Collections.shuffle(directions);
        for (class_2350 direction : directions) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 offsetState = level.method_8320(offsetPos);
            if (!SplinterspawnInfestedBlock.isCompatibleHostBlock(offsetState)) continue;
            newState = this.getUninfestedState(state);
            class_2680 newOffsetState = SplinterspawnInfestedBlock.getInfestedState(offsetState);
            level.method_8501(offsetPos, newOffsetState);
            level.method_8444(player, 2001, offsetPos, SplinterspawnInfestedBlock.method_9507((class_2680)newOffsetState));
            this.playSound(level, offsetPos, level.field_9229);
            break;
        }
        return newState;
    }

    protected void method_9565(class_2680 state, class_3218 level, class_2338 pos, class_1799 stack, boolean dropExperience) {
        super.method_9565(state, level, pos, stack, dropExperience);
        if (class_1890.method_60138((class_1799)stack, SpectrumEnchantmentTags.RESONANT_BLOCK_DROPS)) {
            return;
        }
        if (class_1890.method_60138((class_1799)stack, SpectrumEnchantmentTags.AUTO_KILLS_SILVERFISH)) {
            class_1614 splinterspawn = (class_1614)SpectrumEntityTypes.SPLINTERSPAWN.method_5883((class_1937)level);
            if (splinterspawn != null) {
                SplinterspawnInfestedBlock.spawnEntityKillAndDropXP(level, pos, dropExperience, splinterspawn);
            }
            return;
        }
        if (level.method_8450().method_8355(class_1928.field_19392) && !class_1890.method_60138((class_1799)stack, (class_6862)class_9636.field_51556)) {
            this.spawnInfestation(level, pos);
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
        for (class_2350 direction : class_2350.values()) {
            class_2338 offsetPos = pos.method_10093(direction);
            if (level.method_8320(offsetPos).method_51367() || random.method_43048(300) != 0) continue;
            this.playSound(level, pos, random);
            break;
        }
    }

    protected void playSound(class_1937 level, class_2338 pos, class_5819 random) {
        level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.ENTITY_SPLINTERSPAWN_AMBIENT, class_3419.field_15256, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
    }

    public static void spawnEntityKillAndDropXP(class_3218 level, class_2338 pos, boolean dropExperience, class_1614 splinterspawn) {
        splinterspawn.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        level.method_8649((class_1297)splinterspawn);
        splinterspawn.method_5990();
        int experienceAmount = Support.getIntFromDecimalWithChance((float)splinterspawn.method_59923(level, null) * SpectrumCommon.CONFIG.PestControlExperienceMultiplier, level.field_9229);
        splinterspawn.method_5768();
        if (dropExperience) {
            class_1303 experienceOrb = new class_1303((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, experienceAmount);
            level.method_8649((class_1297)experienceOrb);
        }
    }

    public static class_2680 getInfestedState(class_2680 notInfested) {
        class_2680 target = HOST_TO_INFESTED_STATES.getOrDefault(notInfested, null);
        if (target == null) {
            class_2248 targetBlock = BLOCK_BY_HOST_BLOCK.get(notInfested.method_26204());
            target = targetBlock.method_34725(notInfested);
            HOST_TO_INFESTED_STATES.put(notInfested, target);
        }
        return target;
    }

    public class_2680 getUninfestedState(class_2680 infested) {
        class_2680 target = INFESTED_TO_HOST_STATES.getOrDefault(infested, null);
        if (target == null) {
            class_2248 targetBlock = ((SplinterspawnInfestedBlock)infested.method_26204()).hostBlock;
            target = targetBlock.method_34725(infested);
            INFESTED_TO_HOST_STATES.put(infested, target);
        }
        return target;
    }
}

