/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.enchanter;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlock;
import de.dafuqs.spectrum.blocks.item_bowl.ItemBowlBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.ExperienceHelper;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.inventories.EnchanterInventory;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithPatternAndVelocityPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.particle.effect.ColoredSparkleRisingParticleEffect;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.CraftingBlockSoundInstance;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter {
    public static final String ITEM_TRANS = "container.spectrum.rei.enchantment_upgrade.required_item_count";
    public static final String LEVEL_TRANS = "container.spectrum.rei.enchantment_upgrade.level";
    public static final String OVERCHANTING_TOOLTIP = "container.spectrum.rei.enchantment_upgrade.tooltip";
    public static final String CYCLING = "container.spectrum.rei.enchantment_upgrade.button";
    public static final List<class_2382> ITEM_BOWL_OFFSETS = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(5, 0, -3));
            this.add(new class_2382(5, 0, 3));
            this.add(new class_2382(3, 0, 5));
            this.add(new class_2382(-3, 0, 5));
            this.add(new class_2382(-5, 0, 3));
            this.add(new class_2382(-5, 0, -3));
            this.add(new class_2382(-3, 0, -5));
            this.add(new class_2382(3, 0, -5));
        }
    };
    public static final int REQUIRED_TICKS_FOR_EACH_EXPERIENCE_POINT = 4;
    public static final int INVENTORY_SIZE = 2;
    protected UUID ownerUUID;
    protected boolean canOwnerApplyConflictingEnchantments;
    protected boolean canOwnerOverenchant;
    protected EnchanterInventory virtualInventory = new EnchanterInventory();
    protected int virtualInventoryRecipeOrientation;
    protected boolean virtualInventoryRecipeMirrored;
    protected boolean inventoryChanged;
    private Upgradeable.UpgradeHolder upgrades;
    @Nullable
    private class_8786<?> currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private int currentItemProcessingTime = -1;
    @Nullable
    private class_2350 itemFacing;

    public EnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.ENCHANTER, pos, state, 2);
    }

    @Override
    public List<class_2382> getUpgradePosOffsets() {
        return EnchanterBlock.UPGRADE_BLOCK_OFFSETS;
    }

    public static void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.currentRecipe != null) {
            class_1799 experienceStack = enchanterBlockEntity.method_5438(1);
            if (!experienceStack.method_7960() && experienceStack.method_7909() instanceof ExperienceStorageItem) {
                int experience = ExperienceStorageItem.getStoredExperience(experienceStack);
                int amount = ExperienceHelper.getExperienceOrbSizeForExperience(experience);
                if (world.field_9229.method_43048(10) < amount) {
                    float randomX = 0.2f + world.method_8409().method_43057() * 0.6f;
                    float randomZ = 0.2f + world.method_8409().method_43057() * 0.6f;
                    float randomY = -0.1f + world.method_8409().method_43057() * 0.4f;
                    world.method_8406((class_2394)ColoredCraftingParticleEffect.LIME, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 2.5 + (double)randomY, (double)((float)blockPos.method_10260() + randomZ), 0.0, -0.1, 0.0);
                }
            }
        } else if (enchanterBlockEntity.currentItemProcessingTime > -1) {
            float randomX = 0.2f + world.method_8409().method_43057() * 0.6f;
            float randomZ = 0.2f + world.method_8409().method_43057() * 0.6f;
            float randomY = -0.2f + world.method_8409().method_43057() * 0.4f;
            world.method_8406((class_2394)ColoredCraftingParticleEffect.LIME, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 2.5 + (double)randomY, (double)((float)blockPos.method_10260() + randomZ), 0.0, -0.1, 0.0);
            if (world.method_8510() % 12L == 0L) {
                world.method_8396(null, enchanterBlockEntity.field_11867, class_3417.field_14627, class_3419.field_15245, 0.8f * SpectrumCommon.CONFIG.BlockSoundVolume, 0.8f + world.field_9229.method_43057() * 0.4f);
                enchanterBlockEntity.doItemBowlOrbs(world);
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.upgrades == null) {
            enchanterBlockEntity.calculateUpgrades();
        }
        if (enchanterBlockEntity.inventoryChanged) {
            EnchanterBlockEntity.calculateCurrentRecipe(world, enchanterBlockEntity);
            if (enchanterBlockEntity.currentRecipe == null) {
                int requiredExperience;
                enchanterBlockEntity.currentItemProcessingTime = EnchanterBlockEntity.isValidCenterEnchantingSetup(enchanterBlockEntity) ? ((requiredExperience = EnchanterBlockEntity.getRequiredExperienceToEnchantCenterItem(enchanterBlockEntity)) > 0 ? requiredExperience * 4 : -1) : -1;
                enchanterBlockEntity.updateInClientWorld();
            }
            enchanterBlockEntity.inventoryChanged = false;
        }
        boolean craftingSuccess = false;
        if (enchanterBlockEntity.currentRecipe != null || enchanterBlockEntity.currentItemProcessingTime > 1) {
            class_1860 recipe;
            if (enchanterBlockEntity.craftingTime % 60 == 1 && !EnchanterBlockEntity.checkRecipeRequirements(world, blockPos, enchanterBlockEntity)) {
                enchanterBlockEntity.craftingTime = 0;
                PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867);
                return;
            }
            if (enchanterBlockEntity.craftingTime == 1) {
                PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.ENCHANTER_WORKING, (class_3218)enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867, Integer.MAX_VALUE);
            }
            class_1860 class_18602 = recipe = enchanterBlockEntity.currentRecipe == null ? null : enchanterBlockEntity.currentRecipe.comp_1933();
            if (recipe instanceof EnchanterRecipe) {
                EnchanterRecipe enchanterRecipe = (EnchanterRecipe)recipe;
                ++enchanterBlockEntity.craftingTime;
                if (enchanterBlockEntity.craftingTime == enchanterBlockEntity.craftingTimeTotal - 20) {
                    enchanterBlockEntity.doItemBowlOrbs(world);
                } else if (enchanterBlockEntity.craftingTime == enchanterBlockEntity.craftingTimeTotal) {
                    EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                    EnchanterBlockEntity.craftEnchanterRecipe(world, enchanterBlockEntity, enchanterRecipe);
                    craftingSuccess = true;
                }
                enchanterBlockEntity.method_5431();
            } else if (recipe instanceof EnchantmentUpgradeRecipe) {
                EnchantmentUpgradeRecipe enchantmentUpgradeRecipe = (EnchantmentUpgradeRecipe)recipe;
                ++enchanterBlockEntity.currentItemProcessingTime;
                if (enchanterBlockEntity.currentItemProcessingTime == 4) {
                    enchanterBlockEntity.currentItemProcessingTime = 0;
                    int consumedItems = EnchanterBlockEntity.tickEnchantmentUpgradeRecipe(world, enchanterBlockEntity, enchanterBlockEntity.craftingTimeTotal - enchanterBlockEntity.craftingTime);
                    if (consumedItems == 0) {
                        enchanterBlockEntity.inventoryChanged();
                    } else {
                        enchanterBlockEntity.craftingTime += consumedItems;
                        if (enchanterBlockEntity.craftingTime >= enchanterBlockEntity.craftingTimeTotal) {
                            EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                            enchanterBlockEntity.craftEnchantmentUpgradeRecipe(enchantmentUpgradeRecipe);
                            PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867);
                            craftingSuccess = true;
                        }
                    }
                }
                enchanterBlockEntity.method_5431();
            } else if (enchanterBlockEntity.currentItemProcessingTime > -1) {
                boolean drained;
                int speedTicks = Support.getIntFromDecimalWithChance(enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED), world.field_9229);
                enchanterBlockEntity.craftingTime += speedTicks;
                if (world.method_8510() % 4L == 0L && !(drained = enchanterBlockEntity.drainExperience(speedTicks))) {
                    enchanterBlockEntity.currentItemProcessingTime = -1;
                    enchanterBlockEntity.updateInClientWorld();
                    PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867);
                }
                if (enchanterBlockEntity.currentItemProcessingTime > 0 && enchanterBlockEntity.craftingTime >= enchanterBlockEntity.currentItemProcessingTime) {
                    EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                    EnchanterBlockEntity.enchantCenterItem(enchanterBlockEntity);
                    enchanterBlockEntity.currentItemProcessingTime = -1;
                    enchanterBlockEntity.craftingTime = 0;
                    enchanterBlockEntity.updateInClientWorld();
                    PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867);
                    craftingSuccess = true;
                }
                enchanterBlockEntity.method_5431();
            }
            if (craftingSuccess) {
                enchanterBlockEntity.currentItemProcessingTime = -1;
                enchanterBlockEntity.craftingTime = 0;
                enchanterBlockEntity.inventoryChanged();
            }
        }
    }

    public static boolean isValidCenterEnchantingSetup(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        class_1799 centerStack = enchanterBlockEntity.virtualInventory.method_5438(0);
        boolean isEnchantableBookInCenter = SpectrumEnchantmentHelper.isEnchantableBook(centerStack);
        boolean centerIsEnchantable = isEnchantableBookInCenter || centerStack.method_7909().method_7870(centerStack);
        boolean hasExpStorage = enchanterBlockEntity.virtualInventory.method_5438(1).method_7909() instanceof ExperienceStorageItem;
        if (!centerStack.method_7960() && centerIsEnchantable && hasExpStorage) {
            boolean centerStackIsGildedBook = centerStack.method_31574(SpectrumItems.GILDED_BOOK);
            boolean enchantedBookWithAdditionalEnchantmentsFound = false;
            Set existingEnchantments = class_1890.method_57532((class_1799)centerStack).method_57539();
            block0: for (int i = 0; i < 8; ++i) {
                class_1799 virtualSlotStack = enchanterBlockEntity.virtualInventory.method_5438(2 + i);
                if (virtualSlotStack.method_7960()) continue;
                if (centerStackIsGildedBook || virtualSlotStack.method_7909() instanceof class_1772) {
                    for (Object2IntMap.Entry entry : class_1890.method_57532((class_1799)virtualSlotStack).method_57539()) {
                        class_6880 enchantment = (class_6880)entry.getKey();
                        boolean isAcceptable = isEnchantableBookInCenter || centerStack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE);
                        boolean isRedundant = existingEnchantments.stream().anyMatch(existing -> existing.getKey() == enchantment && existing.getIntValue() >= entry.getIntValue());
                        if (!isAcceptable || isRedundant) continue;
                        if (enchanterBlockEntity.canOwnerApplyConflictingEnchantments) {
                            enchantedBookWithAdditionalEnchantmentsFound = true;
                            continue block0;
                        }
                        if (!SpectrumEnchantmentHelper.canCombineAny(centerStack, virtualSlotStack)) continue;
                        enchantedBookWithAdditionalEnchantmentsFound = true;
                        continue block0;
                    }
                    continue;
                }
                return false;
            }
            return enchantedBookWithAdditionalEnchantmentsFound;
        }
        return false;
    }

    public static void playCraftingFinishedEffects(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.field_11863 == null) {
            return;
        }
        enchanterBlockEntity.field_11863.method_8396(null, enchanterBlockEntity.field_11867, SpectrumSoundEvents.ENCHANTER_FINISH, class_3419.field_15245, 1.0f, 1.0f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)enchanterBlockEntity.method_10997(), new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 0.5, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5), ColoredSparkleRisingParticleEffect.LIME, 75, new class_243(0.5, 0.5, 0.5), new class_243(0.1, -0.1, 0.1));
    }

    private static boolean checkRecipeRequirements(class_1937 world, class_2338 blockPos, @NotNull EnchanterBlockEntity enchanter) {
        class_1657 lastInteractedPlayer = enchanter.getOwnerIfOnline();
        if (lastInteractedPlayer == null) {
            return false;
        }
        if (enchanter.currentRecipe == null) {
            return EnchanterBlockEntity.isValidCenterEnchantingSetup(enchanter);
        }
        class_1860 recipe = enchanter.currentRecipe.comp_1933();
        boolean playerCanCraft = true;
        if (recipe instanceof EnchanterRecipe) {
            EnchanterRecipe enchanterRecipe = (EnchanterRecipe)recipe;
            playerCanCraft = enchanterRecipe.canPlayerCraft(lastInteractedPlayer);
        } else if (recipe instanceof EnchantmentUpgradeRecipe) {
            EnchantmentUpgradeRecipe upgrade = (EnchantmentUpgradeRecipe)recipe;
            int enchLevel = EnchanterBlockEntity.getLevel(enchanter, upgrade);
            playerCanCraft = upgrade.canPlayerCraft(lastInteractedPlayer) && (enchanter.canOwnerOverenchant || upgrade.isInNormalRange(enchLevel));
        }
        boolean structureComplete = EnchanterBlock.verifyStructure(world, blockPos, null);
        if (!playerCanCraft || !structureComplete) {
            if (!structureComplete) {
                world.method_8396(null, enchanter.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
                world.method_8396(null, enchanter.method_11016(), class_3417.field_15197, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.5f + world.field_9229.method_43057() * 0.2f);
                EnchanterBlock.scatterContents(world, blockPos);
            }
            return false;
        }
        return true;
    }

    private static int getLevel(@NotNull EnchanterBlockEntity enchanter, EnchantmentUpgradeRecipe upgrade) {
        return ((class_9304)enchanter.method_5438(0).method_57824(class_9334.field_49643)).method_57536(upgrade.getEnchantment());
    }

    public static void enchantCenterItem(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        class_1799 centerStack = enchanterBlockEntity.method_5438(0);
        class_1799 centerStackCopy = centerStack.method_7972();
        class_9304 highestEnchantments = EnchanterBlockEntity.getHighestEnchantmentsInItemBowls(enchanterBlockEntity);
        for (Object2IntMap.Entry entry : highestEnchantments.method_57539()) {
            centerStackCopy = (class_1799)SpectrumEnchantmentHelper.addOrUpgradeEnchantment(centerStackCopy, (class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue(), false, enchanterBlockEntity.canOwnerApplyConflictingEnchantments).method_15441();
        }
        int spentExperience = enchanterBlockEntity.currentItemProcessingTime / 4;
        if (centerStack.method_7947() > 1) {
            centerStackCopy.method_7939(1);
            MultiblockCrafter.spawnOutputAsItemEntity(enchanterBlockEntity.method_10997(), enchanterBlockEntity.field_11867, centerStackCopy);
            centerStack.method_7934(1);
        } else {
            enchanterBlockEntity.method_5447(0, centerStackCopy);
        }
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(enchanterBlockEntity.ownerUUID, centerStackCopy, spentExperience);
        class_3222 serverPlayerEntity = (class_3222)enchanterBlockEntity.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.ENCHANTER_ENCHANTING.trigger(serverPlayerEntity, centerStackCopy, spentExperience);
        }
    }

    public static class_9304 getHighestEnchantmentsInItemBowls(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        return SpectrumEnchantmentHelper.collectHighestEnchantments(enchanterBlockEntity.virtualInventory.field_5828.subList(2, 10));
    }

    public static int getRequiredExperienceToEnchantCenterItem(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        boolean valid = false;
        class_1799 centerStack = enchanterBlockEntity.method_5438(0);
        if (!centerStack.method_7960() && (centerStack.method_7909().method_7870(centerStack) || SpectrumEnchantmentHelper.isEnchantableBook(centerStack))) {
            class_1799 centerStackCopy = centerStack.method_7972();
            class_9304 highestEnchantments = EnchanterBlockEntity.getHighestEnchantmentsInItemBowls(enchanterBlockEntity);
            int requiredExperience = 0;
            for (Object2IntMap.Entry entry : highestEnchantments.method_57539()) {
                int level;
                class_6880 enchantment = (class_6880)entry.getKey();
                int currentRequired = EnchanterBlockEntity.getRequiredExperienceToEnchantWithEnchantment(centerStackCopy, (class_6880<class_1887>)enchantment, level = entry.getIntValue(), enchanterBlockEntity.canOwnerApplyConflictingEnchantments);
                if (currentRequired > 0) {
                    centerStackCopy = (class_1799)SpectrumEnchantmentHelper.addOrUpgradeEnchantment(centerStackCopy, (class_6880<class_1887>)enchantment, level, false, enchanterBlockEntity.canOwnerApplyConflictingEnchantments).method_15441();
                    requiredExperience += currentRequired;
                    valid = true;
                    continue;
                }
                requiredExperience += 50;
            }
            if (valid) {
                return requiredExperience;
            }
            return -1;
        }
        return -1;
    }

    public static int getRequiredExperienceToEnchantWithEnchantment(class_1799 stack, class_6880<class_1887> enchantment, int level, boolean allowEnchantmentConflicts) {
        boolean conflicts;
        if (!stack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE) && !SpectrumEnchantmentHelper.isEnchantableBook(stack)) {
            return -1;
        }
        int existingLevel = class_1890.method_8225(enchantment, (class_1799)stack);
        if (existingLevel >= level) {
            return -1;
        }
        boolean bl = conflicts = !class_1890.method_8201((Collection)stack.method_58657().method_57534(), enchantment);
        if (conflicts && !allowEnchantmentConflicts) {
            return -1;
        }
        Integer requiredExperience = EnchanterBlockEntity.getEnchantingPrice(stack, enchantment, level);
        if (conflicts) {
            requiredExperience = requiredExperience * 4;
        }
        return requiredExperience;
    }

    public static Integer getEnchantingPrice(class_1799 stack, class_6880<class_1887> enchantment, int level) {
        int enchantability = Math.max(1, stack.method_7909().method_7837());
        if (stack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE) || SpectrumEnchantmentHelper.isEnchantableBook(stack)) {
            return EnchanterBlockEntity.getRequiredExperienceForEnchantment(enchantability, enchantment, level);
        }
        return -1;
    }

    public static int getRequiredExperienceForEnchantment(int enchantability, class_6880<class_1887> entry, int level) {
        if (enchantability > 0) {
            class_1887 enchantment = (class_1887)entry.comp_349();
            float[] rarityMults = new float[]{0.0f, 10.0f, 12.5f, 12.67f, 12.5f, 12.0f, 11.33f, 10.71f, 10.0f};
            int anvilCost = enchantment.method_58446();
            float rarityCost = rarityMults[Math.min(anvilCost, rarityMults.length - 1)] * (float)anvilCost;
            float levelCost = (float)level * Math.min(1.0f, (float)level / (float)enchantment.method_8183());
            float specialMulti = entry.method_40220(class_9636.field_51557) ? 2.0f : (entry.method_40220(class_9636.field_51551) ? 1.5f : 1.0f);
            float selectionAvailabilityMod = (entry.method_40220(class_9636.field_51547) ? 0.5f : 0.75f) + (entry.method_40220(class_9636.field_51545) ? 0.5f : 0.75f);
            float enchantabilityMod = 16.0f / (float)(2 + enchantability);
            return (int)Math.floor(rarityCost * levelCost * specialMulti * selectionAvailabilityMod * enchantabilityMod);
        }
        return -1;
    }

    public static int getExperienceWithMod(int experience, double mod, class_5819 random) {
        double modNormalized = 1.0 / (1.0 + Math.log10(mod));
        return Support.getIntFromDecimalWithChance((double)experience * modNormalized, random);
    }

    public static void craftEnchanterRecipe(class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity, @NotNull EnchanterRecipe enchanterRecipe) {
        enchanterBlockEntity.drainExperience(enchanterRecipe.getRequiredExperience());
        class_1799 resultStack = enchanterRecipe.method_8116(enchanterBlockEntity.virtualInventory.createInput(), (class_7225.class_7874)world.method_30349());
        class_1799 existingCenterStack = enchanterBlockEntity.method_5438(0);
        for (int i = 0; i < 8; ++i) {
            class_2338 itemBowlPos;
            class_2586 blockEntity;
            int resultAmountAfterEfficiencyMod = 1;
            if (!enchanterRecipe.areYieldAndEfficiencyUpgradesDisabled() && (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
                double efficiencyModifier = 1.0 / (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                resultAmountAfterEfficiencyMod = Support.getIntFromDecimalWithChance(efficiencyModifier, world.field_9229);
            }
            if (resultAmountAfterEfficiencyMod <= 0 || !((blockEntity = world.method_8321(itemBowlPos = enchanterBlockEntity.field_11867.method_10081(EnchanterBlockEntity.getItemBowlPositionOffset(i, enchanterBlockEntity.virtualInventoryRecipeOrientation, enchanterBlockEntity.virtualInventoryRecipeMirrored)))) instanceof ItemBowlBlockEntity)) continue;
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.decrementBowlStack(new class_243((double)enchanterBlockEntity.field_11867.method_10263(), (double)(enchanterBlockEntity.field_11867.method_10264() + 1), (double)enchanterBlockEntity.field_11867.method_10263() + 0.5), resultAmountAfterEfficiencyMod, false);
            itemBowlBlockEntity.updateInClientWorld();
        }
        if (!enchanterRecipe.areYieldAndEfficiencyUpgradesDisabled() && (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD) != 1.0) {
            int resultCountMod = Support.getIntFromDecimalWithChance((float)resultStack.method_7947() * enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD), world.field_9229);
            resultStack.method_7939(resultCountMod);
        }
        if (existingCenterStack.method_7947() > 1) {
            existingCenterStack.method_7934(1);
            MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, enchanterBlockEntity.field_11867, resultStack, resultStack.method_7947(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
        } else {
            enchanterBlockEntity.method_5447(0, resultStack);
        }
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(enchanterBlockEntity.ownerUUID, resultStack, enchanterRecipe.getRequiredExperience());
        class_3222 serverPlayerEntity = (class_3222)enchanterBlockEntity.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.ENCHANTER_CRAFTING.trigger(serverPlayerEntity, resultStack, enchanterRecipe.getRequiredExperience());
        }
    }

    public static int tickEnchantmentUpgradeRecipe(class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity, int itemsToConsumeLeft) {
        int itemCountToConsume = Math.min(itemsToConsumeLeft, Support.getIntFromDecimalWithChance(enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED), world.field_9229));
        int consumedAmount = 0;
        int bowlsChecked = 0;
        int randomBowlPosition = world.field_9229.method_43048(8);
        int itemCountToConsumeAfterMod = itemCountToConsume;
        if ((double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
            itemCountToConsumeAfterMod = Support.getIntFromDecimalWithChance((float)itemCountToConsume / enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY), world.field_9229);
        }
        while (consumedAmount < itemCountToConsumeAfterMod && bowlsChecked < 8 || itemCountToConsumeAfterMod == 0 & consumedAmount == 0) {
            class_2382 bowlOffset = EnchanterBlockEntity.getItemBowlPositionOffset(randomBowlPosition + bowlsChecked, enchanterBlockEntity.virtualInventoryRecipeOrientation, enchanterBlockEntity.virtualInventoryRecipeMirrored);
            class_2586 blockEntity = world.method_8321(enchanterBlockEntity.field_11867.method_10081(bowlOffset));
            if (blockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
                if (itemCountToConsumeAfterMod == 0) {
                    itemBowlBlockEntity.spawnOrbParticles(new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 1.0, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5));
                    consumedAmount += itemCountToConsume;
                } else {
                    int decrementedAmount = itemBowlBlockEntity.decrementBowlStack(new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 1.0, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5), itemCountToConsumeAfterMod, true);
                    consumedAmount += decrementedAmount;
                }
            }
            ++bowlsChecked;
        }
        return consumedAmount;
    }

    public void craftEnchantmentUpgradeRecipe(@NotNull EnchantmentUpgradeRecipe upgrade) {
        class_1799 resultStack = this.method_5438(0);
        int curLevel = ((class_9304)resultStack.method_57824(class_9334.field_49643)).method_57536(upgrade.getEnchantment());
        int targetLevel = Math.min(curLevel + 1, upgrade.getLevelCap());
        int xpCost = upgrade.getXPScaling().apply(curLevel);
        this.drainExperience(xpCost);
        resultStack = (class_1799)SpectrumEnchantmentHelper.addOrUpgradeEnchantment(resultStack, upgrade.getEnchantment(), targetLevel, false, true).method_15441();
        this.method_5447(0, resultStack);
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(this.ownerUUID, resultStack, xpCost);
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
            builder.method_57550(upgrade.getEnchantment(), targetLevel);
            SpectrumAdvancementCriteria.ENCHANTER_UPGRADING.trigger(serverPlayerEntity, builder.method_57549(), xpCost);
        }
        if (EnchanterBlockEntity.recipeMatches(this, this.field_11863)) {
            this.craftingTimeTotal = upgrade.getItemScaling().apply(targetLevel);
        } else {
            this.currentRecipe = null;
        }
    }

    public static class_2382 getItemBowlPositionOffset(int index, int orientation, boolean mirrored) {
        int diff = mirrored ? (orientation % 2 == 0 ? 1 : -1) : 0;
        int offset = (orientation * 2 + index + diff) % 8;
        return ITEM_BOWL_OFFSETS.get(offset);
    }

    private static boolean recipeMatches(EnchanterBlockEntity blockEntity, class_1937 world) {
        if (blockEntity.currentRecipe == null) {
            return EnchanterBlockEntity.isValidCenterEnchantingSetup(blockEntity);
        }
        class_1860 class_18602 = blockEntity.currentRecipe.comp_1933();
        if (class_18602 instanceof EnchanterRecipe) {
            EnchanterRecipe recipe = (EnchanterRecipe)class_18602;
            return recipe.method_8115(blockEntity.virtualInventory.createInput(), world);
        }
        class_18602 = blockEntity.currentRecipe.comp_1933();
        if (class_18602 instanceof EnchantmentUpgradeRecipe) {
            EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)class_18602;
            return recipe.method_8115(blockEntity.virtualInventory.createInput(), world);
        }
        return false;
    }

    private static void calculateCurrentRecipe(@NotNull class_1937 world, @NotNull EnchanterBlockEntity enchanter) {
        if (EnchanterBlockEntity.recipeMatches(enchanter, world)) {
            return;
        }
        enchanter.craftingTime = 0;
        class_8786<?> previousRecipe = enchanter.currentRecipe;
        enchanter.currentRecipe = null;
        class_1863 recipeManager = world.method_8433();
        class_8786 upgrade = recipeManager.method_8132(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, enchanter.virtualInventory.createInput(), world).orElse(null);
        if (upgrade != null) {
            if (enchanter.canOwnerOverenchant || ((EnchantmentUpgradeRecipe)upgrade.comp_1933()).isInNormalRange(EnchanterBlockEntity.getLevel(enchanter, (EnchantmentUpgradeRecipe)upgrade.comp_1933()))) {
                enchanter.currentRecipe = upgrade;
                enchanter.currentItemProcessingTime = 0;
                int level = ((class_9304)((class_1799)enchanter.items.get(0)).method_57824(class_9334.field_49643)).method_57536(((EnchantmentUpgradeRecipe)upgrade.comp_1933()).getEnchantment());
                enchanter.craftingTimeTotal = ((EnchantmentUpgradeRecipe)upgrade.comp_1933()).getItemScaling().apply(level);
                EnchanterInventory testInventory = new EnchanterInventory();
                testInventory.method_5447(0, enchanter.virtualInventory.method_5438(0));
                testInventory.method_5447(1, enchanter.virtualInventory.method_5438(1));
                enchanter.virtualInventory = testInventory;
            }
            if (enchanter.currentRecipe != previousRecipe) {
                enchanter.updateInClientWorld();
            }
            return;
        }
        for (int m = 0; m < 2; ++m) {
            for (int o = 0; o < 8; ++o) {
                class_9695 recipeInput = enchanter.virtualInventory.createInput();
                class_8786 enchanterRecipe = recipeManager.method_8132(SpectrumRecipeTypes.ENCHANTER, recipeInput, world).orElse(null);
                if (enchanterRecipe != null) {
                    enchanter.currentRecipe = enchanterRecipe;
                    enchanter.virtualInventoryRecipeOrientation = o;
                    enchanter.virtualInventoryRecipeMirrored = m > 0;
                    enchanter.craftingTimeTotal = (int)Math.ceil((float)((EnchanterRecipe)enchanterRecipe.comp_1933()).getCraftingTime() / enchanter.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                    enchanter.updateInClientWorld();
                    return;
                }
                enchanter.virtualInventory.rotate();
            }
            enchanter.virtualInventory.mirror();
        }
    }

    private static void grantPlayerEnchantingAdvancementCriterion(UUID playerUUID, class_1799 resultStack, int experience) {
        int levels = ExperienceHelper.getLevelForExperience(experience);
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(playerUUID);
        if (serverPlayerEntity != null) {
            serverPlayerEntity.method_7281(class_3468.field_15420);
            class_174.field_1181.method_8870(serverPlayerEntity, resultStack, levels);
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.craftingTime = nbt.method_10550("crafting_time");
        this.craftingTimeTotal = nbt.method_10550("crafting_time_total");
        this.currentItemProcessingTime = nbt.method_10550("current_item_processing_time");
        this.inventoryChanged = nbt.method_10577("inventory_changed");
        this.canOwnerApplyConflictingEnchantments = nbt.method_10577("owner_can_apply_conflicting_enchantments");
        this.canOwnerOverenchant = nbt.method_10577("owner_can_overenchant");
        this.virtualInventoryRecipeOrientation = nbt.method_10550("virtual_recipe_orientation");
        this.virtualInventoryRecipeMirrored = nbt.method_10577("virtual_recipe_mirrored");
        this.virtualInventory = new EnchanterInventory();
        class_1262.method_5429((class_2487)nbt, (class_2371)this.virtualInventory.field_5828, (class_7225.class_7874)registryLookup);
        if (nbt.method_10573("item_facing", 8)) {
            this.itemFacing = class_2350.valueOf((String)nbt.method_10558("item_facing").toUpperCase(Locale.ROOT));
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = null;
        this.currentRecipe = MultiblockCrafter.getRecipeHolderFromNbt(this.field_11863, nbt);
        if (this.currentRecipe == null && this.field_11863 != null && this.field_11863.field_9236) {
            this.stopCraftingMusic();
        }
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Environment(value=EnvType.CLIENT)
    protected void stopCraftingMusic() {
        CraftingBlockSoundInstance.stopPlayingOnPos(this.field_11867);
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("crafting_time", this.craftingTime);
        nbt.method_10569("crafting_time_total", this.craftingTimeTotal);
        nbt.method_10569("current_item_processing_time", this.currentItemProcessingTime);
        nbt.method_10569("virtual_recipe_orientation", this.virtualInventoryRecipeOrientation);
        nbt.method_10556("virtual_recipe_mirrored", this.virtualInventoryRecipeMirrored);
        nbt.method_10556("inventory_changed", this.inventoryChanged);
        nbt.method_10556("owner_can_apply_conflicting_enchantments", this.canOwnerApplyConflictingEnchantments);
        nbt.method_10556("owner_can_overenchant", this.canOwnerOverenchant);
        class_1262.method_5426((class_2487)nbt, (class_2371)this.virtualInventory.field_5828, (class_7225.class_7874)registryLookup);
        if (this.itemFacing != null) {
            nbt.method_10582("item_facing", this.itemFacing.toString().toUpperCase(Locale.ROOT));
        }
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.comp_1932().toString());
        }
    }

    @Override
    public void updateInClientWorld() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 4);
        }
    }

    public class_2350 getItemFacingDirection() {
        return Objects.requireNonNullElse(this.itemFacing, class_2350.field_11043);
    }

    public void setItemFacingDirection(class_2350 facingDirection) {
        this.itemFacing = facingDirection;
    }

    private void doItemBowlOrbs(class_1937 world) {
        for (int i = 0; i < 8; ++i) {
            class_2338 itemBowlPos = this.field_11867.method_10081(EnchanterBlockEntity.getItemBowlPositionOffset(i, 0, false));
            class_2586 blockEntity = world.method_8321(itemBowlPos);
            if (!(blockEntity instanceof ItemBowlBlockEntity)) continue;
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5));
        }
    }

    public boolean drainExperience(int amount) {
        class_1792 class_17922;
        class_1799 experienceProviderStack = this.method_5438(1);
        if (this.field_11863 != null && (class_17922 = experienceProviderStack.method_7909()) instanceof ExperienceStorageItem) {
            ExperienceStorageItem experienceStorageItem = (ExperienceStorageItem)class_17922;
            int currentStoredExperience = ExperienceStorageItem.getStoredExperience(experienceProviderStack);
            if (currentStoredExperience > 0) {
                KnowledgeGemItem knowledgeGemItem;
                int amountAfterExperienceMod = EnchanterBlockEntity.getExperienceWithMod(amount, this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE), this.field_11863.field_9229);
                int drainedExperience = Math.min(currentStoredExperience, amountAfterExperienceMod);
                if (experienceStorageItem instanceof KnowledgeGemItem && (knowledgeGemItem = (KnowledgeGemItem)experienceStorageItem).changedDisplayTier(currentStoredExperience, currentStoredExperience - drainedExperience)) {
                    PlayParticleWithPatternAndVelocityPayload.playParticleWithPatternAndVelocity(null, (class_3218)this.field_11863, new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 2.5, (double)this.field_11867.method_10260() + 0.5), ColoredCraftingParticleEffect.LIME, VectorPattern.SIXTEEN, 0.05f);
                    this.updateInClientWorld();
                }
                this.method_5431();
                return ExperienceStorageItem.removeStoredExperience(experienceProviderStack, drainedExperience);
            }
        }
        return false;
    }

    @Override
    public void inventoryChanged() {
        if (this.field_11863 == null) {
            return;
        }
        this.virtualInventory = new EnchanterInventory(this.method_5438(0), this.method_5438(1), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(5, 0, -3)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(5, 0, 3)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(3, 0, 5)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-3, 0, 5)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-5, 0, 3)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-5, 0, -3)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-3, 0, -5)), this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(3, 0, -5)));
        this.virtualInventory.method_5431();
        this.inventoryChanged = true;
        this.currentItemProcessingTime = -1;
        super.inventoryChanged();
    }

    public class_1799 getItemBowlStack(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            return itemBowlBlockEntity.method_5438(0);
        }
        return class_1799.field_8037;
    }

    public void playSound(class_3414 soundEvent, float volume) {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, volume, 0.9f + this.field_11863.field_9229.method_43057() * 0.15f);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.canOwnerApplyConflictingEnchantments = AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumAdvancements.APPLY_CONFLICTING_ENCHANTMENTS);
        this.canOwnerOverenchant = AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumAdvancements.OVERENCHANTING);
        this.method_5431();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 3, 0, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }
}

