/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.end_portal;

import com.google.common.base.Predicates;
import de.dafuqs.spectrum.blocks.end_portal.CrackedEndPortalFrameBlock;
import de.dafuqs.spectrum.blocks.end_portal.EndPortalShaper;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;

class DynamicEndPortalShaper
implements EndPortalShaper {
    private static final int MAX_PORTAL_BLOCK_COUNT = 200;
    private static final Predicate<class_2680> BORDER_STATE_PREDICATE = class_2715.method_11758((class_2248)class_2246.field_10398).method_11762((class_2769)class_2333.field_10958, (Predicate)Predicates.equalTo((Object)true)).or((Predicate)class_2715.method_11758((class_2248)SpectrumBlocks.CRACKED_END_PORTAL_FRAME).method_11762(CrackedEndPortalFrameBlock.EYE_TYPE, (Predicate)Predicates.equalTo((Object)((Object)CrackedEndPortalFrameBlock.EndPortalFrameEye.WITH_EYE_OF_ENDER))));

    DynamicEndPortalShaper() {
    }

    @Override
    public void placePortals(class_1937 level, class_2338 startPos) {
        Collection<Set<class_2338>> portalPositions = this.findValidPortal((class_1936)level, startPos);
        for (Set<class_2338> portal : portalPositions) {
            for (class_2338 pos : portal) {
                level.method_8652(pos, class_2246.field_10027.method_9564(), 2);
            }
        }
        level.method_8474(1038, startPos, 0);
    }

    @Override
    public void destroyNeighboringPortalBlocks(class_1937 level, class_2338 startPos) {
        for (class_2338 neighbor : this.getNeighbors(startPos)) {
            class_2680 neighborState = level.method_8320(neighbor);
            if (!neighborState.method_27852(class_2246.field_10027)) continue;
            level.method_8652(neighbor, class_2246.field_10124.method_9564(), 2);
            this.destroyNeighboringPortalBlocks(level, neighbor);
        }
    }

    private Collection<Set<class_2338>> findValidPortal(class_1936 level, class_2338 startPos) {
        HashSet<Set<class_2338>> validPortals = new HashSet<Set<class_2338>>();
        for (class_2338 neighbor : this.getNeighbors(startPos)) {
            HashSet<class_2338> portalPositions;
            if (!this.isValidPortalPiece(level, neighbor, portalPositions = new HashSet<class_2338>())) continue;
            validPortals.add(portalPositions);
        }
        return validPortals;
    }

    private boolean isValidPortalPiece(class_1936 world, class_2338 pos, Set<class_2338> airRegion) {
        if (world.method_31606(pos)) {
            return false;
        }
        if (airRegion.contains(pos)) {
            return true;
        }
        class_2680 state = world.method_8320(pos);
        if (BORDER_STATE_PREDICATE.test(state)) {
            return true;
        }
        if (!state.method_26215() && !state.method_45474()) {
            return false;
        }
        airRegion.add(pos);
        if (airRegion.size() > 200) {
            return false;
        }
        for (class_2338 neighbor : this.getNeighbors(pos)) {
            if (this.isValidPortalPiece(world, neighbor, airRegion)) continue;
            return false;
        }
        return true;
    }

    private Set<class_2338> getNeighbors(class_2338 pos) {
        HashSet<class_2338> neighbors = new HashSet<class_2338>();
        neighbors.add(pos.method_10095());
        neighbors.add(pos.method_10078());
        neighbors.add(pos.method_10072());
        neighbors.add(pos.method_10067());
        return neighbors;
    }
}

