/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fluid;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;

public class RemainderlessItemFluidStorage
implements ExtractionOnlyStorage<FluidVariant>,
SingleSlotStorage<FluidVariant> {
    private final ContainerItemContext context;
    private final class_1792 fullItem;
    private final FluidVariant containedFluid;
    private final long containedAmount;

    public RemainderlessItemFluidStorage(ContainerItemContext context, FluidVariant containedFluid, long containedAmount) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)containedFluid, (long)containedAmount);
        this.context = context;
        this.fullItem = context.getItemVariant().getItem();
        this.containedFluid = containedFluid;
        this.containedAmount = containedAmount;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.context.getItemVariant().isOf((Object)this.fullItem)) {
            return 0L;
        }
        if (resource.equals((Object)this.containedFluid) && maxAmount >= this.containedAmount && this.context.extract(this.context.getItemVariant(), 1L, transaction) == 1L) {
            return this.containedAmount;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        if (this.context.getItemVariant().isOf((Object)this.fullItem)) {
            return this.containedFluid;
        }
        return FluidVariant.blank();
    }

    public long getAmount() {
        if (this.context.getItemVariant().isOf((Object)this.fullItem)) {
            return this.containedAmount;
        }
        return 0L;
    }

    public long getCapacity() {
        return this.getAmount();
    }

    public String toString() {
        return "FullItemFluidStorage[context=%s, fluid=%s, amount=%d]".formatted(this.context, this.containedFluid, this.containedAmount);
    }
}

