/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.memory;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.components.MemoryComponent;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9279;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryItem
extends class_1747 {
    private static final HashMap<class_1299<?>, class_3545<Integer, Integer>> customColors = new HashMap<class_1299<?>, class_3545<Integer, Integer>>(){
        {
            this.put(class_1299.field_6108, new class_3545((Object)4603179, (Object)1643271));
            this.put(class_1299.field_6047, new class_3545((Object)13224911, (Object)10645032));
            this.put(class_1299.field_6119, new class_3545((Object)0x101211, (Object)4079936));
            this.put(class_1299.field_6065, new class_3545((Object)2709389, (Object)4935247));
            this.put(class_1299.field_6116, new class_3545((Object)0x111111, (Object)8744079));
            this.put(class_1299.field_6147, new class_3545((Object)0x9A9A9A, (Object)9139300));
        }
    };

    public MemoryItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public static MemoryComponent getMemory(class_1799 stack) {
        return (MemoryComponent)stack.method_57825(SpectrumDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT);
    }

    public static class_1799 getMemoryForEntity(class_1309 entity) {
        class_2487 tag = new class_2487();
        entity.method_5786(tag);
        tag.method_10551("Pos");
        tag.method_10551("OnGround");
        tag.method_10551("Rotation");
        tag.method_10551("Motion");
        tag.method_10551("FallDistance");
        tag.method_10551("InLove");
        tag.method_10551("UUID");
        tag.method_10551("Health");
        tag.method_10551("Fire");
        tag.method_10551("HurtByTimestamp");
        tag.method_10551("DeathTime");
        tag.method_10551("AbsorptionAmount");
        tag.method_10551("Air");
        tag.method_10551("FallFlying");
        tag.method_10551("PortalCooldown");
        tag.method_10551("HurtTime");
        class_1799 stack = SpectrumBlocks.MEMORY.method_8389().method_7854();
        stack.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)tag));
        return stack;
    }

    public static class_1799 getForEntityType(class_1299<?> entityType, int ticksToManifest) {
        class_1799 stack = SpectrumBlocks.MEMORY.method_8389().method_7854();
        stack.method_57379(SpectrumDataComponentTypes.MEMORY, (Object)new MemoryComponent.Builder(MemoryComponent.DEFAULT).ticksToManifest(ticksToManifest).build());
        class_2487 entityCompound = new class_2487();
        entityCompound.method_10582("id", class_7923.field_41177.method_10221(entityType).toString());
        stack.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)entityCompound));
        return stack;
    }

    public static class_1799 getForPlayer(class_3222 player, int ticksToManifest) {
        class_1799 stack = SpectrumBlocks.MEMORY.method_8389().method_7854();
        stack.method_57379(SpectrumDataComponentTypes.MEMORY, (Object)new MemoryComponent.Builder(MemoryComponent.DEFAULT).ticksToManifest(ticksToManifest).build());
        stack.method_57379(class_9334.field_49617, (Object)new class_9296(player.method_7334()));
        return stack;
    }

    public static class_2487 getEntityData(class_1799 stack) {
        return ((class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302)).method_57461();
    }

    public static Optional<class_1299<?>> getEntityType(class_1799 stack) {
        class_2487 data = MemoryItem.getEntityData(stack);
        if (!data.method_10573("id", 8)) {
            return Optional.empty();
        }
        return class_1299.method_5898((String)data.method_10558("id"));
    }

    public static Optional<class_9296> getPlayer(class_1799 stack) {
        class_9296 data = (class_9296)stack.method_57824(class_9334.field_49617);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    @Nullable
    public static class_2561 getMemoryEntityCustomName(class_1799 stack, class_7225.class_7874 drm) {
        class_2487 data = MemoryItem.getEntityData(stack);
        if (!data.method_10573("CustomName", 8)) {
            return null;
        }
        return class_2561.class_2562.method_10877((String)data.method_10558("CustomName"), (class_7225.class_7874)drm);
    }

    public static int getTicksToManifest(class_1799 stack) {
        return MemoryItem.getMemory(stack).ticksToManifest();
    }

    public static void setTicksToManifest(@NotNull class_1799 itemStack, int newTicksToManifest) {
        itemStack.method_57368(SpectrumDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).ticksToManifest(newTicksToManifest).build());
    }

    public static void setSpawnAsAdult(@NotNull class_1799 itemStack, boolean spawnAsAdult) {
        itemStack.method_57368(SpectrumDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).spawnAsAdult(spawnAsAdult).build());
    }

    public static void markAsBrokenPromise(class_1799 itemStack, boolean isBrokenPromise) {
        itemStack.method_57368(SpectrumDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).brokenPromise(isBrokenPromise).build());
    }

    public static boolean isBrokenPromise(class_1799 stack) {
        return MemoryItem.getMemory(stack).brokenPromise();
    }

    public static boolean isUnrecognizable(class_1799 stack) {
        return MemoryItem.getMemory(stack).unrecognizable();
    }

    public static void makeUnrecognizable(@NotNull class_1799 itemStack) {
        itemStack.method_57368(SpectrumDataComponentTypes.MEMORY, (Object)MemoryComponent.DEFAULT, comp -> new MemoryComponent.Builder((MemoryComponent)comp).unrecognizable().build());
    }

    public static int getEggColor(class_1799 stack, int tintIndex) {
        Optional<class_1299<?>> entityType;
        if (!MemoryItem.isUnrecognizable(stack) && (entityType = MemoryItem.getEntityType(stack)).isPresent()) {
            class_1299<?> type = entityType.get();
            if (customColors.containsKey(type)) {
                return tintIndex == 0 ? (Integer)customColors.get(type).method_15442() : (Integer)customColors.get(type).method_15441();
            }
            class_1826 spawnEggItem = class_1826.method_8019(entityType.get());
            if (spawnEggItem != null) {
                return spawnEggItem.method_8016(tintIndex);
            }
        }
        return tintIndex == 0 ? 0x222222 : 0xDDDDDD;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        Optional<class_9296> profile = MemoryItem.getPlayer(stack);
        Optional<class_1299<?>> entity = MemoryItem.getEntityType(stack);
        if (profile.isPresent()) {
            class_9296 resolvableProfile = profile.get();
            if (MemoryItem.isUnrecognizable(stack) || !resolvableProfile.method_57511()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.unrecognizable_entity_type").method_27692(class_124.field_1080));
            } else {
                boolean isBrokenPromise = MemoryItem.isBrokenPromise(stack);
                if (isBrokenPromise) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.named_broken_promise").method_27693((String)resolvableProfile.comp_2410().get()).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.named").method_27693((String)resolvableProfile.comp_2410().get()).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
                }
            }
        } else if (entity.isPresent()) {
            class_1299<?> entityType = entity.get();
            if (MemoryItem.isUnrecognizable(stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.unrecognizable_entity_type").method_27692(class_124.field_1080));
            } else {
                boolean isBrokenPromise = MemoryItem.isBrokenPromise(stack);
                class_2561 customName = MemoryItem.getMemoryEntityCustomName(stack, context.method_59527());
                if (isBrokenPromise) {
                    if (customName == null) {
                        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.memory.tooltip.entity_type_broken_promise", (Object[])new Object[]{entityType.method_5897()}));
                    } else {
                        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.named_broken_promise").method_10852(customName).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
                    }
                } else if (customName == null) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.memory.tooltip.entity_type", (Object[])new Object[]{entityType.method_5897()}));
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.named").method_10852(customName).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
                }
            }
        }
        if (profile.isPresent() || entity.isPresent()) {
            int ticksToHatch = MemoryItem.getTicksToManifest(stack);
            if (ticksToHatch <= 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.does_not_manifest").method_27692(class_124.field_1080));
            } else if (ticksToHatch > 100) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.extra_long_time_to_manifest").method_27692(class_124.field_1080));
            } else if (ticksToHatch > 20) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.long_time_to_manifest").method_27692(class_124.field_1080));
            } else if (ticksToHatch > 5) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.medium_time_to_manifest").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.short_time_to_manifest").method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.unset_entity_type").method_27692(class_124.field_1080));
        }
    }

    public static void appendEntries(class_7225.class_7874 lookup, class_1761.class_7704 entries) {
        HashSet<class_9279> encountered = new HashSet<class_9279>();
        if (SpectrumCommon.minecraftServer != null) {
            class_1792 memoryItem = SpectrumBlocks.MEMORY.method_8389();
            for (class_8786 recipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.SPIRIT_INSTILLING)) {
                class_9279 entity;
                class_1799 output = ((SpiritInstillerRecipe)recipe.comp_1933()).method_8110(lookup);
                if (!output.method_31574(memoryItem) || (entity = (class_9279)output.method_57824(class_9334.field_49609)) == null || encountered.contains(entity)) continue;
                entries.method_45420(output);
                encountered.add(entity);
            }
        }
    }
}

