/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmissionLogic;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import de.dafuqs.spectrum.helpers.TickLooper;
import de.dafuqs.spectrum.networking.s2c_payloads.PastelNetworkEdgeSyncPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PastelNetworkRemovedPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PastelNodeStatusUpdatePayload;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;

public class ServerPastelNetwork
extends PastelNetwork<class_3218> {
    public static final Codec<ServerPastelNetwork> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_1937.field_25178.xmap(k -> SpectrumCommon.minecraftServer.method_3847(k), class_1937::method_27983).fieldOf("world").forGetter(b -> (class_3218)b.world), (App)class_4844.field_40825.fieldOf("uuid").forGetter(PastelNetwork::getUUID), (App)Codec.INT.fieldOf("color").forGetter(PastelNetwork::getColor), (App)TickLooper.CODEC.fieldOf("looper").forGetter(b -> b.transferLooper)).apply((Applicative)i, ServerPastelNetwork::new));
    protected final Map<PastelNodeType, Set<PastelNodeBlockEntity>> loadedNodes = new ConcurrentHashMap<PastelNodeType, Set<PastelNodeBlockEntity>>();
    protected final Set<PastelNodeBlockEntity> priorityNodes = new HashSet<PastelNodeBlockEntity>();
    protected final Set<PastelNodeBlockEntity> highPriorityNodes = new HashSet<PastelNodeBlockEntity>();
    private final TickLooper transferLooper;
    protected final SchedulerMap<PastelTransmission> transmissions;
    protected final PastelTransmissionLogic transmissionLogic;

    public ServerPastelNetwork(class_3218 world, UUID uuid, int color) {
        this(world, uuid, color, new TickLooper(10));
    }

    public ServerPastelNetwork(class_3218 world, PastelNodeBlockEntity initialNode) {
        this(world, UUID.randomUUID(), initialNode.getPastelNetworkColor(), new TickLooper(10));
        this.addNode(initialNode);
    }

    public ServerPastelNetwork(class_3218 world, UUID uuid, int color, TickLooper transferLoop) {
        super(world, uuid, color);
        this.transferLooper = transferLoop;
        this.transmissions = new SchedulerMap();
        this.transmissionLogic = new PastelTransmissionLogic(this);
        for (PastelNodeType type : PastelNodeType.values()) {
            this.loadedNodes.put(type, new HashSet());
        }
        for (Map.Entry entry : this.transmissions) {
            ((PastelTransmission)entry.getKey()).setNetwork(this);
        }
    }

    private boolean addLoadedNode(PastelNodeBlockEntity node) {
        return !this.loadedNodes.get((Object)node.getNodeType()).add(node);
    }

    public void initializeNode(PastelNodeBlockEntity node) {
        Set<PastelNodeBlockEntity> type = this.loadedNodes.get((Object)node.getNodeType());
        if (!type.contains(node)) {
            type.add(node);
            this.addPriorityNode(node);
        }
    }

    private void addPriorityNode(PastelNodeBlockEntity node) {
        switch (node.getPriority()) {
            case MODERATE: {
                this.priorityNodes.add(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.add(node);
            }
        }
    }

    public void updateNodePriority(PastelNodeBlockEntity node, PastelNetwork.NodePriority oldPriority) {
        this.removePriorityNode(node, oldPriority);
        this.addPriorityNode(node);
    }

    @Override
    public String getNodeDebugText() {
        return super.getNodeDebugText() + " - Prov: " + this.getLoadedNodes(PastelNodeType.PROVIDER).size() + " - Send: " + this.getLoadedNodes(PastelNodeType.SENDER).size() + " - Gath: " + this.getLoadedNodes(PastelNodeType.GATHER).size() + " - Stor: " + this.getLoadedNodes(PastelNodeType.STORAGE).size() + " - Conn: " + this.getLoadedNodes(PastelNodeType.CONNECTION).size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uuid.toString());
        for (PastelNodeType type : PastelNodeType.values()) {
            builder.append("-").append(this.getLoadedNodes(type).size());
        }
        return builder.toString();
    }

    @Nullable
    protected PastelNodeBlockEntity getLoadedNodeAt(class_2338 blockPos) {
        if (!this.graph.vertexSet().contains(blockPos)) {
            return null;
        }
        if (!((class_3218)this.getWorld()).method_22340(blockPos)) {
            return null;
        }
        class_2586 blockEntity = ((class_3218)this.getWorld()).method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    private void removePriorityNode(PastelNodeBlockEntity node, PastelNetwork.NodePriority priority) {
        switch (priority) {
            case MODERATE: {
                this.priorityNodes.remove(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.remove(node);
            }
        }
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type) {
        return this.getLoadedNodes(type, PastelNetwork.NodePriority.GENERIC);
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type, PastelNetwork.NodePriority priority) {
        Set<PastelNodeBlockEntity> nodeType = this.loadedNodes.get((Object)type);
        if (priority == PastelNetwork.NodePriority.MODERATE) {
            return nodeType.stream().filter(this.priorityNodes::contains).collect(Collectors.toSet());
        }
        if (priority == PastelNetwork.NodePriority.HIGH) {
            return nodeType.stream().filter(this.highPriorityNodes::contains).collect(Collectors.toSet());
        }
        return nodeType;
    }

    protected void addNode(PastelNodeBlockEntity node) {
        if (this.graph.containsVertex((Object)node.method_11016())) {
            this.loadedNodes.get((Object)node.getNodeType()).add(node);
        } else {
            if (this.addLoadedNode(node)) {
                return;
            }
            this.graph.addVertex((Object)node.method_11016());
        }
        this.addPriorityNode(node);
        node.setNetworkUUID(this.getUUID());
    }

    protected void addNodeAndConnect(PastelNodeBlockEntity newNode, PastelNodeBlockEntity existing) {
        if (this.addLoadedNode(newNode)) {
            return;
        }
        this.graph.addVertex((Object)newNode.method_11016());
        this.getGraph().addEdge((Object)newNode.method_11016(), (Object)existing.method_11016());
        this.addPriorityNode(newNode);
        newNode.setNetworkUUID(this.getUUID());
        PastelNetworkEdgeSyncPayload.send(this, newNode.method_11016());
    }

    private void checkForNetworkSplit(class_2338 sourcePos) {
        ConnectivityInspector connectivityInspector;
        List connectedSets;
        Set vertices = this.graph.vertexSet();
        if (this.graph.vertexSet().size() < 2) {
            for (class_2338 vertex : vertices) {
                Optional be = ((class_3218)this.world).method_35230(vertex, SpectrumBlockEntities.PASTEL_NODE);
                be.ifPresent(pastelNodeBlockEntity -> pastelNodeBlockEntity.setNetworkUUID(null));
            }
            Pastel.getServerInstance().removeNetwork(this.getUUID());
        }
        if ((connectedSets = (connectivityInspector = new ConnectivityInspector(this.graph)).connectedSets()).size() == 1) {
            return;
        }
        int biggestSetSize = 0;
        Set biggestSet = null;
        ArrayList<Set> smallerSets = new ArrayList<Set>();
        for (Set set : connectedSets) {
            int size = set.size();
            if (size > biggestSetSize) {
                biggestSetSize = size;
                if (biggestSet != null) {
                    smallerSets.add(biggestSet);
                }
                biggestSet = set;
                continue;
            }
            smallerSets.add(set);
        }
        if (biggestSetSize == 1) {
            for (class_2338 pos : this.graph.vertexSet()) {
                Optional blockEntity = ((class_3218)this.world).method_35230(pos, SpectrumBlockEntities.PASTEL_NODE);
                blockEntity.ifPresent(pastelNodeBlockEntity -> pastelNodeBlockEntity.setNetworkUUID(null));
            }
            PastelNetworkRemovedPayload.send(this);
            return;
        }
        ObjectOpenHashSet disconnectedBEs = new ObjectOpenHashSet();
        for (Set smallerSet : smallerSets) {
            boolean isSingleNode;
            boolean bl = isSingleNode = smallerSet.size() == 1;
            if (isSingleNode) {
                Optional blockEntity = ((class_3218)this.world).method_35230((class_2338)smallerSet.stream().findAny().get(), SpectrumBlockEntities.PASTEL_NODE);
                if (!blockEntity.isPresent()) continue;
                ((PastelNodeBlockEntity)blockEntity.get()).setNetworkUUID(null);
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                continue;
            }
            PastelNodeBlockEntity initialNode = null;
            ObjectArraySet blockEntities = new ObjectArraySet();
            for (class_2338 pos : smallerSet) {
                Optional blockEntity = ((class_3218)this.world).method_35230(pos, SpectrumBlockEntities.PASTEL_NODE);
                if (!blockEntity.isPresent()) continue;
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                blockEntities.add((PastelNodeBlockEntity)blockEntity.get());
                if (initialNode != null) continue;
                initialNode = (PastelNodeBlockEntity)blockEntity.get();
            }
            ServerPastelNetwork newNetwork = Pastel.getServerInstance().createNetwork((class_3218)this.world, initialNode);
            Object2ObjectArrayMap edges = new Object2ObjectArrayMap();
            for (class_2338 class_23382 : smallerSet) {
                for (DefaultEdge edge : this.graph.edgesOf((Object)class_23382)) {
                    edges.put((class_2338)this.graph.getEdgeSource((Object)edge), (class_2338)this.graph.getEdgeTarget((Object)edge));
                }
                Optional couldBeANode = ((class_3218)this.getWorld()).method_35230(class_23382, SpectrumBlockEntities.PASTEL_NODE);
                if (!couldBeANode.isPresent()) continue;
                PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)couldBeANode.get();
                newNetwork.addNode(pastelNode);
                pastelNode.setNetworkUUID(newNetwork.getUUID());
            }
            for (Map.Entry entry : edges.entrySet()) {
                newNetwork.addEdge((class_2338)entry.getKey(), (class_2338)entry.getValue());
            }
        }
        for (PastelNodeBlockEntity p : disconnectedBEs) {
            this.removeNode(p, NodeRemovalReason.REMOVED);
        }
        PastelNetworkEdgeSyncPayload.send(this, sourcePos);
        this.transmissionLogic.invalidateCache();
    }

    public void incorporate(ServerPastelNetwork networkToIncorporate, class_2338 trackingPos) {
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodesToIncorporate : networkToIncorporate.loadedNodes.entrySet()) {
            for (PastelNodeBlockEntity nodeToIncorporate : nodesToIncorporate.getValue()) {
                this.addNode(nodeToIncorporate);
            }
        }
        networkToIncorporate.graph.vertexSet().forEach(pos -> {
            class_2586 patt0$temp = ((class_3218)this.world).method_8321(pos);
            if (patt0$temp instanceof PastelNodeBlockEntity) {
                PastelNodeBlockEntity switchNode = (PastelNodeBlockEntity)patt0$temp;
                switchNode.setNetworkUUID(this.uuid);
            }
            this.graph.addVertex(pos);
        });
        networkToIncorporate.graph.edgeSet().forEach(edge -> this.graph.addEdge((Object)((class_2338)networkToIncorporate.getGraph().getEdgeSource(edge)), (Object)((class_2338)networkToIncorporate.getGraph().getEdgeTarget(edge))));
        Pastel.getServerInstance().removeNetwork(networkToIncorporate.getUUID());
        this.transmissionLogic.invalidateCache();
    }

    protected void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        if (!this.graph.containsVertex((Object)node.method_11016())) {
            return;
        }
        if (reason != NodeRemovalReason.UNLOADED) {
            this.graph.removeVertex((Object)node.method_11016());
        }
        this.loadedNodes.get((Object)node.getNodeType()).remove(node);
        this.removePriorityNode(node, node.getPriority());
        if (reason.checksForNetworkSplit) {
            this.checkForNetworkSplit(node.method_11016());
            PastelNetworkEdgeSyncPayload.send(this, node.method_11016());
        }
        if (reason != NodeRemovalReason.REMOVED) {
            node.setNetworkUUID(null);
        }
    }

    @Override
    public boolean addEdge(PastelNodeBlockEntity existingNode, PastelNodeBlockEntity newNode) {
        Optional<ServerPastelNetwork> network = existingNode.getServerNetwork();
        if (network.isEmpty()) {
            throw new IllegalStateException("Attempted to add an edge to a null network");
        }
        if (network.get() != this) {
            throw new IllegalStateException("Attempted to add an edge to a foreign network");
        }
        Optional<ServerPastelNetwork> otherNetwork = newNode.getServerNetwork();
        if (otherNetwork.isPresent() && !otherNetwork.equals(network)) {
            throw new IllegalArgumentException("Can't add an edge between nodes in different networks");
        }
        if (existingNode == newNode) {
            throw new IllegalStateException("Attempted to connect a node to itself");
        }
        if (network.get().hasEdge(existingNode.method_11016(), newNode.method_11016())) {
            throw new IllegalStateException("Attempted to add an edge that already exists");
        }
        this.addNode(newNode);
        return super.addEdge(existingNode, newNode);
    }

    public void markDirty(class_2338 syncPos) {
        this.transmissionLogic.invalidateCache();
        PastelNetworkEdgeSyncPayload.send(this, syncPos);
    }

    protected void tick() {
        this.transmissions.tick();
        PastelNetwork.NodePriority priority = PastelNetwork.NodePriority.GENERIC;
        if (this.transferLooper.getTick() % 5 == 0) {
            priority = PastelNetwork.NodePriority.MODERATE;
        } else if (this.transferLooper.getTick() % 2 == 0) {
            priority = PastelNetwork.NodePriority.HIGH;
        }
        this.transferLooper.tick();
        boolean cap = this.transferLooper.reachedCap();
        if (cap || priority != PastelNetwork.NodePriority.GENERIC) {
            if (cap) {
                this.transferLooper.reset();
            }
            try {
                this.transmissionLogic.tick(priority);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tickNodeEffects();
    }

    public Map<PastelTransmission, Integer> getTransmissions() {
        return this.transmissions.getMap();
    }

    private void tickNodeEffects() {
        ArrayList<PastelNodeBlockEntity> nodeSync = new ArrayList<PastelNodeBlockEntity>();
        for (Map.Entry<PastelTransmission, Integer> entry : this.transmissions) {
            class_2586 node;
            int travelTime;
            double progress;
            PastelTransmission transmission = entry.getKey();
            Integer remainingTravelTime = entry.getValue();
            List<class_2338> nodes = transmission.getNodePositions();
            if (nodes.isEmpty() || (progress = (double)((travelTime = transmission.getTransmissionDuration()) - remainingTravelTime)) == 0.0 || progress % (double)transmission.getVertexTime() != 0.0 || !((node = ((class_3218)this.world).method_8321(nodes.get((int)Math.round((double)(nodes.size() - 1) * progress / (double)travelTime)))) instanceof PastelNodeBlockEntity)) continue;
            PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)node;
            nodeSync.add(pastelNode);
            if (!pastelNode.isSensor()) continue;
            pastelNode.notifySensor();
        }
        if (!nodeSync.isEmpty()) {
            PastelNodeStatusUpdatePayload.sendPastelNodeStatusUpdate(nodeSync, false);
        }
    }

    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }
}

