/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeSignature;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlock;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PastelNodeBlockEntityRenderer
implements class_827<PastelNodeBlockEntity> {
    private static final long REAL_DAY_LENGTH = 1728000L;
    private static final Crystal CONNECTION = new Crystal(SpectrumItems.CONNECTION_NODE_CRYSTAL.method_7854(), 0.25, false);
    private static final Crystal PROVIDER = new Crystal(SpectrumItems.PROVIDER_NODE_CRYSTAL.method_7854(), 0.1, true);
    private static final Crystal SENDER = new Crystal(SpectrumItems.SENDER_NODE_CRYSTAL.method_7854(), 0.1, true);
    private static final Crystal STORAGE = new Crystal(SpectrumItems.STORAGE_NODE_CRYSTAL.method_7854(), 0.15, true);
    private static final Crystal GATHER = new Crystal(SpectrumItems.GATHER_NODE_CRYSTAL.method_7854(), 0.1, false);
    private static final class_2960 BASE = SpectrumCommon.locate("textures/block/pastel_node_base.png");
    private static final class_2960 INNER_RING = SpectrumCommon.locate("textures/block/pastel_node_inner_ring_blank.png");
    private static final class_2960 OUTER_RING = SpectrumCommon.locate("textures/block/pastel_node_outer_ring_blank.png");
    private static final class_2960 REDSTONE_RING = SpectrumCommon.locate("textures/block/pastel_node_redstone_ring_blank.png");
    private final class_630 base = PastelNodeBlockEntityRenderer.getItemNodeBaseTexturedModelData().method_32109();

    public PastelNodeBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    @NotNull
    public static class_5607 getItemNodeBaseTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("base", class_5606.method_32108().method_32101(6, 0).method_32097(-1.0f, 1.1f, -1.0f, 2.0f, 0.0f, 2.0f), class_5603.field_27701);
        modelPartData.method_32117("leaf1", class_5606.method_32108().method_32101(-4, 0).method_32097(-2.0f, 1.0f, -4.0f, 4.0f, 0.0f, 4.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        modelPartData.method_32117("leaf2", class_5606.method_32108().method_32101(-4, 4).method_32097(-2.0f, 1.0f, 0.0f, 4.0f, 0.0f, 4.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        modelPartData.method_32117("leaf3", class_5606.method_32108().method_32101(-4, 8).method_32097(0.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f), class_5603.method_32091((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        modelPartData.method_32117("leaf4", class_5606.method_32108().method_32101(-4, 12).method_32097(-4.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f), class_5603.method_32091((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return class_5607.method_32110((class_5609)modelData, (int)16, (int)16);
    }

    public void render(PastelNodeBlockEntity node, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (node.getState() == null) {
            return;
        }
        class_1937 world = node.method_10997();
        if (world == null) {
            return;
        }
        float time = (float)((world.method_8510() + node.getCreationStamp()) % 1728000L) + tickDelta;
        Crystal crystal = switch (node.getNodeType()) {
            default -> throw new MatchException(null, null);
            case PastelNodeType.CONNECTION -> CONNECTION;
            case PastelNodeType.STORAGE -> STORAGE;
            case PastelNodeType.PROVIDER -> PROVIDER;
            case PastelNodeType.SENDER -> SENDER;
            case PastelNodeType.GATHER -> GATHER;
        };
        float heightMod = 0.7f;
        switch (node.getState()) {
            case CONNECTED: {
                node.rotationTarget = this.mod((double)time / (Math.PI * 3));
                node.heightTarget = (float)Math.sin(time / 19.0f) / 10.0f + heightMod;
                node.alphaTarget = 1.0f;
                break;
            }
            case DISCONNECTED: {
                node.heightTarget = 0.0f;
                node.alphaTarget = 0.0f;
                break;
            }
            case ACTIVE: {
                node.rotationTarget = this.mod((double)time / Math.PI);
                node.heightTarget = (float)Math.sin(time / 19.0f) / 10.0f + heightMod;
                node.alphaTarget = 1.0f;
                break;
            }
            case INACTIVE: {
                node.rotationTarget = this.mod((double)time / (Math.PI * 7));
                node.heightTarget = (float)Math.sin(time / 19.0f) / 20.0f + heightMod / 2.0f;
                node.alphaTarget = 0.275f;
            }
        }
        float interp = class_3532.method_15363((float)(((float)node.interpTicks + tickDelta) / (float)node.interpLength), (float)0.0f, (float)1.0f);
        node.crystalRotation = class_3532.method_16439((float)interp, (float)node.lastRotationTarget, (float)node.rotationTarget);
        node.crystalHeight = class_3532.method_16439((float)interp, (float)node.lastHeightTarget, (float)node.heightTarget);
        node.ringAlpha = class_3532.method_16439((float)interp, (float)node.lastAlphaTarget, (float)node.alphaTarget);
        class_2350 facing = (class_2350)node.method_11010().method_11654((class_2769)PastelNodeBlock.field_10927);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11033: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                break;
            }
            case field_11043: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(270.0f));
                break;
            }
            case field_11035: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
        matrices.method_22904(0.0, -0.5, 0.0);
        float quarterCrystalRotation = node.crystalRotation / 2.0f;
        matrices.method_22907(class_7833.field_40716.rotation(quarterCrystalRotation));
        class_4588 rootBuffer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)BASE));
        this.base.method_22698(matrices, rootBuffer, light, overlay);
        matrices.method_22907(class_7833.field_40716.rotation(quarterCrystalRotation * 2.0f));
        matrices.method_22905(0.6f, 0.6f, 0.6f);
        Vector3f color = SpectrumColorHelper.colorIntToVec(node.networkUUID.flatMap(id -> Pastel.getClientInstance().getNetwork((UUID)id)).map(PastelNetwork::getColor).orElse(0xFFFFFF));
        color = SpectrumColorHelper.colorIntToVec(SpectrumColorHelper.interpolate(color, SpectrumColorHelper.WASH, 0.2125f));
        float ringHeight = node.crystalHeight - 0.3f;
        class_4588 innerRing = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)node.getInnerRing().map(PastelUpgradeSignature::innerRing).orElse(INNER_RING)));
        if (node.getInnerRing().isPresent()) {
            RenderHelper.renderFlatTransWithZYOffset(matrices, innerRing, true, 3.75f + ringHeight / 2.0f, 7.0f, node.ringAlpha, 1.0f, overlay);
        } else {
            RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, innerRing, true, 3.75f + ringHeight / 2.0f, 7.0f, node.ringAlpha, 1.0f, overlay, color.x, color.y, color.z);
        }
        class_4588 redstoneRing = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)node.getRedstoneRing().map(PastelUpgradeSignature::outerRing).orElse(REDSTONE_RING)));
        if (node.getRedstoneRing().isPresent()) {
            RenderHelper.renderFlatTransWithZYOffset(matrices, redstoneRing, true, 5.0f + ringHeight, 15.0f, node.ringAlpha * node.getRedstoneAlphaMult(), 1.0f, overlay);
        } else {
            RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, redstoneRing, true, 5.0f + ringHeight, 15.0f, node.ringAlpha * node.getRedstoneAlphaMult(), 1.0f, overlay, color.x, color.y, color.z);
        }
        if (crystal.hasOuterRing()) {
            class_4588 outerRing = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)node.getOuterRing().map(PastelUpgradeSignature::outerRing).orElse(OUTER_RING)));
            if (node.getOuterRing().isPresent()) {
                RenderHelper.renderFlatTransWithZYOffset(matrices, outerRing, true, 5.75f + ringHeight * 2.0f, 11.0f, node.ringAlpha, 1.0f, overlay);
            } else {
                RenderHelper.renderFlatTransWithZYOffsetAndColor(matrices, outerRing, true, 5.75f + ringHeight * 2.0f, 11.0f, node.ringAlpha, 1.0f, overlay, color.x, color.y, color.z);
            }
        }
        matrices.method_22904(0.0, (double)node.crystalHeight + crystal.yOffset, 0.0);
        class_310.method_1551().method_1480().method_23178(crystal.crystal, class_811.field_4315, 0xF000F0, overlay, matrices, vertexConsumers, node.method_10997(), 0);
        matrices.method_22909();
    }

    private float mod(double in) {
        return (float)(in % (Math.PI * 2));
    }

    private record Crystal(class_1799 crystal, double yOffset, boolean hasOuterRing) {
    }
}

