/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.PaintbrushTriggered;
import de.dafuqs.spectrum.api.block.PedestalVariant;
import de.dafuqs.spectrum.api.block.RedstonePoweredBlock;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayPedestalStartCraftingParticlePayload;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PedestalBlock
extends class_2237
implements RedstonePoweredBlock,
PaintbrushTriggered {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("place_pedestal");
    private static final class_265 SHAPE;
    private final PedestalVariant variant;
    public static final List<class_2382> UPGRADE_BLOCK_OFFSETS;

    public PedestalBlock(class_4970.class_2251 settings, PedestalVariant variant) {
        super(settings);
        this.variant = variant;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false)));
        Upgradeable.registerUpgradePosOffsets(UPGRADE_BLOCK_OFFSETS);
    }

    public MapCodec<? extends PedestalBlock> method_53969() {
        return null;
    }

    public static void upgradeToVariant(@NotNull class_1937 world, class_2338 blockPos, PedestalVariant newPedestalVariant) {
        world.method_8501(blockPos, newPedestalVariant.getPedestalBlock().method_9605((class_1750)new class_2968(world, blockPos, class_2350.field_11033, null, class_2350.field_11036)));
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        if (world.field_9236) {
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_SIMPLE));
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_ADVANCED));
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_COMPLEX));
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_COMPLEX_WITHOUT_MOONSTONE));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnUpgradeParticleEffectsForTier(class_2338 blockPos, @NotNull PedestalRecipeTier newPedestalRecipeTier) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_5819 random = world.method_8409();
        switch (newPedestalRecipeTier) {
            case COMPLEX: {
                float randomX;
                float randomZ;
                int i;
                ColoredCraftingParticleEffect particleEffect = ColoredCraftingParticleEffect.WHITE;
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case ADVANCED: {
                float randomX;
                float randomZ;
                int i;
                ColoredCraftingParticleEffect particleEffect = ColoredCraftingParticleEffect.BLACK;
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case SIMPLE: {
                float randomX;
                float randomZ;
                int i;
                ColoredCraftingParticleEffect particleEffectC = ColoredCraftingParticleEffect.CYAN;
                ColoredCraftingParticleEffect particleEffectM = ColoredCraftingParticleEffect.MAGENTA;
                ColoredCraftingParticleEffect particleEffectY = ColoredCraftingParticleEffect.YELLOW;
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectY, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectC, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() + 1.1, 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() - 0.1, 0.0, 0.05, 0.0);
                }
                break;
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (placer instanceof class_3222 && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setOwner((class_1657)((class_3222)placer));
            blockEntity.method_5431();
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12484});
    }

    public class_9062 method_55765(class_1799 handStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_9062 actionResult = this.checkAndDoPaintbrushTrigger(state, world, pos, player, hand, hit);
        if (actionResult.method_55643()) {
            return actionResult;
        }
        if (world.field_9236) {
            return class_9062.field_47728;
        }
        this.openScreen(world, pos, player);
        return class_9062.field_47729;
    }

    protected void openScreen(class_1937 world, class_2338 pos, class_1657 player) {
        Optional blockEntity = world.method_35230(pos, SpectrumBlockEntities.PEDESTAL);
        if (blockEntity.isPresent()) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity.get();
            pedestalBlockEntity.setOwner(player);
            player.method_17355((class_3908)pedestalBlockEntity);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2248 class_22482 = newState.method_26204();
        if (class_22482 instanceof PedestalBlock) {
            class_2586 blockEntity;
            PedestalBlock newStateBlock = (PedestalBlock)class_22482;
            if (!state.method_27852((class_2248)newStateBlock) && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity) {
                PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
                if (state.method_26204().equals(newStateBlock)) {
                    PedestalVariant newVariant = newStateBlock.getVariant();
                    pedestalBlockEntity.setVariant(newVariant);
                }
            }
        } else {
            InWorldInteractionBlock.scatterContents(world, pos);
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PedestalBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, @NotNull class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, class_2680 state, class_2591<T> type) {
        return PedestalBlock.method_31618(type, SpectrumBlockEntities.PEDESTAL, (class_5558)(world.field_9236 ? PedestalBlockEntity::clientTick : PedestalBlockEntity::serverTick));
    }

    public void method_9612(class_2680 state, @NotNull class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (this.checkGettingPowered(world, pos)) {
                this.power(world, pos);
            } else {
                this.unPower(world, pos);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(@NotNull class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12484)).booleanValue()) {
            Vector3f color = new Vector3f(0.5f, 0.5f, 0.5f);
            float xOffset = random.method_43057();
            float zOffset = random.method_43057();
            world.method_8406((class_2394)new class_2390(color, 1.0f), (double)((float)pos.method_10263() + xOffset), (double)(pos.method_10264() + 1), (double)((float)pos.method_10260() + zOffset), 0.0, 0.0, 0.0);
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            PedestalBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2680 placementState = this.method_9564();
        if (ctx.method_8045().method_49804(ctx.method_8037()) > 0) {
            placementState = (class_2680)placementState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true));
        }
        return placementState;
    }

    public PedestalVariant getVariant() {
        return this.variant;
    }

    @Override
    public class_9062 onPaintBrushTrigger(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            GatedRecipe gatedRecipe;
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            if (pedestalBlockEntity.propertyDelegate.craftingTime > 0) {
                return class_9062.field_47733;
            }
            if (pedestalBlockEntity.currentRecipe == null) {
                return class_9062.field_47733;
            }
            class_1860 class_18602 = pedestalBlockEntity.currentRecipe.comp_1933();
            if (class_18602 instanceof GatedRecipe && !(gatedRecipe = (GatedRecipe)class_18602).canPlayerCraft(player)) {
                return class_9062.field_47733;
            }
            if (!world.field_9236) {
                pedestalBlockEntity.shouldCraft = true;
                PlayPedestalStartCraftingParticlePayload.spawnPedestalStartCraftingParticles(pedestalBlockEntity);
            }
            return class_9062.method_55644((boolean)world.field_9236);
        }
        return class_9062.field_47733;
    }

    static {
        UPGRADE_BLOCK_OFFSETS = List.of(new class_2382(3, -2, 3), new class_2382(-3, -2, 3), new class_2382(3, -2, -3), new class_2382(-3, -2, -3));
        class_265 foot = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
        class_265 neck = class_2248.method_9541((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        class_265 head = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        foot = class_259.method_1084((class_265)foot, (class_265)neck);
        SHAPE = class_259.method_1084((class_265)foot, (class_265)head);
    }
}

