/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.spirit_instiller;

import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.decoration.GemstoneChimeBlock;
import de.dafuqs.spectrum.blocks.item_bowl.ItemBowlBlockEntity;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.render.animation.FlowAnimator;
import de.dafuqs.spectrum.render.animation.FlowData;
import de.dafuqs.spectrum.render.animation.FlowHandlers;
import de.dafuqs.spectrum.render.animation.FlowStates;
import de.dafuqs.spectrum.render.animation.Interpolation;
import de.dafuqs.spectrum.render.animation.KeyFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public class SpiritInstillerBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter {
    private static final FlowAnimator.Factory<SpiritInstillerBlockEntity> FACTORY;
    private static final KeyFrame<Float> platformPos;
    protected static final int INVENTORY_SIZE = 3;
    public static final List<class_2382> itemBowlOffsetsHorizontal;
    public static final List<class_2382> itemBowlOffsetsVertical;
    private boolean inventoryChanged;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private class_2470 multiblockRotation = class_2470.field_11467;
    private class_8786<SpiritInstillerRecipe> currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private boolean validStructure;
    protected FlowAnimator animator;
    protected FlowData<Float> _platformY = FlowData.NULL();
    protected FlowData<Float> _haloY = FlowData.NULL();
    protected FlowData<Float> _platformSpin = FlowData.NULL();
    protected FlowData<Float> _haloSpin = FlowData.NULL();
    protected FlowData<Float> _haloAlpha = FlowData.NULL();
    protected FlowData<Float> _blossomAlpha = FlowData.NULL();
    protected float platform;
    protected float geode;
    protected float calcite;
    protected float innergeode;

    public SpiritInstillerBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.SPIRIT_INSTILLER, pos, state, 3);
    }

    @Override
    public List<class_2382> getUpgradePosOffsets() {
        return SpiritInstillerBlock.UPGRADE_BLOCK_OFFSETS;
    }

    public static void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull SpiritInstillerBlockEntity instiller) {
        if (instiller.animator == null) {
            instiller.animator = FACTORY.create(FlowStates.INIT, instiller);
        } else {
            instiller.updateAnimator();
        }
        if (instiller.currentRecipe != null && world.method_8510() % 43L == 0L) {
            instiller.doChimeParticles(world);
        }
    }

    private void updateAnimator() {
        this.animator.tick();
        if (!this.validStructure) {
            this.animator.swapState(FlowStates.MB_INVALID);
            return;
        }
        if (this.method_5438(0).method_7960()) {
            this.animator.swapState(FlowStates.INACTIVE);
        } else if (this.currentRecipe != null) {
            this.animator.swapState(FlowStates.ACTIVE);
        } else {
            this.animator.swapState(FlowStates.IDLE);
        }
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        if (spiritInstillerBlockEntity.upgrades == null) {
            spiritInstillerBlockEntity.calculateUpgrades();
        }
        if (spiritInstillerBlockEntity.inventoryChanged) {
            class_8786<SpiritInstillerRecipe> previousRecipe = spiritInstillerBlockEntity.currentRecipe;
            SpiritInstillerBlockEntity.calculateCurrentRecipe(world, spiritInstillerBlockEntity);
            if (spiritInstillerBlockEntity.currentRecipe != previousRecipe) {
                spiritInstillerBlockEntity.craftingTime = 0;
                if (spiritInstillerBlockEntity.currentRecipe == null) {
                    PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)world, spiritInstillerBlockEntity.field_11867);
                } else {
                    spiritInstillerBlockEntity.craftingTimeTotal = (int)Math.ceil((float)((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.comp_1933()).getCraftingTime() / spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                }
                spiritInstillerBlockEntity.updateInClientWorld();
            }
            spiritInstillerBlockEntity.inventoryChanged = false;
        }
        if (spiritInstillerBlockEntity.currentRecipe == null) {
            return;
        }
        if (spiritInstillerBlockEntity.craftingTime % 60 == 0 && !SpiritInstillerBlockEntity.checkRecipeRequirements(world, blockPos, spiritInstillerBlockEntity)) {
            spiritInstillerBlockEntity.craftingTime = 0;
            spiritInstillerBlockEntity.method_5431();
            PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)world, spiritInstillerBlockEntity.field_11867);
            return;
        }
        if (spiritInstillerBlockEntity.currentRecipe != null) {
            ++spiritInstillerBlockEntity.craftingTime;
            if (spiritInstillerBlockEntity.craftingTime == 1) {
                PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.SPIRIT_INSTILLER_CRAFTING, (class_3218)world, spiritInstillerBlockEntity.field_11867, Integer.MAX_VALUE);
            } else if ((double)spiritInstillerBlockEntity.craftingTime == (double)spiritInstillerBlockEntity.craftingTimeTotal * 0.01 || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.25) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.5) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.75) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.83) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.9) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.95) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.98) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.99)) {
                spiritInstillerBlockEntity.doItemBowlOrbs(world);
            } else if (spiritInstillerBlockEntity.craftingTime == spiritInstillerBlockEntity.craftingTimeTotal) {
                SpiritInstillerBlockEntity.craftSpiritInstillerRecipe(world, spiritInstillerBlockEntity, spiritInstillerBlockEntity.currentRecipe);
            }
            spiritInstillerBlockEntity.method_5431();
        }
    }

    private static void calculateCurrentRecipe(@NotNull class_1937 world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        if (spiritInstillerBlockEntity.currentRecipe != null && !spiritInstillerBlockEntity.method_5442() && ((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.comp_1933()).matches(spiritInstillerBlockEntity.getRecipeInput(), world)) {
            return;
        }
        spiritInstillerBlockEntity.craftingTime = 0;
        spiritInstillerBlockEntity.currentRecipe = null;
        class_1799 instillerStack = spiritInstillerBlockEntity.method_5438(0);
        if (!instillerStack.method_7960()) {
            ItemBowlBlockEntity itemBowlBlockEntity;
            spiritInstillerBlockEntity.method_5447(0, instillerStack);
            class_2586 class_25862 = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
            if (class_25862 instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)class_25862;
                spiritInstillerBlockEntity.method_5447(1, itemBowlBlockEntity.method_5438(0));
            } else {
                spiritInstillerBlockEntity.method_5447(1, class_1799.field_8037);
            }
            class_25862 = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
            if (class_25862 instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)class_25862;
                spiritInstillerBlockEntity.method_5447(2, itemBowlBlockEntity.method_5438(0));
            } else {
                spiritInstillerBlockEntity.method_5447(2, class_1799.field_8037);
            }
            class_8786 spiritInstillerRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.SPIRIT_INSTILLING, spiritInstillerBlockEntity.getRecipeInput(), world).orElse(null);
            if (spiritInstillerRecipe != null) {
                spiritInstillerBlockEntity.currentRecipe = spiritInstillerRecipe;
                spiritInstillerBlockEntity.craftingTimeTotal = (int)Math.ceil((float)((SpiritInstillerRecipe)spiritInstillerRecipe.comp_1933()).getCraftingTime() / spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
            }
        }
        spiritInstillerBlockEntity.updateInClientWorld();
    }

    public static class_2338 getItemBowlPos(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, boolean right) {
        class_2338 blockPos = spiritInstillerBlockEntity.field_11867;
        switch (spiritInstillerBlockEntity.multiblockRotation) {
            case field_11467: 
            case field_11464: {
                if (right) {
                    return blockPos.method_10084().method_10089(2);
                }
                return blockPos.method_10084().method_10088(2);
            }
        }
        if (right) {
            return blockPos.method_10084().method_10076(2);
        }
        return blockPos.method_10084().method_10077(2);
    }

    private static boolean checkRecipeRequirements(class_1937 world, class_2338 blockPos, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        class_1657 lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(spiritInstillerBlockEntity.ownerUUID);
        if (lastInteractedPlayer == null) {
            return false;
        }
        boolean playerCanCraft = true;
        if (spiritInstillerBlockEntity.currentRecipe != null) {
            playerCanCraft = ((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.comp_1933()).canPlayerCraft(lastInteractedPlayer);
        }
        boolean structureComplete = SpiritInstillerBlock.verifyStructure(world, blockPos, null, spiritInstillerBlockEntity);
        boolean canCraft = true;
        if (!playerCanCraft || !structureComplete) {
            if (!structureComplete) {
                world.method_8396(null, spiritInstillerBlockEntity.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
            }
            canCraft = false;
        }
        if (lastInteractedPlayer instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)lastInteractedPlayer;
            SpiritInstillerBlockEntity.testAndUnlockRecipeAdvancements(serverPlayerEntity, spiritInstillerBlockEntity.currentRecipe, canCraft);
        }
        return canCraft & ((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.comp_1933()).canPlayerCraft(lastInteractedPlayer) && ((SpiritInstillerRecipe)spiritInstillerBlockEntity.currentRecipe.comp_1933()).canCraftWithStacks(spiritInstillerBlockEntity.getRecipeInput());
    }

    public static void testAndUnlockRecipeAdvancements(class_3222 player, class_8786<SpiritInstillerRecipe> spiritInstillerRecipe, boolean canActuallyCraft) {
        boolean isBossMenory;
        boolean bl = isBossMenory = ((SpiritInstillerRecipe)spiritInstillerRecipe.comp_1933()).method_8112() != null && ((SpiritInstillerRecipe)spiritInstillerRecipe.comp_1933()).method_8112().equals("boss_memories");
        if (isBossMenory) {
            if (canActuallyCraft) {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_success", "succeed_crafting_boss_memory");
            } else {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_fail", "fail_to_craft_boss_memory");
            }
        }
        if (spiritInstillerRecipe.comp_1932().equals((Object)SpectrumAdvancements.JADE_VINE_CROSSBREEDING)) {
            Support.grantAdvancementCriterion(player, "lategame/create_jade_vine", "crossbred_jade_vine_bulb");
        }
    }

    public static void craftSpiritInstillerRecipe(class_1937 world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, @NotNull class_8786<SpiritInstillerRecipe> spiritInstillerRecipe) {
        class_1799 resultStack = ((SpiritInstillerRecipe)spiritInstillerRecipe.comp_1933()).assemble(spiritInstillerBlockEntity.getRecipeInput(), (class_7225.class_7874)world.method_30349());
        SpiritInstillerBlockEntity.decrementItemsInInstillerAndBowls(spiritInstillerBlockEntity);
        if (!resultStack.method_7960()) {
            if (spiritInstillerBlockEntity.method_5438(0).method_7960()) {
                spiritInstillerBlockEntity.method_5447(0, resultStack);
            } else {
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, spiritInstillerBlockEntity.field_11867, resultStack, resultStack.method_7947(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
            }
        }
        SpiritInstillerBlockEntity.playCraftingFinishedEffects(spiritInstillerBlockEntity);
        spiritInstillerBlockEntity.craftingTime = 0;
        spiritInstillerBlockEntity.inventoryChanged();
    }

    public static void decrementItemsInInstillerAndBowls(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        class_1937 world = spiritInstillerBlockEntity.method_10997();
        if (world == null) {
            return;
        }
        class_8786<SpiritInstillerRecipe> recipe = spiritInstillerBlockEntity.currentRecipe;
        double efficiencyModifier = 1.0;
        if (!((SpiritInstillerRecipe)recipe.comp_1933()).areYieldAndEfficiencyUpgradesDisabled() && (double)spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
            efficiencyModifier = 1.0 / (double)spiritInstillerBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
        }
        class_2586 leftBowlBlockEntity = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
        class_2586 rightBowlBlockEntity = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
        if (leftBowlBlockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity leftBowl = (ItemBowlBlockEntity)leftBowlBlockEntity;
            if (rightBowlBlockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity rightBowl = (ItemBowlBlockEntity)rightBowlBlockEntity;
                int decreasedAmountAfterEfficiencyMod = Support.getIntFromDecimalWithChance((double)((SpiritInstillerRecipe)recipe.comp_1933()).getIngredientStacks().get(0).getCount() * efficiencyModifier, world.field_9229);
                if (decreasedAmountAfterEfficiencyMod > 0) {
                    spiritInstillerBlockEntity.method_5438(0).method_7934(decreasedAmountAfterEfficiencyMod);
                }
                List<IngredientStack> ingredientStacks = ((SpiritInstillerRecipe)recipe.comp_1933()).getIngredientStacks();
                int amountAfterEfficiencyModFirst = Support.getIntFromDecimalWithChance((double)ingredientStacks.get(1).getCount() * efficiencyModifier, world.field_9229);
                int amountAfterEfficiencyModSecond = Support.getIntFromDecimalWithChance((double)ingredientStacks.get(2).getCount() * efficiencyModifier, world.field_9229);
                boolean leftIsFirstIngredient = ingredientStacks.get(1).test(leftBowl.method_5438(0));
                class_243 particlePos = new class_243((double)spiritInstillerBlockEntity.field_11867.method_10263() + 0.5, (double)(spiritInstillerBlockEntity.field_11867.method_10264() + 1), (double)spiritInstillerBlockEntity.field_11867.method_10260() + 0.5);
                if (leftIsFirstIngredient) {
                    if (amountAfterEfficiencyModFirst > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                } else {
                    if (amountAfterEfficiencyModFirst > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                }
            }
        }
    }

    public static void playCraftingFinishedEffects(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        class_1937 world = spiritInstillerBlockEntity.method_10997();
        if (world == null) {
            return;
        }
        world.method_8396(null, spiritInstillerBlockEntity.field_11867, SpectrumSoundEvents.SPIRIT_INSTILLER_CRAFTING_FINISHED, class_3419.field_15245, 1.0f, 1.0f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, new class_243((double)spiritInstillerBlockEntity.field_11867.method_10263() + 0.5, (double)spiritInstillerBlockEntity.field_11867.method_10264() + 0.5, (double)spiritInstillerBlockEntity.field_11867.method_10260() + 0.5), ColoredCraftingParticleEffect.LIGHT_BLUE, 75, new class_243(0.5, 0.5, 0.5), new class_243(0.1, -0.1, 0.1));
    }

    public void setValidStructure(boolean validStructure) {
        if (!this.field_11863.method_8608()) {
            this.validStructure = validStructure;
            this.method_5431();
            this.updateInClientWorld();
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.craftingTime = nbt.method_10568("CraftingTime");
        this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.inventoryChanged = true;
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.validStructure = nbt.method_10577("validStructure");
        if (nbt.method_10545("MultiblockRotation")) {
            try {
                this.multiblockRotation = class_2470.valueOf((String)nbt.method_10558("MultiblockRotation").toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.multiblockRotation = class_2470.field_11467;
            }
        }
        if (nbt.method_10545("platformSpin")) {
            this.platform = nbt.method_10583("platformSpin");
        }
        this.currentRecipe = MultiblockCrafter.getRecipeHolderFromNbt(this.field_11863, nbt, SpiritInstillerRecipe.class);
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbt.method_10582("MultiblockRotation", this.multiblockRotation.toString());
        nbt.method_10556("validStructure", this.validStructure);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        if (this.platform != 0.0f) {
            nbt.method_10548("platformSpin", this.platform);
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.comp_1932().toString());
        }
    }

    private void doChimeParticles(@NotNull class_1937 world) {
        this.doChimeInstillingParticles(world, this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(false).method_30930(3)));
        this.doChimeInstillingParticles(world, this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(true).method_30930(3)));
    }

    public void doChimeInstillingParticles(@NotNull class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof GemstoneChimeBlock) {
            GemstoneChimeBlock gemstoneChimeBlock = (GemstoneChimeBlock)class_22482;
            class_5819 random = world.field_9229;
            class_2394 particleEffect = gemstoneChimeBlock.getParticleEffect();
            for (int i = 0; i < 12; ++i) {
                world.method_8406(particleEffect, (double)pos.method_10263() + 0.25 + random.method_43058() * 0.5, (double)pos.method_10264() + 0.15 + random.method_43058() * 0.5, (double)pos.method_10260() + 0.25 + random.method_43058() * 0.5, 0.06 - random.method_43058() * 0.12, -0.1 - random.method_43058() * 0.05, 0.06 - random.method_43058() * 0.12);
            }
        }
    }

    private void doItemBowlOrbs(@NotNull class_1937 world) {
        ItemBowlBlockEntity itemBowlBlockEntity;
        class_2338 itemBowlPos = this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(false).method_30931());
        class_2586 blockEntity = world.method_8321(itemBowlPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0 + (double)platformPos.at(0.0f, world.method_8510()).floatValue() / 16.0, (double)this.field_11867.method_10260() + 0.5));
        }
        if ((blockEntity = world.method_8321(itemBowlPos = this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(true).method_30931()))) instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0 + (double)platformPos.at(0.0f, world.method_8510()).floatValue() / 16.0, (double)this.field_11867.method_10260() + 0.5));
        }
    }

    public class_2382 getItemBowlHorizontalPositionOffset(boolean right) {
        if (this.multiblockRotation == class_2470.field_11467 || this.multiblockRotation == class_2470.field_11464) {
            return itemBowlOffsetsVertical.get(right ? 1 : 0);
        }
        return itemBowlOffsetsHorizontal.get(right ? 1 : 0);
    }

    public InstanceRecipeInput<SpiritInstillerBlockEntity> getRecipeInput() {
        return new InstanceRecipeInput<SpiritInstillerBlockEntity>((List<class_1799>)this.items, this);
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods2(this.field_11863, this.field_11867, this.multiblockRotation, 4, 1, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    public class_2470 getMultiblockRotation() {
        return this.multiblockRotation;
    }

    public void setMultiblockRotation(class_2470 blockRotation) {
        this.multiblockRotation = blockRotation;
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void inventoryChanged() {
        this.inventoryChanged = true;
        super.inventoryChanged();
    }

    static {
        platformPos = (tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta + 15.0f) / 23.0f) + 6.0) * 2.0f);
        itemBowlOffsetsHorizontal = new ArrayList<class_2382>(){
            {
                this.add(new class_2382(0, 0, 2));
                this.add(new class_2382(0, 0, -2));
            }
        };
        itemBowlOffsetsVertical = new ArrayList<class_2382>(){
            {
                this.add(new class_2382(2, 0, 0));
                this.add(new class_2382(-2, 0, 0));
            }
        };
        FlowAnimator.Builder<SpiritInstillerBlockEntity> builder = new FlowAnimator.Builder<SpiritInstillerBlockEntity>(SpiritInstillerBlockEntity.class);
        builder.stateInfo(FlowStates.MB_INVALID, 11);
        builder.stateInfo(FlowStates.INACTIVE, 27);
        builder.stateInfo(FlowStates.IDLE, 17);
        builder.stateInfo(FlowStates.ACTIVE, 17);
        builder.handle("platformY", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.EASE_OUT).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates((tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta + 15.0f) / 23.0f) + 4.0)), FlowStates.IDLE).forStates(platformPos, FlowStates.ACTIVE).push();
        builder.handle("haloY", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.EASE_OUT).startingKeyFrame((tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta) / 23.0f) + 1.0))).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE, FlowStates.IDLE).forStates((tickDelta, time) -> Float.valueOf(platformPos.at(tickDelta, time).floatValue() - 34.5f), FlowStates.ACTIVE).push();
        builder.handle("platformSpin", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates(Float.valueOf(0.25f), FlowStates.IDLE).forStates(Float.valueOf(0.825f), FlowStates.ACTIVE).push();
        builder.handle("haloSpin", FlowHandlers.FLOAT).initial(Float.valueOf(0.15f)).loopback(FlowStates.MB_INVALID, FlowStates.INACTIVE).forStates(Float.valueOf(0.325f), FlowStates.IDLE).forStates(Float.valueOf(0.825f), FlowStates.ACTIVE).push();
        builder.handle("haloAlpha", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).forStates(Float.valueOf(1.0f), FlowStates.INACTIVE, FlowStates.IDLE, FlowStates.ACTIVE).push();
        builder.handle("blossomAlpha", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).interpolate(Interpolation.EASE_OUT).loopback(FlowStates.ACTIVE).forStates(Float.valueOf(1.0f), FlowStates.INACTIVE, FlowStates.IDLE).push();
        FACTORY = builder.build();
    }
}

