/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca.azure_dike;

import de.dafuqs.spectrum.cca.azure_dike.AzureDikeComponent;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class DefaultAzureDikeComponent
implements AzureDikeComponent,
AutoSyncedComponent {
    public static final int BASE_RECHARGE_DELAY_TICKS = 40;
    public static final int BASE_RECHARGE_DELAY_TICKS_AFTER_DAMAGE = 200;
    private final class_1309 provider;
    private float maxProtection = 0.0f;
    private int ticksPerPointOfRecharge = 0;
    private int rechargeDelayTicksAfterGettingHit = 0;
    private float currentProtection = 0.0f;
    private int currentRechargeDelay = 0;

    public DefaultAzureDikeComponent(class_1309 entity) {
        this.provider = entity;
    }

    @Override
    public float getCurrentProtection() {
        return this.currentProtection;
    }

    @Override
    public float getMaxProtection() {
        return this.maxProtection;
    }

    @Override
    public int getTicksPerPointOfRecharge() {
        return this.ticksPerPointOfRecharge;
    }

    @Override
    public int getCurrentRechargeDelay() {
        return this.currentRechargeDelay;
    }

    @Override
    public int getRechargeDelayTicksAfterGettingHit() {
        return this.rechargeDelayTicksAfterGettingHit;
    }

    @Override
    public float absorbDamage(float incomingDamage) {
        this.currentRechargeDelay = this.rechargeDelayTicksAfterGettingHit;
        if (this.currentProtection > 0.0f) {
            float absorbedDamage = Math.min(this.currentProtection, incomingDamage);
            this.currentProtection -= absorbedDamage;
            if (absorbedDamage > 0.0f) {
                AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
                class_1309 class_13092 = this.provider;
                if (class_13092 instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)class_13092;
                    SpectrumAdvancementCriteria.AZURE_DIKE_CHARGE.trigger(serverPlayerEntity, this.currentProtection, this.ticksPerPointOfRecharge, -absorbedDamage);
                }
            }
            return incomingDamage - absorbedDamage;
        }
        return incomingDamage;
    }

    @Override
    public void set(float maxProtection, int rechargeDelayDefault, int fasterRechargeAfterDamageTicks, boolean resetCharge) {
        this.maxProtection = maxProtection;
        this.ticksPerPointOfRecharge = rechargeDelayDefault;
        this.rechargeDelayTicksAfterGettingHit = fasterRechargeAfterDamageTicks;
        this.currentRechargeDelay = this.ticksPerPointOfRecharge;
        this.currentProtection = resetCharge ? 0.0f : Math.min(this.currentProtection, this.maxProtection);
        AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
    }

    public void readFromNbt(class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 wrapperLookup) {
        this.currentProtection = tag.method_10550("protection");
        this.currentRechargeDelay = tag.method_10550("current_recharge_delay");
        this.maxProtection = tag.method_10550("max_protection");
        this.ticksPerPointOfRecharge = tag.method_10550("recharge_delay_default");
        this.rechargeDelayTicksAfterGettingHit = tag.method_10550("recharge_delay_after_damage");
    }

    public void writeToNbt(class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 wrapperLookup) {
        tag.method_10548("protection", this.currentProtection);
        tag.method_10569("current_recharge_delay", this.currentRechargeDelay);
        tag.method_10548("max_protection", this.maxProtection);
        tag.method_10569("recharge_delay_default", this.ticksPerPointOfRecharge);
        tag.method_10569("recharge_delay_after_damage", this.rechargeDelayTicksAfterGettingHit);
    }

    public void serverTick() {
        if (this.currentRechargeDelay > 0) {
            --this.currentRechargeDelay;
        } else if (this.currentProtection < this.maxProtection) {
            this.currentProtection = Math.min(this.maxProtection, this.currentProtection + 1.0f);
            this.currentRechargeDelay = this.ticksPerPointOfRecharge;
            AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
            class_1309 class_13092 = this.provider;
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)class_13092;
                SpectrumAdvancementCriteria.AZURE_DIKE_CHARGE.trigger(serverPlayerEntity, this.currentProtection, this.ticksPerPointOfRecharge, 1.0f);
            }
        }
    }
}

