/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.modonomicon.pages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookCollectionPage
extends BookTextPage {
    private final List<class_1799> items;

    public BookCollectionPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, List<class_1799> stacks) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.items = stacks;
    }

    public static BookCollectionPage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (class_7225.class_7874)provider);
        boolean useMarkdownInTitle = class_3518.method_15258((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = class_3518.method_15258((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (class_7225.class_7874)provider);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((class_2960)entryId, (JsonObject)json.getAsJsonObject("condition"), (class_7225.class_7874)provider) : new BookNoneCondition();
        List<JsonObject> items = class_3518.method_15292((JsonObject)json, (String)"items", (JsonArray)new JsonArray()).asList().stream().map(JsonElement::getAsJsonObject).toList();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (JsonObject obj : items) {
            try {
                stacks.add((class_1799)class_1799.field_24671.parse((DynamicOps)provider.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)obj).getOrThrow());
            }
            catch (Exception e) {
                SpectrumCommon.logError("Failed parsing item entry " + obj.toString() + " in modonomicon page " + String.valueOf(entryId));
                e.printStackTrace();
            }
        }
        return new BookCollectionPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, stacks);
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public class_2960 getType() {
        return ModonomiconCompat.COLLECTION_PAGE;
    }

    public void toNetwork(class_9129 buffer) {
        super.toNetwork(buffer);
        class_1799.field_48350.encode((Object)buffer, this.items);
    }

    public static BookCollectionPage fromNetwork(class_9129 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((class_9129)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((class_9129)buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork((class_9129)buffer);
        List items = (List)class_1799.field_48350.decode((Object)buffer);
        return new BookCollectionPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, items);
    }

    public boolean matchesQuery(String query) {
        return super.matchesQuery(query) || this.items.stream().map(class_1799::method_7922).map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).map(String::toLowerCase).anyMatch(string -> string.contains(query));
    }
}

