/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.starry_skies.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.blocks.FluidLogging;
import de.dafuqs.spectrum.blocks.conditional.QuitoxicReedsBlock;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereDecoratorConfig;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class QuitoxicReedsPondDecorator
extends SphereDecorator<SphereDecoratorConfig.DefaultSphereDecoratorConfig> {
    private static final float QUITOXIC_REEDS_CHANCE = 0.25f;

    public QuitoxicReedsPondDecorator(Codec<SphereDecoratorConfig.DefaultSphereDecoratorConfig> codec) {
        super(codec);
    }

    public boolean generate(SphereFeatureContext<SphereDecoratorConfig.DefaultSphereDecoratorConfig> context) {
        class_5281 world = context.getWorld();
        PlacedSphere sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        if (!sphere.isCenterInChunk(origin)) {
            return false;
        }
        if (sphere.getRadius() > 9) {
            int pondRadius = (int)((double)sphere.getRadius() / 2.5);
            class_2338 spherePos = sphere.getPosition();
            class_2338 sphereTop = spherePos.method_10086(sphere.getRadius() + 1);
            int waterLevelY = this.determineWaterY(world, sphereTop, pondRadius);
            if ((double)(waterLevelY - sphere.getPosition().method_10264()) < (double)pondRadius * 1.5) {
                return false;
            }
            class_2680 water = class_2246.field_10382.method_9564();
            class_2680 air = class_2246.field_10124.method_9564();
            class_2680 clay = class_2246.field_10460.method_9564();
            class_2680 quitoxic = SpectrumBlocks.QUITOXIC_REEDS.method_9564();
            class_2680 quitoxicWater = (class_2680)quitoxic.method_11657(QuitoxicReedsBlock.LOGGED, (Comparable)((Object)FluidLogging.State.WATER));
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int pond15 = (int)Math.round((double)pondRadius * 1.5);
            for (int x = -pond15; x <= pond15; ++x) {
                for (int z = -pond15; z <= pond15; ++z) {
                    mutable.method_10103(spherePos.method_10263() + x, waterLevelY, spherePos.method_10260() + z);
                    double distance = Support.getDistance((class_2338)mutable, (class_2338)sphereTop);
                    if (distance > (double)pond15) continue;
                    if (distance < (double)(pond15 - 1) && random.method_43057() < 0.25f) {
                        int quitoxicHeight = random.method_43048(5);
                        int setBlockHeight = Math.max(waterLevelY + quitoxicHeight, sphereTop.method_10264());
                        mutable.method_10103(spherePos.method_10263() + x, waterLevelY, spherePos.method_10260() + z);
                        world.method_8652((class_2338)mutable, quitoxicWater, 3);
                        for (int y = waterLevelY + 1; y < setBlockHeight; ++y) {
                            mutable.method_10103(spherePos.method_10263() + x, y, spherePos.method_10260() + z);
                            world.method_8652((class_2338)mutable, quitoxic, 3);
                        }
                    } else {
                        world.method_8652((class_2338)mutable, water, 3);
                        for (int y = waterLevelY + 1; y < sphereTop.method_10264(); ++y) {
                            mutable.method_10103(spherePos.method_10263() + x, y, spherePos.method_10260() + z);
                            world.method_8652((class_2338)mutable, air, 3);
                        }
                    }
                    mutable.method_10103(spherePos.method_10263() + x, waterLevelY - 1, spherePos.method_10260() + z);
                    world.method_8652((class_2338)mutable, clay, 3);
                }
            }
        }
        return true;
    }

    public int determineWaterY(class_5281 world, class_2338 sphereTop, int pondRadius) {
        for (int x = -pondRadius - 1; x <= pondRadius; ++x) {
            for (int y = -pondRadius; y < 1; ++y) {
                for (int z = -pondRadius - 1; z <= pondRadius; ++z) {
                    class_2338 currentBlockPos = sphereTop.method_10069(x, y, z);
                    if (!world.method_8320(currentBlockPos).method_26215()) continue;
                    return currentBlockPos.method_10264() - 1;
                }
            }
        }
        return sphereTop.method_10264();
    }
}

