/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders.resonance_processors;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.interaction.ResonanceProcessor;
import de.dafuqs.spectrum.api.predicate.block.BrokenBlockPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2246;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class ModifyDropsResonanceProcessor
extends ResonanceProcessor {
    public static final MapCodec<ModifyDropsResonanceProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BrokenBlockPredicate.CODEC.fieldOf("block").validate(block -> block.test(class_2246.field_10124.method_9564()) ? DataResult.error(() -> "Registering a Resonance Drop that matches on everything!") : DataResult.success((Object)block)).forGetter(c -> c.blockPredicate), (App)Codec.mapPair((MapCodec)class_1856.field_46096.fieldOf("input"), (MapCodec)class_7923.field_41178.method_39673().fieldOf("output")).codec().listOf().xmap(pairs -> pairs.stream().collect(() -> new HashMap(), (map, pair) -> map.put((class_1856)pair.getFirst(), (class_1792)pair.getSecond()), (map1, map2) -> map1.putAll(map2)), map -> map.entrySet().stream().map(entry -> new Pair((Object)((class_1856)entry.getKey()), (Object)((class_1792)entry.getValue()))).toList()).optionalFieldOf("modify_drops", Map.of()).forGetter(c -> c.modifiedDrops)).apply((Applicative)i, ModifyDropsResonanceProcessor::new));
    public Map<class_1856, class_1792> modifiedDrops;

    public ModifyDropsResonanceProcessor(BrokenBlockPredicate blockTarget, Map<class_1856, class_1792> modifiedDrops) {
        super(blockTarget);
        this.modifiedDrops = modifiedDrops;
    }

    @Override
    public boolean process(class_2680 state, class_2586 blockEntity, List<class_1799> droppedStacks) {
        if (this.blockPredicate.test(state)) {
            this.modifyDrops(droppedStacks);
            return true;
        }
        return false;
    }

    private void modifyDrops(List<class_1799> droppedStacks) {
        block0: for (class_1799 stack : droppedStacks) {
            for (Map.Entry<class_1856, class_1792> modifiedDrop : this.modifiedDrops.entrySet()) {
                if (!modifiedDrop.getKey().method_8093(stack)) continue;
                class_1799 convertedStack = modifiedDrop.getValue().method_7854();
                convertedStack.method_7939(stack.method_7947());
                droppedStacks.remove(stack);
                droppedStacks.add(convertedStack);
                continue block0;
            }
        }
    }

    @Override
    public MapCodec<? extends ResonanceProcessor> getCodec() {
        return CODEC;
    }

    public static Builder builder(BrokenBlockPredicate blockTarget) {
        return new Builder(blockTarget);
    }

    public static class Builder {
        private final BrokenBlockPredicate blockTarget;
        private final List<Map.Entry<class_1856, class_1792>> modifiedDrops = new ArrayList<Map.Entry<class_1856, class_1792>>();

        private Builder(BrokenBlockPredicate blockTarget) {
            this.blockTarget = blockTarget;
        }

        public Builder addModifiedDrop(class_1856 ingredient, class_1792 item) {
            this.modifiedDrops.add(Map.entry(ingredient, item));
            return this;
        }

        public ModifyDropsResonanceProcessor build() {
            return new ModifyDropsResonanceProcessor(this.blockTarget, (Map<class_1856, class_1792>)ImmutableMap.copyOf(this.modifiedDrops));
        }
    }
}

