/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.deeper_down;

import com.google.common.collect.ImmutableMap;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SleepStatusEffect;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class DimensionRenderEffects {
    public static final float INTERP_TICKS = 80.0f;
    public static final float[] FOG_DISTANCE_DEFAULT = new float[]{-2.25f, 1.5f};
    private static final Map<class_5321<class_1959>, Float> DARKENING_MULTIPLIERS;
    private static final Map<class_5321<class_1959>, Float> FOG_DARKENING_MULTIPLIERS;
    private static final Map<class_5321<class_1959>, float[]> FOG_DISTANCE_MULTIPLIERS;
    private static final Map<class_5321<class_1959>, ColorGrading> COLOR_GRADING_DATA;
    private static final ColorGrading DEFAULT;
    private static final InterpolationQueue<float[]> GRADING_QUEUE;
    public static boolean isInDarkenedBiome;
    public static boolean sleepAfflicted;
    public static boolean forceFogEffects;
    public static int darkenTicks;
    public static int darken;
    public static int lastDarkenTicks;
    public static int interpInterpTicks;
    public static float interpTarget;
    public static float interp;
    public static float lastInterpTarget;
    public static float fogTarget;
    public static float fogDarkness;
    public static float lastFogTarget;
    public static float nearTarget;
    public static float near;
    public static float lastNearTarget;
    public static float farTarget;
    public static float far;
    public static float lastFarTarget;
    public static float redTarget;
    public static float red;
    public static float lastRedTarget;
    public static float greenTarget;
    public static float green;
    public static float lastGreenTarget;
    public static float blueTarget;
    public static float blue;
    public static float lastBlueTarget;
    public static float blendTarget;
    public static float blend;
    public static float lastBlendTarget;
    private static class_6880<class_1959> currentBiome;
    private static final class_310 client;
    private static boolean shouldUpdate;
    private static boolean forceBiomeUpdate;

    public static void clientTick(class_638 world, class_1297 entity, class_6880<class_1959> biome) {
        if (client.method_1493()) {
            return;
        }
        lastDarkenTicks = darkenTicks;
        float sleepPotency = -1.0f;
        class_6880<class_1291> sleepEffect = null;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            sleepPotency = SleepStatusEffect.getSleepScaling(livingEntity);
            sleepEffect = SleepStatusEffect.getStrongestSleepEffect(livingEntity);
        }
        if (shouldUpdate) {
            float targets = class_3532.method_15363((float)(sleepPotency / 2.0f), (float)0.0f, (float)1.0f);
            interpInterpTicks = 0;
            shouldUpdate = false;
            DimensionRenderEffects.updateTargets();
            if (sleepEffect == SpectrumStatusEffects.FATAL_SLUMBER) {
                sleepAfflicted = true;
                blendTarget = 1.0f;
                interpTarget = 1.0f;
                redTarget = 0.05490196f;
                greenTarget = 0.015686275f;
                blueTarget = 0.105882354f;
                nearTarget = -10.0f;
                farTarget = 0.25f;
                forceFogEffects = true;
            } else if (sleepEffect == SpectrumStatusEffects.ETERNAL_SLUMBER) {
                sleepAfflicted = true;
                blendTarget = targets;
                interpTarget = targets;
                redTarget = 0.28627452f;
                greenTarget = 0.14117648f;
                blueTarget = 0.4509804f;
                nearTarget = -2.0f;
                farTarget = 0.9f;
                forceFogEffects = true;
            } else if (sleepEffect == SpectrumStatusEffects.SOMNOLENCE) {
                sleepAfflicted = true;
                blendTarget = targets;
                interpTarget = targets;
                redTarget = 0.7647059f;
                greenTarget = 0.37254903f;
                blueTarget = 0.93333334f;
                nearTarget = -5.0f;
                forceFogEffects = true;
            } else {
                sleepAfflicted = false;
                blendTarget = 0.0f;
                redTarget = 0.0f;
                greenTarget = 0.0f;
                blueTarget = 0.0f;
                currentBiome = null;
                forceFogEffects = false;
                forceBiomeUpdate = true;
            }
        } else if (currentBiome == null || !currentBiome.method_40230().equals(biome.method_40230())) {
            if (forceBiomeUpdate) {
                forceBiomeUpdate = false;
            }
            class_5321 biomeKey = biome.method_40230().orElse(null);
            currentBiome = biome;
            DimensionRenderEffects.updateTargets();
            interpTarget = DARKENING_MULTIPLIERS.getOrDefault(biomeKey, Float.valueOf(0.0f)).floatValue();
            fogTarget = FOG_DARKENING_MULTIPLIERS.getOrDefault(biomeKey, Float.valueOf(1.0f)).floatValue();
            float[] targets = FOG_DISTANCE_MULTIPLIERS.getOrDefault(biomeKey, FOG_DISTANCE_DEFAULT);
            nearTarget = targets[0];
            farTarget = targets[1];
            if (GRADING_QUEUE.ready()) {
                GRADING_QUEUE.set(COLOR_GRADING_DATA.getOrDefault(biomeKey, DEFAULT).asArray(), (float[])ColorGrading.GRADING_OUT.clone());
            } else {
                GRADING_QUEUE.accept(COLOR_GRADING_DATA.getOrDefault(biomeKey, DEFAULT).asArray());
            }
            interpInterpTicks = 0;
        }
        if ((float)interpInterpTicks < 80.0f) {
            ++interpInterpTicks;
        }
        float delta = (float)interpInterpTicks / 80.0f;
        interp = class_3532.method_16439((float)delta, (float)lastInterpTarget, (float)interpTarget);
        fogDarkness = class_3532.method_16439((float)delta, (float)lastFogTarget, (float)fogTarget);
        near = class_3532.method_16439((float)delta, (float)lastNearTarget, (float)nearTarget);
        far = class_3532.method_16439((float)delta, (float)lastFarTarget, (float)farTarget);
        red = class_3532.method_16439((float)delta, (float)lastRedTarget, (float)redTarget);
        green = class_3532.method_16439((float)delta, (float)lastGreenTarget, (float)greenTarget);
        blue = class_3532.method_16439((float)delta, (float)lastBlueTarget, (float)blueTarget);
        blend = class_3532.method_16439((float)delta, (float)lastBlendTarget, (float)blendTarget);
        if (GRADING_QUEUE.ready()) {
            ColorGrading.update((float[])DimensionRenderEffects.GRADING_QUEUE.last, (float[])DimensionRenderEffects.GRADING_QUEUE.current, delta);
        }
        if ((isInDarkenedBiome = DARKENING_MULTIPLIERS.containsKey(biome.method_40230().orElse(null))) || sleepAfflicted) {
            if ((float)darkenTicks < 80.0f) {
                ++darkenTicks;
            } else if ((float)darkenTicks > 80.0f) {
                --darkenTicks;
            }
        } else if (darkenTicks > 0) {
            --darkenTicks;
        }
    }

    private static void updateTargets() {
        lastInterpTarget = interp;
        lastFogTarget = fogDarkness;
        lastNearTarget = near;
        lastFarTarget = far;
        lastRedTarget = red;
        lastGreenTarget = green;
        lastBlueTarget = blue;
        lastBlendTarget = blend;
    }

    public static void markForEffectUpdate() {
        shouldUpdate = true;
    }

    public static float getInterp() {
        if (DimensionRenderEffects.client.field_1719 == null) {
            return interp;
        }
        double y = class_3532.method_16436((double)client.method_60646().method_60637(false), (double)DimensionRenderEffects.client.field_1719.field_5971, (double)DimensionRenderEffects.client.field_1719.method_23318());
        float adjustedInterp = y > -116.0 ? (float)class_3532.method_15390((double)0.175f, (double)interp, (double)((y + 64.0) / -52.0)) : (y < -256.0 ? (float)Math.max((double)interp, Math.min((double)0.825f, (double)interp + (y + 256.0) / -256.0)) : interp);
        return adjustedInterp;
    }

    public static float getNear(float start) {
        if (DimensionRenderEffects.client.field_1719 == null) {
            return near;
        }
        double y = class_3532.method_16436((double)client.method_60646().method_60637(false), (double)DimensionRenderEffects.client.field_1719.field_5971, (double)DimensionRenderEffects.client.field_1719.method_23318());
        float distance = y < -270.0 ? (float)class_3532.method_15390((double)1.0, (double)0.667f, (double)((y + 270.0) / -12.0)) * near : near;
        return distance * start;
    }

    public static float getFar(float end) {
        if (DimensionRenderEffects.client.field_1719 == null) {
            return far;
        }
        return far * end;
    }

    public static float getDarknessInterpolation() {
        return class_3532.method_16439((float)class_310.method_1551().method_60646().method_60637(false), (float)darkenTicks, (float)lastDarkenTicks) / 80.0f * DimensionRenderEffects.getInterp();
    }

    static {
        DEFAULT = new ColorGrading(1.0f, 0.0f, 65.0f, 0.85f, 0.35f);
        GRADING_QUEUE = new InterpolationQueue();
        fogTarget = 1.0f;
        fogDarkness = 1.0f;
        lastFogTarget = 1.0f;
        nearTarget = 1.0f;
        near = 1.0f;
        lastNearTarget = 1.0f;
        farTarget = 1.0f;
        far = 1.0f;
        lastFarTarget = 1.0f;
        client = class_310.method_1551();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(SpectrumBiomes.BLACK_LANGAST, (Object)Float.valueOf(0.4f));
        builder.put(SpectrumBiomes.DEEP_BARRENS, (Object)Float.valueOf(0.25f));
        builder.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)Float.valueOf(0.1f));
        builder.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)Float.valueOf(0.05f));
        DARKENING_MULTIPLIERS = builder.build();
        ImmutableMap.Builder fogBuilder = ImmutableMap.builder();
        fogBuilder.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)Float.valueOf(0.125f));
        fogBuilder.put(SpectrumBiomes.RAZOR_EDGE, (Object)Float.valueOf(0.65f));
        fogBuilder.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)Float.valueOf(0.25f));
        fogBuilder.put(SpectrumBiomes.DEEP_BARRENS, (Object)Float.valueOf(0.55f));
        fogBuilder.put(SpectrumBiomes.BLACK_LANGAST, (Object)Float.valueOf(0.0125f));
        FOG_DARKENING_MULTIPLIERS = fogBuilder.build();
        ImmutableMap.Builder transMultiplier = ImmutableMap.builder();
        transMultiplier.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)new float[]{-3.0f, 1.5f});
        transMultiplier.put(SpectrumBiomes.HOWLING_SPIRES, (Object)new float[]{-5.25f, 1.25f});
        transMultiplier.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)new float[]{-4.0f, 1.5f});
        transMultiplier.put(SpectrumBiomes.DEEP_BARRENS, (Object)new float[]{-5.0f, 0.5f});
        transMultiplier.put(SpectrumBiomes.BLACK_LANGAST, (Object)new float[]{-8.0f, 0.5f});
        transMultiplier.put(SpectrumBiomes.DRAGONROT_SWAMP, (Object)new float[]{-4.0f, 1.0f});
        FOG_DISTANCE_MULTIPLIERS = transMultiplier.build();
        ImmutableMap.Builder colorGradingBuilder = ImmutableMap.builder();
        colorGradingBuilder.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)new ColorGrading(1.05f, 0.015f, 80.0f, 0.7f, 0.3125f));
        colorGradingBuilder.put(SpectrumBiomes.HOWLING_SPIRES, (Object)new ColorGrading(1.0f, 0.0f, 60.0f, 0.9f, 0.425f));
        colorGradingBuilder.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)new ColorGrading(1.0f, 0.02f, 60.0f, 0.8f, 0.3f));
        colorGradingBuilder.put(SpectrumBiomes.DEEP_BARRENS, (Object)new ColorGrading(0.5f, 0.0f, 55.0f, 0.7f, 0.2f));
        colorGradingBuilder.put(SpectrumBiomes.BLACK_LANGAST, (Object)new ColorGrading(0.5f, 0.0f, 60.0f, 1.0f, 0.1f));
        colorGradingBuilder.put(SpectrumBiomes.DRAGONROT_SWAMP, (Object)new ColorGrading(0.7f, 0.05f, 105.0f, 0.75f, 0.3f));
        COLOR_GRADING_DATA = colorGradingBuilder.build();
    }

    private static class InterpolationQueue<T> {
        private T current;
        private T last;

        private InterpolationQueue() {
        }

        public void accept(T newHead) {
            if (!this.ready()) {
                this.initialize(newHead);
                return;
            }
            this.current = newHead;
        }

        public void set(T current, T last) {
            this.accept(current);
            this.last = last;
        }

        public void initialize(T value) {
            this.last = value;
            this.current = value;
        }

        public boolean ready() {
            return this.current != null && this.last != null;
        }
    }

    public record ColorGrading(float saturation, float rubedo, float colorTemperature, float threshold, float bloom) {
        public static final float[] GRADING_OUT = new float[5];

        private static void update(float[] old, float[] current, float delta) {
            for (int i = 0; i < 5; ++i) {
                ColorGrading.GRADING_OUT[i] = class_3532.method_16439((float)delta, (float)old[i], (float)current[i]);
            }
        }

        private float[] asArray() {
            return new float[]{this.saturation, this.rubedo, this.colorTemperature, this.threshold, this.bloom};
        }
    }
}

