/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.api.item.SlotReservingItem;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.BidentBaseEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.DragonTalonItem;
import de.dafuqs.spectrum.mixin.accessors.PersistentProjectileEntityAccessor;
import de.dafuqs.spectrum.mixin.accessors.TridentEntityAccessor;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class DragonTalonEntity
extends BidentBaseEntity {
    private static final class_2940<Boolean> HIT = class_2945.method_12791(DragonTalonEntity.class, (class_2941)class_2943.field_13323);

    public DragonTalonEntity(class_1937 world) {
        this(SpectrumEntityTypes.DRAGON_TALON, world);
    }

    public DragonTalonEntity(class_1299<? extends class_1685> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_2338 pos = blockHitResult.method_17777();
        class_2680 state = this.method_37908().method_8320(pos);
        if (state.method_27852(class_2246.field_10030) && this.method_18798().method_1027() > 1.0) {
            switch (blockHitResult.method_17780().method_10166()) {
                case field_11048: {
                    this.method_18799(this.method_18798().method_18805(-1.0, 1.0, 1.0));
                    break;
                }
                case field_11052: {
                    this.method_18799(this.method_18798().method_18805(1.0, -1.0, 1.0));
                    break;
                }
                case field_11051: {
                    this.method_18799(this.method_18798().method_18805(1.0, 1.0, -1.0));
                }
            }
            this.method_5783(SpectrumSoundEvents.METAL_HIT, 1.0f, 1.5f);
            return;
        }
        super.method_24920(blockHitResult);
        if (((Boolean)this.field_6011.method_12789(HIT)).booleanValue() || this.method_7441()) {
            return;
        }
        this.field_6011.method_12778(HIT, (Object)true);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_3218 serverWorld;
        class_1799 stack = this.getTrackedStack();
        class_1297 attacked = entityHitResult.method_17782();
        if (attacked.method_5864() == class_1299.field_6091) {
            return;
        }
        class_1297 owner = this.method_24921();
        float damage = 2.0f;
        class_1282 damageSource = SpectrumDamageTypes.impaling(this.method_37908(), (class_1297)this, owner);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            damage *= class_1890.method_60120((class_3218)serverWorld, (class_1799)stack, (class_1297)attacked, (class_1282)damageSource, (float)this.getDamage(stack));
        }
        if (attacked.method_5643(damageSource, damage)) {
            class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                serverWorld = (class_3218)class_19372;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)attacked, (class_1282)damageSource, (class_1799)stack);
            }
            if (attacked instanceof class_1309) {
                class_1309 livingAttacked = (class_1309)attacked;
                this.method_7450(livingAttacked);
            }
        }
        ((TridentEntityAccessor)((Object)this)).spectrum$setDealtDamage(true);
        this.recall();
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        float g = 1.0f;
        this.method_5783(SpectrumSoundEvents.IMPALING_HIT, g, 1.0f);
    }

    private float getDamage(class_1799 stack) {
        MutableDouble damage = new MutableDouble(0.0);
        class_5321 key = class_5134.field_23721.method_40230().orElse(null);
        double base = ((class_1320)class_5134.field_23721.comp_349()).method_6169();
        class_9285 modifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        modifiers.method_57482(class_1304.field_6173, (attribute, modifier) -> {
            if (attribute.method_40225(key)) {
                double value = modifier.comp_2449();
                damage.addAndGet(switch (modifier.comp_2450()) {
                    default -> throw new MatchException(null, null);
                    case class_1322.class_1323.field_6328 -> value;
                    case class_1322.class_1323.field_6330 -> value * base;
                    case class_1322.class_1323.field_6331 -> value * damage.getValue();
                });
            }
        });
        return damage.getValue().floatValue();
    }

    protected void method_7450(class_1309 target) {
        if (this.method_24921() == null) {
            return;
        }
        class_1297 owner = this.method_24921();
        float difMod = 4.0f;
        boolean airborne = !owner.method_24828();
        boolean sneaking = owner.method_5715();
        int inertia = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)owner.method_37908().method_30349(), SpectrumEnchantments.INERTIA, this.getTrackedStack());
        if (sneaking) {
            difMod *= 3.0f;
        }
        if (airborne) {
            difMod /= 2.0f;
        }
        if (inertia > 0) {
            difMod *= (float)inertia * 1.5f + 1.0f;
        }
        float sizeDif = this.getVolumeDif(target, difMod);
        this.yoink((class_1297)target, this.method_24921().method_19538(), 0.25 * (double)sizeDif, 0.175);
        if (airborne) {
            this.yoink(owner, target.method_19538(), 0.125 / (double)sizeDif, 0.16);
        }
    }

    private float getVolumeDif(class_1309 target, float pullMod) {
        if (this.method_24921() == null) {
            return 0.0f;
        }
        class_238 ownerBox = this.method_24921().method_5829();
        class_238 targetBox = target.method_5829();
        float ownerVolume = (float)(ownerBox.method_17939() * ownerBox.method_17940() * ownerBox.method_17941());
        float targetVolume = (float)(targetBox.method_17939() * targetBox.method_17940() * targetBox.method_17941());
        return Math.max(Math.min(ownerVolume / (targetVolume / pullMod), 0.8f), 0.5f);
    }

    public void recall() {
        class_1297 owner = this.method_24921();
        if (((Boolean)this.field_6011.method_12789(HIT)).booleanValue() && !this.method_7441()) {
            this.yoink(owner, this.method_19538(), 0.125, 0.165);
        }
        if (SpectrumEnchantmentHelper.hasEnchantment((class_7225.class_7874)this.method_37908().method_30349(), (class_5321<class_1887>)class_1893.field_9117, this.getTrackedStack()) && owner != null) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                for (int i = 0; i < 10; ++i) {
                    world.method_14199((class_2394)class_2398.field_28479, this.method_23322(1.0), this.method_23318() + (double)(this.method_17682() * this.field_5974.method_43057()), this.method_23325(1.0), 1 + this.field_5974.method_43048(2), 0.0, (double)(this.field_5974.method_43057() + 0.25f), 0.0, 0.0);
                }
                world.method_47967(null, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, SpectrumSoundEvents.ELECTRIC_DISCHARGE, class_3419.field_15256, 1.0f, 0.6f + this.field_5974.method_43057() * 0.2f, 0L);
            }
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        this.method_5841().method_12778(TridentEntityAccessor.spectrum$getLoyalty(), (Object)4);
        this.method_7433(true);
    }

    public void yoink(@Nullable class_1297 yoinked, class_243 target, double xMod, double yMod) {
        if (yoinked == null) {
            return;
        }
        class_243 yPos = yoinked.method_19538();
        double heightDif = Math.abs(yPos.field_1351 - target.field_1351);
        class_243 velocity = target.method_1020(yPos);
        boolean sneaking = yoinked.method_5715();
        float bonusMod = 1.0f;
        if (yoinked instanceof class_1309) {
            class_1309 livingYoink = (class_1309)yoinked;
            bonusMod /= (float)Optional.ofNullable(livingYoink.method_6112(SpectrumStatusEffects.DENSITY)).map(effect -> effect.method_5578() + 2).orElse(1).intValue();
            bonusMod *= Optional.ofNullable(livingYoink.method_6112(SpectrumStatusEffects.LIGHTWEIGHT)).map(effect -> Float.valueOf((float)(effect.method_5578() + 2) / 1.5f)).orElse(Float.valueOf(1.0f)).floatValue();
        }
        if (!yoinked.method_24828()) {
            yMod += 0.05;
            xMod -= 0.015;
        }
        yMod = Math.max(0.0725, yMod * (1.0 - heightDif * 0.024));
        xMod *= (double)bonusMod;
        yMod *= (double)bonusMod;
        if (yoinked == this.method_24921() && yPos.field_1351 > target.field_1351 && !sneaking) {
            yMod = 0.0;
        }
        yoinked.method_18799(velocity.method_18805(xMod, yMod, xMod).method_1031(0.0, sneaking ? 0.0 : 0.25, 0.0));
        yoinked.field_6017 = 0.0f;
        yoinked.field_6037 = true;
        yoinked.field_6007 = true;
    }

    public void method_7446() {
        if (!this.getRootStack().method_7960()) {
            return;
        }
        int life = ((PersistentProjectileEntityAccessor)((Object)this)).getLife() + 1;
        ((PersistentProjectileEntityAccessor)((Object)this)).setLife(life);
        if (life >= 1200) {
            this.method_31472();
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1799 rootStack = this.getRootStack();
        if (!rootStack.method_7960()) {
            SlotReservingItem.free(rootStack);
        }
        super.method_5650(reason);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HIT, (Object)false);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(HIT, (Object)nbt.method_10577("hit"));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("hit", ((Boolean)this.field_6011.method_12789(HIT)).booleanValue());
    }

    private class_1799 getRootStack() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return DragonTalonItem.findThrownStack(player, this.field_6021);
        }
        return class_1799.field_8037;
    }

    protected boolean method_34713(class_1657 player) {
        class_1799 rootStack = DragonTalonItem.findThrownStack(player, this.field_6021);
        if (!rootStack.method_7960()) {
            SlotReservingItem.free(rootStack);
            return true;
        }
        if (player == this.method_24921()) {
            this.method_31472();
        }
        return false;
    }

    @Nullable
    public class_1542 method_5775(class_1799 stack) {
        return null;
    }

    @Nullable
    public class_1542 method_5699(class_1799 stack, float yOffset) {
        return null;
    }
}

