/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.ai.FixedBodyControl;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1427;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_6880;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PreservationTurretEntity
extends class_1427
implements class_1569,
class_8514 {
    protected static final int DETECTION_RANGE = 16;
    protected static final float DAMAGE = 4.0f;
    private static final class_2960 COVERED_ARMOR_BONUS_ID = SpectrumCommon.locate("covered_armor");
    private static final class_2960 COVERED_TOUGHNESS_BONUS_ID = SpectrumCommon.locate("covered_toughness");
    protected static final class_1322 COVERED_ARMOR_BONUS = new class_1322(COVERED_ARMOR_BONUS_ID, 20.0, class_1322.class_1323.field_6328);
    protected static final class_1322 COVERED_TOUGHNESS_BONUS = new class_1322(COVERED_TOUGHNESS_BONUS_ID, 6.0, class_1322.class_1323.field_6328);
    protected static final class_2940<class_2350> ATTACHED_FACE = class_2945.method_12791(PreservationTurretEntity.class, (class_2941)class_2943.field_13321);
    protected static final class_2940<Byte> PEEK_AMOUNT = class_2945.method_12791(PreservationTurretEntity.class, (class_2941)class_2943.field_13319);
    protected static final Vector3f SOUTH_VECTOR = (Vector3f)class_156.method_656(() -> {
        class_2382 vec3i = class_2350.field_11035.method_10163();
        return new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
    });
    protected final class_4051 TARGET_PREDICATE = class_4051.method_36625();
    protected final class_5715<class_8514.class_8516> gameEventHandler = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
    protected final class_8514.class_5719 vibrationCallback = new VibrationsCallback(this);
    protected class_8514.class_8515 vibrationListenerData = new class_8514.class_8515();
    protected float prevOpenProgress;
    protected float openProgress;
    @Nullable
    protected class_2338 prevAttachedBlock;

    public PreservationTurretEntity(class_1299<? extends PreservationTurretEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 12;
        this.field_6206 = new TurretLookControl((class_1308)this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new RatatatataGoal());
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f, 0.04f, true));
    }

    public boolean method_6049(class_1293 effect) {
        if (effect.method_5579().method_40220(SpectrumStatusEffectTags.SOPORIFIC)) {
            return false;
        }
        return super.method_6049(effect);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected class_3414 method_5994() {
        return SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_AMBIENT;
    }

    protected class_3414 method_6002() {
        return SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.isClosed() ? SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_HURT_CLOSED : SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_HURT;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACHED_FACE, (Object)class_2350.field_11033);
        builder.method_56912(PEEK_AMOUNT, (Object)0);
    }

    public static class_5132.class_5133 createGuardianTurretAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0);
    }

    protected class_1330 method_5963() {
        return new FixedBodyControl((class_1308)this);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("AttachFace", (byte)this.getAttachedFace().method_10146());
        nbt.method_10567("Peek", ((Byte)this.field_6011.method_12789(PEEK_AMOUNT)).byteValue());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAttachedFace(class_2350.method_10143((int)nbt.method_10571("AttachFace")));
        this.field_6011.method_12778(PEEK_AMOUNT, (Object)nbt.method_10571("Peek"));
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationListenerData;
    }

    public class_8514.class_5719 method_51299() {
        return this.vibrationCallback;
    }

    public void method_5966() {
        if (this.getPeekAmount() > 0) {
            super.method_5966();
        }
    }

    public void method_5773() {
        class_2350 direction;
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_8514.class_8517.method_51406((class_1937)serverWorld, (class_8514.class_8515)this.method_51298(), (class_8514.class_5719)this.method_51299());
        }
        if (!(this.method_37908().method_8608() || this.method_5765() || this.canStay(this.method_24515(), this.getAttachedFace()) || (direction = this.findAttachSide(this.method_24515())) == null)) {
            this.setAttachedFace(direction);
        }
        this.tickOpenProgress();
    }

    public void method_42147(BiConsumer<class_5715<?>, class_3218> callback) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            callback.accept(this.gameEventHandler, serverWorld);
        }
    }

    private void tickOpenProgress() {
        this.prevOpenProgress = this.openProgress;
        float peekAmount = (float)this.getPeekAmount() * 0.01f;
        if (this.openProgress != peekAmount) {
            this.openProgress = this.openProgress > peekAmount ? class_3532.method_15363((float)(this.openProgress - 0.05f), (float)peekAmount, (float)1.0f) : class_3532.method_15363((float)(this.openProgress + 0.05f), (float)0.0f, (float)peekAmount);
        }
    }

    public class_243 method_55668(class_1297 vehicle) {
        if (vehicle.method_5864() != class_1299.field_6121 && vehicle.method_5864() != class_1299.field_6096) {
            return super.method_55668(vehicle);
        }
        class_243 ridingPos = vehicle.method_52538((class_1297)this);
        return new class_243(ridingPos.field_1352, 0.1875 - ridingPos.field_1351, ridingPos.field_1350);
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        if (this.method_37908().method_8608()) {
            this.prevAttachedBlock = null;
        }
        this.setAttachedFace(class_2350.field_11033);
        return super.method_5873(entity, force);
    }

    public void method_5848() {
        super.method_5848();
        if (this.method_37908().method_8608()) {
            this.prevAttachedBlock = this.method_24515();
        }
        this.field_6220 = 0.0f;
        this.field_6283 = 0.0f;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_36456(0.0f);
        this.field_6241 = this.method_36454();
        this.method_22862();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5814(double x, double y, double z) {
        class_2338 blockPos2;
        class_2338 blockPos = this.method_24515();
        if (this.method_5765()) {
            super.method_5814(x, y, z);
        } else {
            super.method_5814((double)class_3532.method_15357((double)x) + 0.5, (double)class_3532.method_15357((double)(y + 0.5)), (double)class_3532.method_15357((double)z) + 0.5);
        }
        if (this.field_6012 != 0 && !(blockPos2 = this.method_24515()).equals((Object)blockPos)) {
            this.field_6011.method_12778(PEEK_AMOUNT, (Object)0);
            this.field_6007 = true;
            if (this.method_37908().method_8608() && !this.method_5765() && !blockPos2.equals((Object)this.prevAttachedBlock)) {
                this.prevAttachedBlock = blockPos;
                this.field_6038 = this.method_23317();
                this.field_5971 = this.method_23318();
                this.field_5989 = this.method_23321();
            }
        }
    }

    @Nullable
    protected class_2350 findAttachSide(class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            if (!this.canStay(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean canStay(class_2338 pos, class_2350 direction) {
        if (this.isInvalidPosition(pos)) {
            return false;
        }
        class_2350 direction2 = direction.method_10153();
        if (!this.method_37908().method_24368(pos.method_10093(direction), (class_1297)this, direction2)) {
            return false;
        }
        return this.method_37908().method_8587((class_1297)this, this.method_5829());
    }

    private boolean isInvalidPosition(class_2338 pos) {
        class_2680 blockState = this.method_37908().method_8320(pos);
        if (blockState.method_26215()) {
            return false;
        }
        boolean bl = blockState.method_27852(class_2246.field_10008) && pos.equals((Object)this.method_24515());
        return !bl;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.field_6210 = 0;
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isClosed() && source.method_5526() instanceof class_1665) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    private boolean isClosed() {
        return this.getPeekAmount() == 0;
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public class_2350 getAttachedFace() {
        return (class_2350)this.field_6011.method_12789(ATTACHED_FACE);
    }

    private void setAttachedFace(class_2350 face) {
        this.field_6011.method_12778(ATTACHED_FACE, (Object)face);
    }

    public void method_5674(class_2940<?> data) {
        if (ATTACHED_FACE.equals(data)) {
            this.method_5857(this.method_33332());
        }
        super.method_5674(data);
    }

    private int getPeekAmount() {
        return ((Byte)this.field_6011.method_12789(PEEK_AMOUNT)).byteValue();
    }

    void setPeekAmount(int peekAmount) {
        if (!this.method_37908().method_8608()) {
            this.method_5996(class_5134.field_23724).method_6202(COVERED_ARMOR_BONUS);
            this.method_5996(class_5134.field_23725).method_6202(COVERED_TOUGHNESS_BONUS);
            if (peekAmount == 0) {
                this.method_5996(class_5134.field_23724).method_26837(COVERED_ARMOR_BONUS);
                this.method_5996(class_5134.field_23725).method_26837(COVERED_TOUGHNESS_BONUS);
                this.method_5783(SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_CLOSE, 1.0f, 1.0f);
                this.method_32876((class_6880)class_5712.field_28177);
            } else {
                this.method_5783(SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_OPEN, 1.0f, 1.0f);
                this.method_32876((class_6880)class_5712.field_28176);
            }
        }
        this.field_6011.method_12778(PEEK_AMOUNT, (Object)((byte)peekAmount));
    }

    public float getOpenProgress(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevOpenProgress, (float)this.openProgress);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.field_6283 = 0.0f;
        this.field_6220 = 0.0f;
    }

    public int method_5978() {
        return 180;
    }

    public int method_5986() {
        return 180;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_6057(class_1297 entity) {
        if (entity.method_37908() != this.method_37908()) {
            return false;
        }
        class_243 thisEyePos = this.method_33571();
        class_243 entityEyePos = entity.method_33571();
        double distance = entityEyePos.method_1022(thisEyePos);
        return distance < 26.0 && (Math.abs(this.method_23320() - entity.method_23320()) < distance / 2.0 || Math.abs(this.method_23320() - entity.method_23318()) < distance / 2.0) && this.method_37908().method_17742(new class_3959(thisEyePos, entityEyePos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public float method_5871() {
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean isValidTarget(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != entity.method_37908()) return false;
        if (!class_1301.field_6156.test(entity)) return false;
        if (this.method_5722(entity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == SpectrumEntityTypes.PRESERVATION_TURRET) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    private class VibrationsCallback
    implements class_8514.class_5719 {
        private final class_5709 positionSource;

        VibrationsCallback(PreservationTurretEntity turretEntity) {
            this.positionSource = new class_5709((class_1297)turretEntity, turretEntity.method_5751());
        }

        public int method_49797() {
            return 16;
        }

        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(class_3218 world, class_2338 pos, class_6880<class_5712> event, class_5712.class_7397 emitter) {
            class_1309 livingEntity;
            class_1297 class_12972;
            return !PreservationTurretEntity.this.method_31481() && !PreservationTurretEntity.this.method_29504() && !PreservationTurretEntity.this.method_5987() && world.method_8621().method_11952(pos) && PreservationTurretEntity.this.method_37908() == world && (class_12972 = emitter.comp_713()) instanceof class_1309 && PreservationTurretEntity.this.isValidTarget((class_1297)(livingEntity = (class_1309)class_12972));
        }

        public void method_32969(class_3218 world, class_2338 pos, class_6880<class_5712> event, @Nullable class_1297 sourceEntity, @Nullable class_1297 target, float distance) {
            class_1309 livingEntity;
            if (!PreservationTurretEntity.this.method_29504() && sourceEntity instanceof class_1309 && PreservationTurretEntity.this.TARGET_PREDICATE.method_18419((class_1309)PreservationTurretEntity.this, livingEntity = (class_1309)sourceEntity)) {
                PreservationTurretEntity.this.method_5980(livingEntity);
                PreservationTurretEntity.this.setPeekAmount(100);
            }
        }
    }

    private class TurretLookControl
    extends class_1333 {
        public TurretLookControl(class_1308 entity) {
            super(entity);
        }

        protected void method_36980() {
        }

        protected Optional<Float> method_20251() {
            class_2350 attachedDirection = PreservationTurretEntity.this.getAttachedFace().method_10153();
            Vector3f southVectorCopy = new Vector3f((Vector3fc)SOUTH_VECTOR);
            southVectorCopy.rotate((Quaternionfc)attachedDirection.method_23224());
            class_2382 vec3i = attachedDirection.method_10163();
            Vector3f vec3f2 = new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
            vec3f2.cross((Vector3fc)southVectorCopy);
            double xOffset = this.field_6364 - this.field_6361.method_23317();
            double yOffset = this.field_6363 - this.field_6361.method_23320();
            double zOffset = this.field_6362 - this.field_6361.method_23321();
            Vector3f vec3f3 = new Vector3f((float)xOffset, (float)yOffset, (float)zOffset);
            float g = vec3f2.dot((Vector3fc)vec3f3);
            float h = southVectorCopy.dot((Vector3fc)vec3f3);
            return !(Math.abs(g) > 1.0E-5f) && !(Math.abs(h) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(class_3532.method_15349((double)(-g), (double)h) * 57.2957763671875)));
        }

        protected Optional<Float> method_20250() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class RatatatataGoal
    extends class_1352 {
        public RatatatataGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            class_1309 target = PreservationTurretEntity.this.method_5968();
            if (target != null) {
                PreservationTurretEntity.this.method_5988().method_6226((class_1297)target, 2.0f, 2.0f);
                if (!PreservationTurretEntity.this.method_6057((class_1297)target)) {
                    PreservationTurretEntity.this.method_5980(null);
                    return false;
                }
            }
            return target != null && target.method_5805() && (double)PreservationTurretEntity.this.openProgress == 1.0 && PreservationTurretEntity.this.TARGET_PREDICATE.method_18419((class_1309)PreservationTurretEntity.this, PreservationTurretEntity.this.method_5968());
        }

        public boolean method_6266() {
            return super.method_6266() && PreservationTurretEntity.this.TARGET_PREDICATE.method_18419((class_1309)PreservationTurretEntity.this, PreservationTurretEntity.this.method_5968());
        }

        public void method_6270() {
            PreservationTurretEntity.this.setPeekAmount(0);
        }

        public void method_6268() {
            if (PreservationTurretEntity.this.method_37908().method_8407() != class_1267.field_5801) {
                class_1309 target = PreservationTurretEntity.this.method_5968();
                if (target == null) {
                    return;
                }
                if (!PreservationTurretEntity.this.method_6057((class_1297)target)) {
                    return;
                }
                target.method_5643(PreservationTurretEntity.this.method_37908().method_48963().method_48812((class_1309)PreservationTurretEntity.this), 4.0f);
                PreservationTurretEntity.this.method_5783(SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_SHOOT, 2.0f, 1.0f + 0.2f * (PreservationTurretEntity.this.field_5974.method_43057() - PreservationTurretEntity.this.field_5974.method_43057()));
                target.method_5783(SpectrumSoundEvents.ENTITY_PRESERVATION_TURRET_SHOOT, 1.0f, 0.5f + 0.2f * (PreservationTurretEntity.this.field_5974.method_43057() - PreservationTurretEntity.this.field_5974.method_43057()));
                super.method_6268();
            }
        }
    }
}

