/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public enum ExplosionArchetype implements class_3542
{
    COSMETIC("cosmetic", false, false),
    DESTROY_BLOCKS("destroy_blocks", true, false),
    DAMAGE_ENTITIES("damage_entities", false, true),
    ALL("all", true, true);

    public final boolean affectsBlocks;
    public final boolean affectsEntities;
    private final class_2561 name;
    public static Codec<ExplosionArchetype> CODEC;
    public static final class_9139<ByteBuf, ExplosionArchetype> PACKET_CODEC;

    private ExplosionArchetype(String id, boolean affectsBlocks, boolean affectsEntities) {
        this.affectsBlocks = affectsBlocks;
        this.affectsEntities = affectsEntities;
        this.name = class_2561.method_43471((String)("explosion_archetype.spectrum." + id));
    }

    public static ExplosionArchetype tryParse(String name) {
        try {
            return ExplosionArchetype.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return COSMETIC;
        }
    }

    public static ExplosionArchetype get(boolean affectsBlocks, boolean affectsEntities) {
        if (affectsBlocks) {
            return affectsEntities ? ALL : DESTROY_BLOCKS;
        }
        return affectsEntities ? DAMAGE_ENTITIES : COSMETIC;
    }

    public class_2561 getName() {
        return this.name;
    }

    @NotNull
    public String method_15434() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = class_3542.method_28140(ExplosionArchetype::values);
        PACKET_CODEC = PacketCodecHelper.enumOf(ExplosionArchetype::values);
    }
}

