/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.mixin.accessors.CachedRegistryInfoGetterAccessor;
import de.dafuqs.spectrum.mixin.accessors.RegistryOpsAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.apache.commons.lang3.math.Fraction;

public class CodecHelper {
    public static Codec<Fraction> FRACTION = Codec.mapPair((MapCodec)Codec.INT.fieldOf("numerator"), (MapCodec)Codec.INT.fieldOf("denominator")).codec().xmap(pair -> Fraction.getFraction((int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond())), frac -> new Pair((Object)frac.getNumerator(), (Object)frac.getDenominator()));
    public static Codec<class_2960> SPECTRUM_DEFAULTED_IDENTIFIER = Codec.STRING.xmap(SpectrumCommon::ofSpectrumDefaulted, class_2960::toString);
    public static MapCodec<class_7225.class_7874> LOOKUP = new MapCodec<class_7225.class_7874>(){

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.empty();
        }

        public <T> DataResult<class_7225.class_7874> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            if (dynamicOps instanceof class_6903) {
                class_6903 registryOps = (class_6903)dynamicOps;
                class_6903.class_7863 infoGetter = ((RegistryOpsAccessor)registryOps).getLookupProvider();
                class_7225.class_7874 lookup = ((CachedRegistryInfoGetterAccessor)infoGetter).getLookupProvider();
                return DataResult.success((Object)lookup);
            }
            return DataResult.error(() -> "The LOOKUP codec requires RegistryOps.");
        }

        public <T> RecordBuilder<T> encode(class_7225.class_7874 wrapperLookup, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            return recordBuilder;
        }
    };

    public static <L, R> MapCodec<class_3545<L, R>> mapPair(MapCodec<L> leftCodec, MapCodec<R> rightCodec) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)leftCodec.forGetter(class_3545::method_15442), (App)rightCodec.forGetter(class_3545::method_15441)).apply((Applicative)i, class_3545::new));
    }

    public static <K, V> MapCodec<Map<K, V>> registryMap(final class_2378<K> registry, final Codec<V> valueCodec) {
        final Codec keyCodec = registry.method_39673();
        return new MapCodec<Map<K, V>>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return registry.keys(dynamicOps);
            }

            public <T> DataResult<Map<K, V>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return DataResult.success((Object)mapLike.entries().map(entry -> {
                    Object keyResult = keyCodec.decode(dynamicOps, entry.getFirst()).result().map(Pair::getFirst).orElse(null);
                    Object valueResult = valueCodec.decode(dynamicOps, entry.getSecond()).result().map(Pair::getFirst).orElse(null);
                    if (keyResult == null || valueResult == null) {
                        return null;
                    }
                    return new class_3545(keyResult, valueResult);
                }).filter(Objects::nonNull).collect(HashMap::new, (map, pair) -> map.put(pair.method_15442(), pair.method_15441()), HashMap::putAll));
            }

            public <T> RecordBuilder<T> encode(Map<K, V> kvMap, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                for (Map.Entry entry : kvMap.entrySet()) {
                    DataResult keyData = keyCodec.encodeStart(dynamicOps, entry.getKey());
                    DataResult valueData = valueCodec.encodeStart(dynamicOps, entry.getValue());
                    recordBuilder.add(keyData, valueData);
                }
                return recordBuilder;
            }
        };
    }

    public static <T> Codec<List<T>> singleOrList(Codec<T> codec) {
        return Codec.withAlternative((Codec)codec.listOf(), codec, List::of);
    }

    public static <I, O, E extends Throwable> Function<I, DataResult<O>> throwable(ThrowableFunction<I, O, E> throwable) {
        return input -> {
            try {
                return DataResult.success(throwable.apply(input));
            }
            catch (Throwable e) {
                return DataResult.error(e::getMessage);
            }
        };
    }

    public static <T, D> Optional<T> from(DynamicOps<D> ops, Codec<T> codec, D elem) {
        if (elem == null) {
            return Optional.empty();
        }
        return codec.decode(ops, elem).result().map(Pair::getFirst);
    }

    public static <T> Optional<T> fromNbt(Codec<T> codec, class_2520 nbt) {
        return CodecHelper.from(class_2509.field_11560, codec, nbt);
    }

    public static <T> T fromNbt(Codec<T> codec, class_2520 nbt, T defaultValue) {
        return CodecHelper.fromNbt(codec, nbt).orElse(defaultValue);
    }

    public static <T> Optional<T> fromJson(Codec<T> codec, JsonElement json) {
        return CodecHelper.from(JsonOps.INSTANCE, codec, json);
    }

    public static <T> T fromJson(Codec<T> codec, JsonElement json, T defaultValue) {
        return CodecHelper.fromJson(codec, json).orElse(defaultValue);
    }

    public static <T> void toNbt(Codec<T> codec, T value, Consumer<? super class_2520> ifValid) {
        codec.encodeStart((DynamicOps)class_2509.field_11560, value).result().ifPresent(ifValid);
    }

    public static <T> void writeNbt(class_2487 nbt, String key, Codec<T> codec, T value) {
        CodecHelper.toNbt(codec, value, elem -> nbt.method_10566(key, elem));
    }

    public static interface ThrowableFunction<I, O, E extends Throwable> {
        public O apply(I var1) throws E;
    }
}

