/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SchedulerMap<K>
implements Iterable<Map.Entry<K, Integer>> {
    private final Map<K, Integer> map;

    public SchedulerMap() {
        this(new HashMap());
    }

    public SchedulerMap(Map<K, Integer> map) {
        this.map = map;
    }

    public void put(K val, int ticks) {
        this.map.put(val, ticks);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K val) {
        return this.map.containsKey(val);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int get(K val) {
        return this.map.get(val);
    }

    public final String toString() {
        return this.map.toString();
    }

    public final int size() {
        return this.map.size();
    }

    public void tick() {
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<K, Integer>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Freezable freezableTimer;
                Map.Entry<K, Integer> next = iterator.next();
                K key = next.getKey();
                if (key instanceof Freezable && (freezableTimer = (Freezable)key).isFrozen()) continue;
                if (next.getValue() >= 1) {
                    next.setValue(next.getValue() - 1);
                    continue;
                }
                if (key instanceof Callback) {
                    ((Callback)key).trigger();
                }
                iterator.remove();
            }
        }
    }

    @Override
    public Iterator<Map.Entry<K, Integer>> iterator() {
        return this.map.entrySet().iterator();
    }

    public static <K> Codec<SchedulerMap<K>> getCodec(Codec<Pair<K, Integer>> entryCodec) {
        return Codec.list(entryCodec).xmap(list -> {
            HashMap map = new HashMap();
            list.forEach(p -> map.put(p.getFirst(), (Integer)p.getSecond()));
            return new SchedulerMap(map);
        }, m -> m.map.entrySet().stream().map(e -> new Pair(e.getKey(), (Object)((Integer)e.getValue()))).toList());
    }

    public Map<K, Integer> getMap() {
        return this.map;
    }

    public static interface Freezable
    extends Callback {
        public boolean isFrozen();
    }

    public static interface Callback {
        public void trigger();
    }
}

