/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class TickLooper {
    public static final Codec<TickLooper> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("max").forGetter(TickLooper::getMaxTick), (App)Codec.INT.fieldOf("current").forGetter(TickLooper::getTick)).apply((Applicative)i, TickLooper::new));
    private final int maxTick;
    private int currentTick;

    public TickLooper(int maxTick) {
        this(maxTick, 0);
    }

    private TickLooper(int maxTick, int currentTick) {
        this.maxTick = maxTick;
        this.currentTick = currentTick;
    }

    public void tick() {
        ++this.currentTick;
    }

    public boolean reachedCap() {
        return this.currentTick >= this.maxTick;
    }

    public void reset() {
        this.currentTick = 0;
    }

    public int getTick() {
        return this.currentTick;
    }

    public int getMaxTick() {
        return this.maxTick;
    }

    public float getProgress() {
        return (float)this.currentTick / (float)this.maxTick;
    }

    public String toString() {
        return "TickLooper (" + this.currentTick + "/" + this.maxTick + ")";
    }

    public static TickLooper readNbt(class_2487 nbt) {
        return new TickLooper(nbt.method_10550("max"), nbt.method_10550("current"));
    }

    public class_2520 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("max", this.maxTick);
        nbt.method_10569("current", this.currentTick);
        return nbt;
    }
}

