/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerConfiguration;
import de.dafuqs.spectrum.data_loaders.ParticleSpawnerParticlesDataLoader;
import de.dafuqs.spectrum.inventories.ParticleSpawnerScreenHandler;
import de.dafuqs.spectrum.networking.c2s_payloads.ParticleSpawnerConfigurationC2SPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_7764;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ParticleSpawnerScreen
extends class_465<ParticleSpawnerScreenHandler> {
    protected static final class_2960 GUI_TEXTURE = SpectrumCommon.locate("textures/gui/container/particle_spawner.png");
    protected static final int PARTICLES_PER_PAGE = 6;
    protected static final int TEXT_COLOR = 0x222222;
    protected class_1059 spriteAtlasTexture;
    protected boolean glowing = false;
    protected boolean collisionsEnabled = false;
    protected int activeParticlePage = 0;
    protected int particleSelectionIndex = 0;
    protected boolean selectedParticleSupportsColoring = false;
    private final List<class_339> selectableWidgets = new ArrayList<class_339>();
    private class_342 cyanField;
    private class_342 magentaField;
    private class_342 yellowField;
    private class_342 amountField;
    private class_342 positionXField;
    private class_342 positionYField;
    private class_342 positionZField;
    private class_342 positionXVarianceField;
    private class_342 positionYVarianceField;
    private class_342 positionZVarianceField;
    private class_342 velocityXField;
    private class_342 velocityYField;
    private class_342 velocityZField;
    private class_342 velocityXVarianceField;
    private class_342 velocityYVarianceField;
    private class_342 velocityZVarianceField;
    private class_342 scale;
    private class_342 scaleVariance;
    private class_342 duration;
    private class_342 durationVariance;
    private class_342 gravity;
    private class_4185 glowingButton;
    private class_4185 collisionsButton;
    private class_4185 backButton;
    private class_4185 forwardButton;
    private List<class_4185> particleButtons;
    private List<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry> displayedParticleEntries = new ArrayList<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry>();

    public ParticleSpawnerScreen(ParticleSpawnerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_25267 = 48;
        this.field_25268 = 7;
        this.field_2779 = 243;
    }

    protected void method_25426() {
        super.method_25426();
        this.spriteAtlasTexture = ((ParticleManagerAccessor)this.field_22787.field_1713).getParticleAtlasTexture();
        this.displayedParticleEntries = ParticleSpawnerParticlesDataLoader.getAllUnlocked((class_1657)this.field_22787.field_1724);
        this.selectableWidgets.clear();
        this.setupInputFields(((ParticleSpawnerScreenHandler)this.field_2797).getBlockEntity());
        this.method_48265((class_364)this.amountField);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_364 focusedElement;
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        if ((focusedElement = this.method_25399()) instanceof class_342) {
            class_342 focusedTextFieldWidget = (class_342)focusedElement;
            if (keyCode == 258) {
                int currentIndex = this.selectableWidgets.indexOf(focusedElement);
                focusedTextFieldWidget.method_25365(false);
                if (modifiers == 1) {
                    this.method_25395((class_364)this.selectableWidgets.get((this.selectableWidgets.size() + currentIndex - 1) % this.selectableWidgets.size()));
                } else {
                    this.method_25395((class_364)this.selectableWidgets.get((currentIndex + 1) % this.selectableWidgets.size()));
                }
            }
            return focusedElement.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_25420(drawContext, mouseX, mouseY, delta);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.renderForeground(drawContext, mouseX, mouseY, delta);
        this.method_2380(drawContext, mouseX, mouseY);
    }

    public void renderForeground(class_332 drawContext, int mouseX, int mouseY, float delta) {
        for (class_339 widget : this.selectableWidgets) {
            if (!(widget instanceof class_342)) continue;
            widget.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        class_327 tr = this.field_22793;
        drawContext.method_51439(tr, this.field_22785, this.field_25267, this.field_25268, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.color_c").method_27692(class_124.field_1075), 7, 54, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.color_m").method_27692(class_124.field_1076), 47, 54, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.color_y").method_27692(class_124.field_1065), 90, 54, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.glow"), 130, 54, 0x222222, false);
        int offset = 23;
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.particle_count"), 10, 51 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.pos_x"), 66, 64 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.pos_y"), 99, 64 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.pos_z"), 134, 64 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.offset"), 10, 78 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 21, 97 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.velocity"), 10, 117 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 21, 137 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.scale"), 10, 161 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 91, 161 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.duration"), 10, 181 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 91, 181 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.gravity"), 10, 201 + offset, 0x222222, false);
        drawContext.method_51439(tr, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.collisions"), 90, 201 + offset, 0x222222, false);
    }

    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
        int spriteIndex;
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25302(GUI_TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
        if (!this.selectedParticleSupportsColoring) {
            drawContext.method_25302(GUI_TEXTURE, x + 15, y + 50, 214, 0, 31, 16);
            drawContext.method_25302(GUI_TEXTURE, x + 56, y + 50, 214, 0, 31, 16);
            drawContext.method_25302(GUI_TEXTURE, x + 97, y + 50, 214, 0, 31, 16);
        }
        if (this.collisionsEnabled) {
            drawContext.method_25302(GUI_TEXTURE, x + 146, y + 220, 176, 0, 16, 16);
        }
        if (this.glowing) {
            drawContext.method_25302(GUI_TEXTURE, x + 153, y + 50, 176, 0, 16, 16);
        }
        if (this.particleSelectionIndex / 6 == this.activeParticlePage) {
            drawContext.method_25302(GUI_TEXTURE, x + 27 + 20 * (this.particleSelectionIndex % 6), y + 19, 192, 0, 22, 22);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)this.spriteAtlasTexture.method_24106());
        int firstDisplayedEntryId = 6 * this.activeParticlePage;
        for (int j = 0; j < 6 && (spriteIndex = firstDisplayedEntryId + j) < this.displayedParticleEntries.size(); ++j) {
            class_1058 particleSprite = this.spriteAtlasTexture.method_4608(this.displayedParticleEntries.get(spriteIndex).textureIdentifier());
            class_7764 contents = particleSprite.method_45851();
            drawContext.method_25298(x + 38 + j * 20 - contents.method_45807() / 2, y + 31 - contents.method_45815() / 2, 0, contents.method_45807(), contents.method_45815(), particleSprite);
        }
    }

    protected void setupInputFields(ParticleSpawnerBlockEntity blockEntity) {
        int startX = (this.field_22789 - this.field_2792) / 2 + 3;
        int startY = (this.field_22790 - this.field_2779) / 2 + 3;
        ParticleSpawnerConfiguration configuration = blockEntity.getConfiguration();
        this.cyanField = this.addTextFieldWidget(startX + 16, startY + 51, (class_2561)class_2561.method_43470((String)"Cyan"), String.valueOf(configuration.cmyColor().method_10263()), this::isPositiveDecimalNumber100);
        this.magentaField = this.addTextFieldWidget(startX + 57, startY + 51, (class_2561)class_2561.method_43470((String)"Magenta"), String.valueOf(configuration.cmyColor().method_10264()), this::isPositiveDecimalNumber100);
        this.yellowField = this.addTextFieldWidget(startX + 97, startY + 51, (class_2561)class_2561.method_43470((String)"Yellow"), String.valueOf(configuration.cmyColor().method_10260()), this::isPositiveDecimalNumber100);
        this.glowingButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.spectrum.button.glowing"), this::glowingButtonPressed).method_46437(16, 16).method_46433(startX + 153, startY + 50).method_46431();
        this.method_25429((class_364)this.glowingButton);
        this.glowing = configuration.glowing();
        int offset = 23;
        this.amountField = this.addTextFieldWidget(startX + 110, startY + 48 + offset, (class_2561)class_2561.method_43470((String)"Particles per Second"), String.valueOf(configuration.particlesPerSecond()), this::isPositiveDecimalNumberUnderThousand);
        this.positionXField = this.addTextFieldWidget(startX + 61, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"X Position"), String.valueOf(configuration.sourcePosition().field_1352), this::isAbsoluteDecimalNumberThousand);
        this.positionYField = this.addTextFieldWidget(startX + 96, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"Y Position"), String.valueOf(configuration.sourcePosition().field_1351), this::isAbsoluteDecimalNumberThousand);
        this.positionZField = this.addTextFieldWidget(startX + 131, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"Z Position"), String.valueOf(configuration.sourcePosition().field_1350), this::isAbsoluteDecimalNumberThousand);
        this.positionXVarianceField = this.addTextFieldWidget(startX + 69, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"X Position Variance"), String.valueOf(configuration.sourcePositionVariance().field_1352), this::isAbsoluteDecimalNumberThousand);
        this.positionYVarianceField = this.addTextFieldWidget(startX + 104, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"Y Position Variance"), String.valueOf(configuration.sourcePositionVariance().field_1351), this::isAbsoluteDecimalNumberThousand);
        this.positionZVarianceField = this.addTextFieldWidget(startX + 140, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"Z Position Variance"), String.valueOf(configuration.sourcePositionVariance().field_1350), this::isAbsoluteDecimalNumberThousand);
        this.velocityXField = this.addTextFieldWidget(startX + 61, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"X Velocity"), String.valueOf(configuration.velocity().field_1352), this::isAbsoluteDecimalNumberThousand);
        this.velocityYField = this.addTextFieldWidget(startX + 96, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"Y Velocity"), String.valueOf(configuration.velocity().field_1351), this::isAbsoluteDecimalNumberThousand);
        this.velocityZField = this.addTextFieldWidget(startX + 131, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"Z Velocity"), String.valueOf(configuration.velocity().field_1350), this::isAbsoluteDecimalNumberThousand);
        this.velocityXVarianceField = this.addTextFieldWidget(startX + 69, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"X Velocity Variance"), String.valueOf(configuration.velocityVariance().field_1352), this::isAbsoluteDecimalNumberThousand);
        this.velocityYVarianceField = this.addTextFieldWidget(startX + 104, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"Y Velocity Variance"), String.valueOf(configuration.velocityVariance().field_1351), this::isAbsoluteDecimalNumberThousand);
        this.velocityZVarianceField = this.addTextFieldWidget(startX + 140, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"Z Velocity Variance"), String.valueOf(configuration.velocityVariance().field_1350), this::isAbsoluteDecimalNumberThousand);
        this.scale = this.addTextFieldWidget(startX + 55, startY + 158 + offset, (class_2561)class_2561.method_43470((String)"Scale"), String.valueOf(configuration.scale()), this::isPositiveDecimalNumberUnderTen);
        this.scaleVariance = this.addTextFieldWidget(startX + 139, startY + 158 + offset, (class_2561)class_2561.method_43470((String)"Scale Variance"), String.valueOf(configuration.scaleVariance()), this::isPositiveDecimalNumberUnderTen);
        this.duration = this.addTextFieldWidget(startX + 55, startY + 178 + offset, (class_2561)class_2561.method_43470((String)"Duration"), String.valueOf(configuration.lifetimeTicks()), this::isPositiveWholeNumberUnderThousand);
        this.durationVariance = this.addTextFieldWidget(startX + 139, startY + 178 + offset, (class_2561)class_2561.method_43470((String)"Duration Variance"), String.valueOf(configuration.lifetimeVariance()), this::isPositiveWholeNumberUnderThousand);
        this.gravity = this.addTextFieldWidget(startX + 55, startY + 198 + offset, (class_2561)class_2561.method_43470((String)"Gravity"), String.valueOf(configuration.gravity()), this::isBetweenZeroAndOne);
        this.collisionsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.spectrum.button.collisions"), this::collisionButtonPressed).method_46433(startX + 142, startY + 194 + offset).method_46437(16, 16).method_46431();
        this.collisionsEnabled = configuration.collisions();
        this.method_25429((class_364)this.collisionsButton);
        this.selectableWidgets.add((class_339)this.cyanField);
        this.selectableWidgets.add((class_339)this.magentaField);
        this.selectableWidgets.add((class_339)this.yellowField);
        this.selectableWidgets.add((class_339)this.glowingButton);
        this.selectableWidgets.add((class_339)this.amountField);
        this.selectableWidgets.add((class_339)this.positionXField);
        this.selectableWidgets.add((class_339)this.positionYField);
        this.selectableWidgets.add((class_339)this.positionZField);
        this.selectableWidgets.add((class_339)this.positionXVarianceField);
        this.selectableWidgets.add((class_339)this.positionYVarianceField);
        this.selectableWidgets.add((class_339)this.positionZVarianceField);
        this.selectableWidgets.add((class_339)this.velocityXField);
        this.selectableWidgets.add((class_339)this.velocityYField);
        this.selectableWidgets.add((class_339)this.velocityZField);
        this.selectableWidgets.add((class_339)this.velocityXVarianceField);
        this.selectableWidgets.add((class_339)this.velocityYVarianceField);
        this.selectableWidgets.add((class_339)this.velocityZVarianceField);
        this.selectableWidgets.add((class_339)this.scale);
        this.selectableWidgets.add((class_339)this.scaleVariance);
        this.selectableWidgets.add((class_339)this.duration);
        this.selectableWidgets.add((class_339)this.durationVariance);
        this.selectableWidgets.add((class_339)this.gravity);
        this.selectableWidgets.add((class_339)this.collisionsButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.spectrum.button.back"), this::navigationButtonPressed).method_46437(12, 14).method_46433(startX + 11, startY + 19).method_46431();
        this.method_25429((class_364)this.backButton);
        this.forwardButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.spectrum.button.forward"), this::navigationButtonPressed).method_46437(12, 14).method_46433(startX + 147, startY + 19).method_46431();
        this.method_25429((class_364)this.forwardButton);
        this.particleButtons = List.of(this.addParticleButton(startX + 23, startY + 16), this.addParticleButton(startX + 23 + 20, startY + 16), this.addParticleButton(startX + 23 + 40, startY + 16), this.addParticleButton(startX + 23 + 60, startY + 16), this.addParticleButton(startX + 23 + 80, startY + 16), this.addParticleButton(startX + 23 + 100, startY + 16));
        this.particleSelectionIndex = 0;
        int particleIndex = 0;
        for (ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry availableParticle : this.displayedParticleEntries) {
            if (availableParticle.particleType().equals(configuration.particleType())) {
                this.particleSelectionIndex = particleIndex;
                break;
            }
            ++particleIndex;
        }
        if (this.displayedParticleEntries.isEmpty()) {
            this.setColoringEnabled(false);
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(this.particleSelectionIndex);
        this.setColoringEnabled(entry.supportsColoring());
    }

    private void navigationButtonPressed(class_4185 buttonWidget) {
        int pageCount = this.displayedParticleEntries.size() / 6;
        if (pageCount == 0) {
            return;
        }
        this.activeParticlePage = buttonWidget == this.forwardButton ? (this.activeParticlePage + 1) % pageCount : (this.activeParticlePage - 1 + pageCount) % pageCount;
    }

    @NotNull
    private class_342 addTextFieldWidget(int x, int y, class_2561 text, String defaultText, Predicate<String> textPredicate) {
        class_342 textFieldWidget = new class_342(this.field_22793, x, y, 31, 16, text);
        textFieldWidget.method_1890(textPredicate);
        textFieldWidget.method_1856(true);
        textFieldWidget.method_1888(true);
        textFieldWidget.method_1868(-1);
        textFieldWidget.method_1860(-1);
        textFieldWidget.method_1858(false);
        textFieldWidget.method_1880(6);
        textFieldWidget.method_1852(defaultText);
        textFieldWidget.method_1863(this::onTextBoxValueChanged);
        this.method_25429((class_364)textFieldWidget);
        return textFieldWidget;
    }

    @NotNull
    private class_4185 addParticleButton(int x, int y) {
        class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.spectrum.button.particles"), this::particleButtonPressed).method_46437(20, 20).method_46433(x, y).method_46431();
        this.method_25429((class_364)button);
        return button;
    }

    private void particleButtonPressed(class_4185 buttonWidget) {
        int buttonIndex = this.particleButtons.indexOf(buttonWidget);
        int newIndex = 6 * this.activeParticlePage + buttonIndex;
        if (newIndex >= this.displayedParticleEntries.size()) {
            return;
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(newIndex);
        this.setColoringEnabled(entry.supportsColoring());
        if (newIndex < this.displayedParticleEntries.size()) {
            this.particleSelectionIndex = newIndex;
            this.onValuesChanged();
        }
    }

    private void setColoringEnabled(boolean enabled) {
        this.selectedParticleSupportsColoring = enabled;
        this.cyanField.method_1888(enabled);
        this.magentaField.method_1888(enabled);
        this.yellowField.method_1888(enabled);
        this.cyanField.method_1856(enabled);
        this.magentaField.method_1856(enabled);
        this.yellowField.method_1856(enabled);
        this.cyanField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.magentaField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.yellowField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.method_25395((class_364)this.amountField);
    }

    private void collisionButtonPressed(class_4185 buttonWidget) {
        this.collisionsEnabled = !this.collisionsEnabled;
        this.onValuesChanged();
    }

    private void glowingButtonPressed(class_4185 buttonWidget) {
        this.glowing = !this.glowing;
        this.onValuesChanged();
    }

    private void onTextBoxValueChanged(@NotNull String newValue) {
        this.onValuesChanged();
    }

    private boolean isPositiveDecimalNumberUnderThousand(String text) {
        try {
            return Double.parseDouble(text) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isAbsoluteDecimalNumberThousand(String text) {
        try {
            return Math.abs(Double.parseDouble(text)) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumber100(String text) {
        try {
            int number = Integer.parseInt(text);
            return number >= 0 && number <= 100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumberUnderTen(String text) {
        try {
            return Double.parseDouble(text) < 10.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isPositiveWholeNumberUnderThousand(@NotNull String text) {
        try {
            return Integer.parseInt(text) < 1000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isBetweenZeroAndOne(@NotNull String text) {
        try {
            float f = Float.parseFloat(text);
            return f >= 0.0f && f <= 1.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void onValuesChanged() {
        try {
            ParticleSpawnerConfiguration configuration = new ParticleSpawnerConfiguration(this.displayedParticleEntries.get(this.particleSelectionIndex).particleType(), this.selectedParticleSupportsColoring ? new class_2382(Math.round(Float.parseFloat(this.cyanField.method_1882())), Math.round(Float.parseFloat(this.magentaField.method_1882())), Math.round(Float.parseFloat(this.yellowField.method_1882()))) : new class_2382(0, 0, 0), this.glowing, Float.parseFloat(this.amountField.method_1882()), new class_243(Double.parseDouble(this.positionXField.method_1882()), Double.parseDouble(this.positionYField.method_1882()), Double.parseDouble(this.positionZField.method_1882())), new class_243(Double.parseDouble(this.positionXVarianceField.method_1882()), Double.parseDouble(this.positionYVarianceField.method_1882()), Double.parseDouble(this.positionZVarianceField.method_1882())), new class_243(Double.parseDouble(this.velocityXField.method_1882()), Double.parseDouble(this.velocityYField.method_1882()), Double.parseDouble(this.velocityZField.method_1882())), new class_243(Double.parseDouble(this.velocityXVarianceField.method_1882()), Double.parseDouble(this.velocityYVarianceField.method_1882()), Double.parseDouble(this.velocityZVarianceField.method_1882())), Float.parseFloat(this.scale.method_1882()), Float.parseFloat(this.scaleVariance.method_1882()), Integer.parseInt(this.duration.method_1882()), Integer.parseInt(this.durationVariance.method_1882()), Float.parseFloat(this.gravity.method_1882()), this.collisionsEnabled);
            ClientPlayNetworking.send((class_8710)new ParticleSpawnerConfigurationC2SPayload(configuration));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

